#ifndef MENU_H
#define MENU_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Gameengine.h"
//*using the UpDown_counter example in class 201.
struct State {
  int output;
  int next_state[4]; 
};

/** Menu class
* @ 1 build three page to choose
* @ 2 build a good welcome_page
* @ 3 connect with the gamepad and makesure the game is working
* @ date April 27th 2020
* @ author Yaomochu

* @code

#include "N5110.h"
#include "Gamepad.h"
#include "mbed.h"
#include "menu.h"

N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad gamepad;
menu _menu;

int main() {
  gamepad.init();
  _menu.init(); 
  lcd.init(); 
  lcd.normalMode();      
  lcd.setBrightness(0.5); 
  while(1) {
    
    // clear, refresh lcd and run the menu.
    lcd.clear();  
    _menu.run_engine(lcd, gamepad);   
    lcd.refresh();
    wait(0.01);  
  }     
}  

* @endcode
*/

class Menu {
 public:
    Menu();
    ~Menu();
    void init();
    void run_engine(N5110 &lcd, Gamepad &gamepad);
    void run_game(N5110 &lcd, Gamepad &gamepad);

    
private:
    void display_page1(N5110 &lcd, Gamepad &gamepad);
    void display_page2(N5110 &lcd, Gamepad &gamepad);
    void get_output(N5110 &lcd, Gamepad &gamepad);
    void get_input(bool start, bool back, bool b);
    Gameengine _game_engine;
    int _input_value;
    int _output;
    int _state;
    };
#endif
    
    