#ifndef EXPLORER_H
#define EXPLORER_H


#include "mbed.h"
#include "Gamepad.h"
#include "surface.h"
//use the enum to define the value we need for the explorer
enum Explorer_sprite {Move_right,Move_left,Stand_left, Stand_right};
//we have four sprite form so we can define the sprite on the screen by using these enum
//the explorer's direction
enum Player_direction {right,left};

/** Explorer Class
* @the explorer file has three functions
* @ 1 the movement of a explorer to jump and move in left or right direction
* @ 2 check fallen and collision
* @ 3 reset the game
* @ date April 15th 2020
* @ author Yaomochu

* @code

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "explorer.h"
#include <cstdlib>
#include <ctime>

Gamepad gamepad;
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Explorer _player;

int _player_x; 
int _player_y;
bool _f_flag;
bool _r_flag;
bool _start_flag;
int _speed;
int _jump_height;
Player_direction _player_direction;
Explorer_sprite _explorer_sprite;  

int main() {
  _player.init();
  _start_flag = true;
  while(1) {
    
    // Y coordinate
    if (_f_flag == true) 
    {
      _player.fall(_f_flag, gamepad);
    } else {
    _player.set_y_coordinate(false, _jump_height); }  
    _f_flag = _player.get_fall_flag(); 
    _player_y = _player.get_y();
    _jump_height = _player.get_jump_height();
    
    // X coordinate
    _player_x = _player.get_x();
    _speed = _player.get_speed(); 
    _player.set_x_coordinate(1, _speed, _player_direction); 
 
        
    //change in to a new direction.
    _player_direction = _player.get_direction();
    
    _r_flag = _player.get_reset_flag(); 

    lcd.drawSprite(_player_x,_player_y,10,10,(int *)_player.get_form(_explorer_sprite));//draw the player
  }  
}

* @endcode
*/

class Explorer {
 public:
 Explorer();
 //Constructor
 ~Explorer();
 //Destructor
void init();
void set_x_coordinate(float joy_x, int speed, Player_direction direction);
void set_y_coordinate(bool ifjump, int jump_height);
int get_y();
 
int get_x();

int get_speed();

int get_jump_height();

Player_direction get_direction();

Explorer_sprite get_explorer_sprite();

int * get_form(Explorer_sprite sprite);
//this function is used to get the players form and print on the screen (same as the item file)

void fall(bool f_flag, Gamepad &gamepad);
//the fall flag need to add music to hint the player that the game is over
void reset_flag(bool flag);
//the reset flag also need to add music to hint the player that the game has been reseted
bool get_fall_flag();

bool get_reset_flag();
 
 private:
    
int _x;
int _y;
int _speed;
int _jump_height;
bool _f_flag;
bool _r_flag;
Line _line_1;
Line _line_2;
Line _line_3;
Line _line_4;
Line _line_5;
Line _line_6;
Player_direction _player_direction;
Explorer_sprite _explorer_sprite;   
};
#endif
