#include "main.h"
#include "N5110.h"
#include "Gamepad.h"
//#include "Sprites.h"

Gamepad pad;
//Sprites sprites;
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
AnalogIn pot0(PTB2);

int main()
{
    init();
    start_screen();

    while (1) {

        contrast();
    }

}

void init()
{
    lcd.init();
    lcd.normalMode();      // normal colour mode
    lcd.setBrightness(0.5); // put LED backlight on 50%
    lcd.refresh();
    pad.init();
    pad.leds_off();
}

void contrast()
{
    lcd.refresh();
    float con = pot0.read();
    lcd.setContrast(con);


}

void start_screen()
{
    lcd.printString("******MANIC MILNER!******",0,1);
    lcd.printString("  Press start to play! ",0,4);
    lcd.refresh();

    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
}