#include "ShootEngine.h"
ShootEngine::ShootEngine()
{

}

ShootEngine::~ShootEngine()
{

}
// A 21*35 reactangle to draw the image when the game ends using Bitmap.
static int sprite_gameover[]= 

    {0,1,1,1,1,1,1,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,1,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,0,0,0,1,1,0,0,0,0,1,1,0,1,1,1,1,1,1,1,1,
    1,1,1,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,0,0,1,1,1,0,1,1,1,0,0,0,0,0,
    1,1,1,0,0,0,1,1,0,1,1,1,0,0,1,1,1,0,1,1,1,1,1,1,1,1,0,1,1,1,0,0,0,0,0,
    1,1,1,0,0,0,0,0,0,1,1,1,0,0,1,1,1,0,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,
    1,1,1,0,1,1,1,1,0,1,1,1,0,0,1,1,1,0,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,
    1,1,1,0,1,1,1,1,0,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,0,1,1,1,0,0,0,0,0,
    1,1,1,0,0,1,1,1,0,1,1,1,1,1,1,1,1,0,1,1,0,1,1,0,1,1,0,1,1,1,0,0,0,0,0,
    1,1,1,1,1,1,1,1,0,1,1,1,0,0,1,1,1,0,1,1,0,1,1,0,1,1,0,1,1,1,1,1,1,1,1,
    0,1,1,1,1,1,1,1,0,1,1,1,0,0,1,1,1,0,1,1,0,1,1,0,1,1,0,1,1,1,1,1,1,1,1,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,
    1,1,1,1,1,1,1,1,0,1,1,0,0,0,0,1,1,0,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,
    1,1,0,0,0,0,1,1,0,1,1,0,0,0,0,1,1,0,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,
    1,1,0,0,0,0,1,1,0,1,1,0,0,0,0,1,1,0,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,
    1,1,0,0,0,0,1,1,0,1,1,0,0,0,0,1,1,0,1,1,1,1,1,1,1,1,0,1,1,0,0,0,1,1,1,
    1,1,0,0,0,0,1,1,0,1,1,1,0,0,1,1,1,0,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,
    1,1,0,0,0,0,1,1,0,1,1,1,1,1,1,1,1,0,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,0,
    1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,0,
    1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,0,1,1,0,0,0,1,1,1,
    0,1,1,1,1,1,1,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,1,1,0,0,0,1,1,1
};

void ShootEngine::init(Gamepad &pad)
{
    // initialise the game parameters
    speed = 1;
    _sight.init();
    _target.init(speed,pad);
}


void ShootEngine::read_input(Gamepad &pad) //receive the direction and magnitude from gamepad
{
    _d = pad.get_direction();
    _mag = pad.get_mag();
    
}


void ShootEngine::draw(N5110 &lcd)
{
    // draw the elements in the LCD buffer
    //score
    print_scores(lcd);
    // sight
    _sight.draw(lcd);
    // Target
    _target.draw(lcd);
    lcd.refresh();
}




void ShootEngine::update(Gamepad &pad, N5110 &lcd)
{
    _sight.update(_d,_mag);// update magnitude and direction before checking
    _target.update();
    
    check_hit_wall(pad,lcd);
    check_hit_target(pad);


}

void ShootEngine::check_hit_wall(Gamepad &pad,N5110 &lcd)
{    
    Vector2D target_pos = _target.get_pos();
    if (target_pos.y <= 6) {  //  the radius of the target is 6
       gameover(pad, lcd);
    }  
    
    }
void ShootEngine::check_hit_target(Gamepad &pad)
{ 
     Vector2D target_pos = _target.get_pos();//get the position of target
     Vector2D sight_pos = _sight.get_pos();// get the position of sight
     while (pad.check_event(Gamepad::X_PRESSED) == true &&//compare the positons between target and sight
         sight_pos.x <= target_pos.x + 5 && 
         sight_pos.x >= target_pos.x -5 &&
         sight_pos.y <= target_pos.y +5 &&
         sight_pos.y >= target_pos.y -5 ) 
     //prrintf("sight_pos.x: %i\n", sight_pos.x);
     //prrintf("sight_pos.y: %i\n", sight_pos.y);
     //prrintf("target_pos.x: %i\n", target_pos.x);
     //prrintf("target_pos.y: %i\n", target_pos.y);
     
     
     {
         _sight.add_score();
         set_speed(pad);
        _target.init(speed,pad);
        pad.tone(1000.0,0.5);
        pad.leds_on();
        wait(0.5);
        pad.leds_off();
     }
     }
     
void ShootEngine::set_speed(Gamepad &pad)// 3 different speed can be choosed by player
{
    if (pad.check_event(Gamepad::A_PRESSED) == true){
        speed = 2;
    } else if (pad.check_event(Gamepad::B_PRESSED) == true){
        speed = 3;
    } else if (pad.check_event(Gamepad::Y_PRESSED) == true){
        speed = 3.5;
    }   
    //printf("_speed: @i\n", _speed);   
}
     
void ShootEngine::print_scores(N5110 &lcd)
{
    // get scores from sight
    int sight_score = _sight.get_score();

    // print to LCD 
    char buffer[5];
    sprintf(buffer,"%2d",sight_score);//display the buffer on  the screen
    lcd.printString(buffer,68,1);  
}

void ShootEngine::gameover(Gamepad &pad, N5110 &lcd)
{   int sight_score = _sight.get_score();
    char buffer[5]; //print to LCD
    lcd.clear();    //clean the screen
    lcd.refresh();    // display on the screen
    pad.tone(300.0,0.5); 
    wait(0.1); 
    pad.tone(440.0,0.5); 
    wait(0.1); 
    pad.tone(1200.0,0.5);  
    sprintf(buffer,"SCORE:%2d",sight_score); // display the buffer on the screen
    while(1)
    {
    lcd.printString(buffer,20,1); 
    Bitmap sprite(sprite_gameover, 21, 35); // Specify rows and columns in sprite
    sprite.render(lcd, 25, 25); // x and y locations for rendering
    //lcd.drawSprite(25,25,21,35,(int *)sprite_gameover); 
    lcd.refresh();
    }}

