#ifndef SHOOTENGINE_H
#define SHOOTENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Target.h"
#include "Sight.h"
#include "Bitmap.h"

class ShootEngine
{

public:
    ShootEngine();
    ~ShootEngine();
    
    
    
    void init(Gamepad &pad); 
    void read_input(Gamepad &pad);
    void draw(N5110 &lcd);
    void update(Gamepad &pad, N5110 &lcd);
    void gameover (Gamepad &pad, N5110 &lcd);


private:
    void check_hit_wall(Gamepad &pad, N5110 &lcd);
    void check_hit_target(Gamepad &pad);
    void set_speed(Gamepad &pad);
    void print_scores(N5110 &lcd);

    
    Sight _sight;//definition
    
    Target _target;
    Direction _d;
    float _mag;
    int speed;


};
#endif