///////// pre-processor directives ////////
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "ShootEngine.h"


/////////////// structs /////////////////
struct UserInput {
    Direction d;
    float mag;
};


/////////////// objects ///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
ShootEngine shoot;

///////////// prototypes ///////////////
void init();
void update_game(UserInput input);
void render();
void welcome();
void count();
///////////// functions ////////////////
int main()
{
    int fps = 8;  // frames per second

    init();
    welcome();
    lcd.clear();
    count();
    
    render();  // draw initial frame 
    wait(1.0f/fps);  

//gameloop: receive, update and display
    while (1) {
        shoot.read_input(pad);
        shoot.update(pad,lcd);
        render();
        wait(1.0f/fps);
        
    }
}

void init()
{
    //initialise LCD and Gamepad 
    lcd.init();
    pad.init();
     
    // initialise the game
    shoot.init(pad);

}

void render()
{
    lcd.clear();  //clear the screen
    shoot.draw(lcd); // draw the component of the game
    lcd.refresh(); // display on the screen
}

void welcome() {
    
    lcd.printString(" The snipper! ",0,1);  
    lcd.printString("  Press Start ",0,4);
    lcd.refresh();
     
    // wait flashing LEDs until start button is pressed 
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
 
}
// 3 seconds counting down will display on the screen when 'start' is pressed
void count()
{
    lcd.printString("    &&&&&     ",0,0);
    lcd.refresh();
    lcd.printString("        &     ",0,1);
    lcd.refresh();
    lcd.printString("    &&&&&     ",0,2);
    lcd.refresh();
    lcd.printString("        &     ",0,3);
    lcd.refresh();
    lcd.printString("    &&&&&     ",0,4);
    lcd.refresh();
    pad.tone(300.0,0.1);
    pad.leds_on();
    wait (1.0);
    lcd.clear();
    
    lcd.printString("   &&&&&&     ",0,0);
    lcd.refresh();
    lcd.printString("       &&     ",0,1);
    lcd.refresh();
    lcd.printString("   &&&&&&     ",0,2);
    lcd.refresh();
    lcd.printString("   &&     ",0,3);
    lcd.refresh();
    lcd.printString("   &&&&&&     ",0,4);
    lcd.refresh();
    pad.tone(300.0,0.1);
    pad.leds_on();
    wait (1.0);
    lcd.clear();
    
    lcd.printString("     &&&     ",0,0);
    lcd.refresh();
    lcd.printString("     &&&     ",0,1);
    lcd.refresh();
    lcd.printString("     &&&    ",0,2);
    lcd.refresh();
    lcd.printString("     &&&     ",0,3);
    lcd.refresh();
    lcd.printString("     &&&     ",0,4);
    lcd.refresh(); 
    pad.tone(300.0,0.1);
    pad.leds_on();
    wait (1.0);
    lcd.clear();
    }