#ifndef TARGET_H
#define TARGET_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Sight.h"

/**
@brief Target class for snipper. Implements balloons rise from the bottom of the screen.
@ xiandi Bao
@ 4 May 2017
*/
class Target
{

public:
    Target();
    ~Target();
    
    void init(int speed,Gamepad &pad);
    void draw(N5110 &lcd);
    void update();
    Vector2D get_pos();
    void set_pos(Vector2D p);
    void set_speed(Gamepad &pad);
    /// accessors and mutators
    
    
private:
    Vector2D _velocity;
    int _size;
    int _x;
    int _y;
    int _speed;
    int z;
    
    };




#endif