#include "Sight.h"

Sight::Sight()
{

}

Sight::~Sight()
{

}

void Sight::init()
{
    _x = 42;   // x value is at the centre of the screen
    _y = 24; // y is at the centre of the screen
    _speed = 5;  // default speed
    _score = 0;  // the initial score is 0

}

void Sight::draw(N5110 &lcd)
{
    // draw sight in screen buffer.
    lcd.drawCircle(_x,_y,8,FILL_TRANSPARENT);
    lcd.drawLine(_x-8,_y,_x+8,_y,2);
    lcd.drawLine(_x,_y-8,_x,_y+8,2);
}

void Sight::update(Direction d,float mag)
{
    _speed = int(mag*10.0f);
    //printf("_speed: %i/n",_speed);  

    if (d == N) {                    //N is the direction of TOP
        _y-=_speed;
        //printf("_y: %i\n", _y);                      
    } if (d == S) {                  //S is the direction of BOTTOM
        _y+=_speed;
        //printf("_y: %i\n", _y);
    } if (d == W) {                  //W is the direction of LEFT
        _x-=_speed;
        //printf("_x: %i\n", _x);
    } if (d == E) {                  //E is the direction of RIGHT
        _x+=_speed;
        //printf("_x: %i\n", _x); 
    } if (d == NE) {                 //NE is the direction of TOP-RIGHT
        _x+=_speed;
        //printf("_x: %i\n", _x);
        _y-=_speed;
        //printf("_y: %i\n", _y);
    } if (d == NW) {                 //NW is the direction of TOP-LEFT
        _x-=_speed;
        //printf("_x: %i\n", _x);
        _y-=_speed;
        //printf("_y: %i\n", _y);
    } if (d == SE) {                 //SE is the direction of BOTTOM-RIGHT
        _x+=_speed;
        //printf("_x: %i\n", _x);
        _y+=_speed;
        //printf("_y: %i\n", _y);
    } else if (d == SW) {            //SW is the direction of BOTTOM-RIGHT
        _x-=_speed;
        //printf("_x: %i\n", _x);
        _y+=_speed;
        //printf("_y: %i\n", _y);
    }

    // make sure the sight stay in the screen
    if (_y < 9) {
        _y = 9;
    }
    if (_y > 39) {
        _y = 39;
    }
    if (_x < 9)  {
        _x = 9;
    }
    if (_x > 75) {
        _x = 75;
    }
}
void Sight::add_score()
{
    _score++;
}

int Sight::get_score()
{
    return _score;
}

Vector2D Sight::get_pos() {
    Vector2D p = {_x,_y};
    return p;    
}
