#include "RA8875.h"

#define MOSI    PTD2
#define MISO    PTD3
#define SCLK    PTD1
#define CS      PTD0
#define RST     PTC4
DigitalIn   INT(PTC12);

Adafruit_RA8875 lcd = Adafruit_RA8875(MOSI, MISO, SCLK, CS, RST);
uint16_t tx, ty;

Serial pc(USBTX, USBRX); // tx, rxSerial pc(USBTX, USBRX); // tx, rx

void setup()
{
    pc.baud(9600);
    pc.printf("RA8875 start\n");
}

int main()
{
    lcd.begin(RA8875_800x480);
    lcd.displayOn(true);
    lcd.GPIOX(true);      // Enable lcd - display enable tied to GPIOX
    lcd.PWM1config(true, RA8875_PWM_CLK_DIV1024); // PWM output for backlight
    lcd.PWM1out(255);
    lcd.fillScreen(BLACK);
    lcd.touchEnable(true);

    /* Render some text! */
    lcd.textEnlarge(3);
    lcd.textWritePro(10,30,WHITE,0,"Hello, Jacob! ");
    lcd.textEnlarge(1.2);
    lcd.textWritePro(10,150,WHITE,0, "I am finally working!");
    lcd.textWritePro(10, 450, GREEN, 0, "Testing 1.. 2");
    wait(2);
    lcd.fillScreen(BLACK);
    
    lcd.graphicsMode();
    lcd.rectHelper(0,0,800,480,WHITE,1);
    lcd.rectHelper(5,5,794,474,BLACK,1);
    
    //lcd.boxDraw(0,0,400,400,10,GREEN,YELLOW);
    lcd.boxDraw(10,10,459,459,10,GREY,ORANGE);
    
    
//////// Drawing a line for a graph


    lcd.drawPixel(50,200,WHITE);
    
    

    
    
    

    /*
    lcd.textColor(RA8875_WHITE, RA8875_RED);
    lcd.textWrite(string);
    lcd.textTransparent(RA8875_CYAN);
    lcd.textWrite(string);
    lcd.textTransparent(RA8875_GREEN);
    lcd.textWrite(string);
    lcd.textColor(RA8875_YELLOW, RA8875_CYAN);
    lcd.textWrite(string);
    //lcd.textColor(RA8875_BLACK, RA8875_MAGENTA);
    lcd.textWrite(string);
    */


    //lcd.drawCircle(100, 100, 50, RA8875_RED);
    //lcd.fillCircle(100, 100, 50, RA8875_RED);

    //lcd.fillCircle(200, 200, 50, RA8875_RED);


    float xScale = 1024.0F/lcd.width();
    float yScale = 1024.0F/lcd.height();
    bool INT = 1;

    /* Wait around for touch events */
    while(1) {
        if (INT == !1);
        {
            if (lcd.touched()) {
                //Serial.print("Touch: ");
                lcd.touchRead(&tx, &ty);
                //Serial.print(tx); Serial.print(", "); Serial.println(ty);
                /* Draw a circle */
                lcd.fillCircle((uint16_t)(tx/xScale), (uint16_t)(ty/yScale), 1, WHITE);
            }
        }
    }
}