
#include "mbed.h"
#include <string>
#include <stdio.h>      
#include <stdlib.h>

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalOut do21(p21);
InterruptIn di22(p22,PullDown);


Serial pc(USBTX, USBRX);  // for PC debug
LocalFileSystem fs("local");

bool flg_start = 0;
long double configData[3];
string strData[3];

//returns if the given character is a number or decimal point character
bool Is_Num_Char(char c)
{
    bool isChar = false;
    if((c >= '0' and c <= '9') or c == '.') {
        isChar = true;
    }
    return isChar;
}

//From: https://os.mbed.com/questions/83075/Is-it-possible-to-read-a-small-text-file/
//Reads config.txt from local drive
bool Print_Config()
{
    bool flg_error;
    printf("Opening file 'config.txt'... ");
    FILE*   fp = fopen("/local/config.txt", "r");
    printf("%s\n\r", (!fp ? "Fail :(" : "OK"));
    if (!fp) {
        error("error: %s (%d)\n", strerror(errno), -errno);
        flg_error = 1;
    }
    while (!feof(fp)) {
        int c = fgetc(fp);
        printf("%c", c);
    }

    fclose(fp);
    printf("\r\n===========\r\n");
    return flg_error;
}

//Reads reads and converts data from config file
void Get_Config_data()
{
    printf("Get Config data\r\n");
    FILE*   fp = fopen("/local/config.txt", "r");
    int c;
    char stateData = 0; //which data it is reading on duration, off duration e.t.c.
    char stateRead = 0; //0 = parsing, 1 = reading data
    char* pEnd;
    string data;

    while (!feof(fp)) {
        c = fgetc(fp);
        if (Is_Num_Char(c)) {
            data.push_back(c);
            stateRead = 1;
            c = NULL;
        } else if (stateRead == 1) {
            //convert to double and add to Data
            strData[stateData] = data;
            configData[stateData] = strtod(data.c_str(), &pEnd);
            data.clear();
            stateData++;
            stateRead = 0;
        }
    }

    fclose(fp);
    
    configData[0] = configData[0] /10; //wait functions 
    configData[2] = configData[2] /10;
    
}

// Runs wait functions and divides by 10 to account for error in function
// unused as calling function causes too much of a delay when below miliseconds
void wait_fixed(float t){
    wait(t / 10);
}


//Flips output
void run_Cycle()
{
    //printf("On \r\n");
    do21 = 1;
    led1 = 1;
    wait(configData[0]);
    
    //printf("Off \r\n");
    do21 = 0;
    led1 = 0;
}

//interrupt function to start cycling
void start()
{
    flg_start = 1;
}

//init function
void init()
{
    do21 = 0;
    di22.rise(&start);
    Print_Config();
    Get_Config_data();
}

int main()
{
    printf("STARTING\r\n");
    init();
    printf("Strings: On: %s, repeat: %s, Off: %s \r\n", strData[0].c_str(),strData[1].c_str(), strData[2].c_str() );
    printf("Data: %Lf, %Lf, %Lf\r\n",configData[0]*10,configData[1],configData[2]*10); //multiplying back to real values


    while((int)configData[1] != 0) {
        run_Cycle();
        wait(configData[2]);
    }
    run_Cycle();
    
    printf("END \r\n");
    return 0;
}