#include "Engine.h"



void Engine::init()
{
    level_index = 0;//initalises level_index to 0
};


current_coordinate_struct Engine::handle_input(int new_x, int new_y, Gamepad &pad, N5110 &lcd,Character &character, Levels &levels, Science &science)
{

    current_coordinate_struct returned_current_coordinates;//creates an instance of the current coordinate struct

    returned_current_coordinates.current_x = new_x;//sets the current_x equal to new_x so when new_x is recalculated a comparison can be done between the currently displayed coordinate aswell.

    returned_current_coordinates.current_y = new_y;//sets the current_y equal to new_y so when new_y is recalculated a comparison can be done between the currently displayed coordinate aswell.


    //printf("Engine Handle Inputs complete");

    return returned_current_coordinates;//returns the struct
};



new_coordinate_struct Engine::update(int radius, int current_x, int current_y, Science &science, FXOS8700CQ &device, N5110 &lcd, Levels &levels, Gamepad &pad)
{
    Data values = device.get_values();//gets the values from the device

    new_coordinate_struct returned_new_coordinates; // creates an instance of the new_coordinate_struct

    int x_velocity = science.calculate_x_velocity( device); //calculates the velocity in x

    int y_velocity = science.calculate_y_velocity( device); // calculates the velocity in y
    //printf("\n update function %i = x vel, %i = y vel \n", x_velocity, y_velocity);

    int new_x = science.x_boundary_limiter( science.calculate_next_x(current_x, x_velocity) , radius); // calculates the new position in x then is limited if exceeding the screen boundaries

    int new_y = science.y_boundary_limiter( science.calculate_next_y(current_y, y_velocity) , radius); // calculates the new position in y then is limited if exceeding the screen boundaries
    //printf("\n update function %i = new_x, %i = new_y after boundary correction \n", new_x, new_y);

    int next_y = science.y_collisions_correction (new_x, new_y, current_x, current_y, y_velocity, radius, levels);//next_x is created to prevent the collision corrections from being calculated from the wrong position

    int next_x = science.x_collisions_correction (new_x, new_y, current_x, current_y, x_velocity, radius, levels);//next_y is created to prevent the collision corrections from being calculated from the wrong position
    //printf("\n update function %i = next x, %i = next y \n", next_x, next_y);

    science.check_leds_flag_set_tone(pad, lcd);//checks if the LED flag is set

    science.check_leds_off(pad);//checks if the flag for the leds_off is set

    returned_new_coordinates.new_x = next_x; // sets the new_x object in the struct to equal next_x

    returned_new_coordinates.new_y = next_y; // sets the new_y object in the struct to equal next_y
    //printf("\n update function %i = returned x, %i = returned y \n", returned_new_coordinates.new_x, returned_new_coordinates.new_y);

    check_for_level_update( returned_new_coordinates.new_x, returned_new_coordinates.new_y, levels);

    //printf("Engine Update complete");
    return returned_new_coordinates;   // returns the struct instance containing the new coordinates

};



void Engine::draw(int new_x, int new_y, int radius, Character &character, Levels &levels,  N5110 &lcd)
{
    levels.draw_maze(lcd);//draws the maze

    levels.draw_exit(lcd);//draws the exit

    character.draw_ball_2D(new_x, new_y, radius, lcd);//draws the character last
    //printf("Engine Draw complete");
};



void Engine::check_for_level_update( int new_x, int new_y, Levels &levels)
{
    if(levels.check_exit_coordinates(new_x, new_y) ==1) {
        //printf("\n detected at exit\n");
        
        this->level_index ++; //intended for use with a fsm of levels containing the array of the maze, which would be printed to the lcd.
        
        //printf("\n level index = %i\n", level_index);
    };

};

