#include "mbed.h"

SPI lights(p5,p6,p7);
DigitalOut cs_lights(p8);

BusOut myleds(LED4, LED3, LED2, LED1);
DigitalOut led1(LED1);
DigitalOut led2(LED2);

int i;
int j;

char v;
char redArray[8][8];

int main()
{

    myleds = 0;

    for (i = 0; i < 8; i++) {
        for (j = 0; j < 8; j++) {
            redArray[i][j] = 0x30;
        }
    }
    //Array values defined

    cs_lights = 1; //data commences when cs = 0

    lights.format(8,3); //8 bit data (or 16 bit),  mode 3
    lights.frequency(1000000); //1MHz clock rate
    wait(0.5);

    while(1) {
        led1 = !led1;
        cs_lights = 0; //selects the slave connected to cs_lights to receive data
        v = lights.write(0x01); //start bit
        for (i = 0; i < 8; i++) {
            for (j = 0; j < 8; j++) {
                lights.write(redArray[i][j]);
            }
        }
        cs_lights = 1; //stops transmission of data to selected slave
        wait(0.1);
    }
}



