#include "mbed.h"

BusOut myleds(LED4, LED3, LED2, LED1);

int algorithm_update;

int shape; //a value between 0 for off, and 5 for a square (with 6 for error)
char tile1;
char tile2;
char tile3;
char tile4;
char tiles_combo;

int main()
{   
    
    algorithm_update = 1;

    while(algorithm_update == 1) { //set algorithm to 0 to end the algorithm
        
        check_tiles();
        tiles_combo = tile1 + tile2 + tile3 + tile4;
        
        //check if all tiles are off
        if ((tile1 == 0x00) && (tile2 == 0x00) && (tile3 == 0x00) && (tile4 == 0x00)) {
            shape = 0;
        } else if ((tile1 == 0x07) && (tile2 == 0x07) && (tile3 == 0x07) && (tile4 == 0x07)) { //0x07 is 111 (on and sensor values)
            shape = 5;
        } else if (tiles_combo == 0x04) { //0x04 is 100 (on and no sensor values)
            shape = 1;
        } else if (tiles_combo == 0x0A) { //0x0A is 101 + 101 (on and 1 sensor active on each of two tiles)
            shape = 2;
        } else if (tiles_combo == 0x11) { //0x11 is 101 + 111 + 111
            shape = 3;
        } else if (tiles_combo == 0x18) { //0x18 is 101 + 111 + 111 + 101
            shape = 4;
        } else {
            shape = 6;
        }
        
        if (shape != 6) {
            algorithm_update = 0;
        }
        
    }
    //output shape value in desired format
    //ie return shape;
}

void check_tiles {
    //obtains the codeword for each tile
    //dependent upon the sensor code, but will update tiles 1 through 4 values
}
