#include "mbed.h"

BusOut myleds(LED4, LED3, LED2, LED1);
DigitalOut NorthLED(LED1); //update pin when known
DigitalOut EastLED(LED2); //update pin when known
DigitalOut SouthLED(LED3); //update pin when known
DigitalOut WestLED(LED4); //update pin when known

DigitalIn NorthDetect(p5);
DigitalIn EastDetect(p6);
DigitalIn SouthDetect(p7);
DigitalIn WestDetect(p8);

int NorthPattern[8];
int EastPattern[8];
int SouthPattern[8];
int WestPattern[8];

int NorthPattern2[8];
int EastPattern2[8];
int SouthPattern2[8];
int WestPattern2[8];

int NorthPattern3[8];
int EastPattern3[8];
int SouthPattern3[8];
int WestPattern3[8];

int NorthPattern4[8];
int EastPattern4[8];
int SouthPattern4[8];
int WestPattern4[8];

int NorthDetected[5];
int EastDetected[5];
int SouthDetected[5];
int WestDetected[5];

//counters
int N1N2;
int N1N3;
int N1N4;
int N1E2;
int N1E3;
int N1E4;
int N1S2;
int N1S3;
int N1S4;
int N1W2;
int N1W3;
int N1W4;

int E1N2;
int E1N3;
int E1N4;
int E1E2;
int E1E3;
int E1E4;
int E1S2;
int E1S3;
int E1S4;
int E1W2;
int E1W3;
int E1W4;

int S1N2;
int S1N3;
int S1N4;
int S1E2;
int S1E3;
int S1E4;
int S1S2;
int S1S3;
int S1S4;
int S1W2;
int S1W3;
int S1W4;

int W1N2;
int W1N3;
int W1N4;
int W1E2;
int W1E3;
int W1E4;
int W1S2;
int W1S3;
int W1S4;
int W1W2;
int W1W3;
int W1W4;

int algorithm_update;
int number_of_tiles; //value used to represent number of tiles

//orientations : N=1, E=2, S=3, W=4 and Unknown = 0
int tile1_orientation;
int tile2_orientation;
int tile3_orientation;
int tile4_orientation;

int i;
int c; //detectors function counter
int o; //detectors function variable
int d; //detectors function variable

void patterns(int m);
void patternsReset();
int detectors(int n);

int main()
{
    //please note, some values would have to be adjusted to account for the extra 0 preceding the start bits
    /*
        initialise light patterns:
        start bit || data of defined length (which is 5 bits for 16 sensors)
        N1 = 111 00001
        E1 = 111 00010
        S1 = 111 00011
        W1 = 111 00100
        N2 = 111 00101
        E2 = 111 00110
        S2 = 111 01000
        W2 = 111 01001
        N3 = 111 01010
        E3 = 111 01011
        S3 = 111 01100
        W3 = 111 01101
        N4 = 111 10000
        E4 = 111 10001
        S4 = 111 10010
        W4 = 111 10011

        111 00111
        111 01110 These combinations skipped due to having 3 1's that are not the start bits
        111 01111

        example of init below, different patterns for different tiles
    */
    
    //tile 1 patterns (does not currently include the 0 preceding the start bits, as have had no sensors to test it further)
    NorthPattern[0] = 1; NorthPattern[1] = 1; NorthPattern[2] = 1; NorthPattern[3] = 0; NorthPattern[4] = 0; NorthPattern[5] = 0; NorthPattern[6] = 0; NorthPattern[7] = 1;
    EastPattern[0] = 1; EastPattern[1] = 1; EastPattern[2] = 1; EastPattern[3] = 0; EastPattern[4] = 0; EastPattern[5] = 0; EastPattern[6] = 1; EastPattern[7] = 0;
    SouthPattern[0] = 1; SouthPattern[1] = 1; SouthPattern[2] = 1; SouthPattern[3] = 0; SouthPattern[4] = 0; SouthPattern[5] = 0; SouthPattern[6] = 1; SouthPattern[7] = 1;
    WestPattern[0] = 1; WestPattern[1] = 1; WestPattern[2] = 1; WestPattern[3] = 0; WestPattern[4] = 0; WestPattern[5] = 1; WestPattern[6] = 0; WestPattern[7] = 0;
    
    //tile 2 patterns
    
    //tile 3 patterns
    
    //tile 4 patterns
    
    algorithm_update = 1;

    while(algorithm_update == 1) { //set algorithm to 0 to end the algorithm

        for (i = 0; i <= 11; i++) { //11 because start bit not guaranteed to be at 0;
            patterns(i); //turn on pattern(i)
            int r = detectors(i); //update detectors(i)
            if (r == 1) {
                i = 6;
                r = 0;
            }
        }
        patternsReset();
        results();
        //output orientation values in desired format
        
    }
}

void patterns(int m) {
    
    NorthLED = NorthPattern[m];
    EastLED = EastPattern[m];
    SouthLED = SouthPattern[m];
    WestLED = WestPattern[m];
    
}

void patternsReset() {
    
    NorthLED = 0;
    EastLED = 0;
    SouthLED = 0;
    WestLED = 0;
    
}

int detectors(int n) {
    
    d = 0;
    o = n - 6; //
    
    NorthDetected[o] = NorthDetect;
    EastDetected[o] = EastDetect;
    SouthDetected[o] = SouthDetect;
    WestDetected[o] = WestDetect;
    
    if ((NorthDetected[o] == 1) && (EastDetected[o] == 1) && (SouthDetected[o] == 1) && (WestDetected[o] == 1)) {
        c++;
    } else {
        c = 0;
    }
    
    if (c == 3) {
        d = 1;
    }
    
    return d;
    
}

void results() {
    
    //compare arrays to the predetermined patterns
    //cycles through all comparisons of data, comparing the detected values to the known patterns of other tiles
    //adds a value to the specific counter if it is a match
    //example
    for (i = 3; i < 8; i++) {//ignore the start bits when comparing
        if (NorthDetected[i] == NorthPattern2[i]) {
            N1N2++;
        }
        if (NorthDetected[i] == NorthPattern3[i]) {
            N1N3++;
        }
        if (NorthDetected[i] == NorthPattern4[i]) {
            N1N4++;
        }
            
        
    }
    
    //if any of the variables is 5, you can tell that is the current connection
    //example
    if (N1N2 == 5) {
        tile1_orientation = 1; //always with respect to tile 1
        tile2_orientation = 3;
    } else if (N1N3 == 5) {
        tile1_orientation = 1;
        tile3_orientation = 3;
    } else if (N1N4 == 5) {
        tile1_orientation = 1;
        tile4_orientation = 3;
    }
    
    if (N1E2 == 5) {
        tile1_orientation = 1; //always with respect to tile 1
        tile2_orientation = 2;
    } else if (N1E3 == 5) {
        tile1_orientation = 1;
        tile3_orientation = 2;
    } else if (N1E4 == 5) {
        tile1_orientation = 1;
        tile4_orientation = 2;
    }
}
