/*****************************************************
        Libraries and modules used                   *
******************************************************/
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Character.h"
#include "Obstacles.h"
#include "Gems.h"
#include "SDFileSystem.h"
#include "FXOS8700CQ.h"


#define No_OBS 8
#define No_GEMS 4

//Variables
// i - to loop through the obstacles
// j - to loop through the gems
// counter - to keep track of score
// highScore - to store high score
int i,j,counter,highScore;

//To help convert counter(int) to string to display on the screen
 char score[50];

//Structs
struct UserInput 
{
    Direction d;
    float mag;
};
/*            Class Objects                         */
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
Character c;
Obstacles obstacle[No_OBS];
Gems gems[No_GEMS];

SDFileSystem sd(PTE3,PTE1,PTE2,PTE4,"sd");
FILE *file;
FXOS8700CQ device(I2C_SDA,I2C_SCL);
Data values;


/*            Function Prototypes                    */
void init();
void update_game(UserInput input);
void render();
void welcome();
void menu();
void over();
void Instructions();
void stickRunner();
void displayHighScore();
/*            Functions                              */

int main()
{
 
 
/*            Intialization                           */
    //fprintf("Entering init() from main");
    init();
    
/*      Drawing the initial frame                      */ 
    //fprintf("Entering the Welcome() function from main");   
    welcome();
    
}


void init()
{
  
//fprintf("in init()");    
//Need to initialize the lcd and gamepad
    lcd.init();
    pad.init();
    
//Intialzing the charachter
    c.init();
    
//Intialzing the obstacles
    for(i=0;i<No_OBS;i++)
    {
       //fprintf("Obstacle intialised");
       obstacle[i].init();
    }

//Intialzing the gems
    for(j=0;j<No_GEMS;j++)
    {
       //fprintf("Gems initalised");
       gems[j].init();
    }
     
   

}



//Funstion to display the Welcome page
void welcome() 
{
    
   
    //fprintf("In welcome()");
    lcd.printString("Stick Runner!    ",0,1);  
    lcd.printString(" Press Start ",0,4);
    lcd.refresh();
    pad.tone(1500.0,0.5);
    pad.tone(1500.0,0.5);
      
     
   //Flashes LEDS aslong as START is not pressed
    while ( pad.check_event(Gamepad::START_PRESSED) == false) 
    {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
       
    }
    //fprintf("Entering menu() from wlelcome"); 
    menu();
}



//Function to display the Menu page
void menu() 
{
   
    
    //fprintf("In menu");
    lcd.clear();
    lcd.printString("     Menu       ",0,0);  
    lcd.printString("A)New Game     ",0,2);
    lcd.printString("B)Continue     ",0,3);
    lcd.printString("X)Instructions ",0,4);
    lcd.printString("Y)High Score   ",0,5);
    
    lcd.refresh();
    
    
    while(1) 
    {
        // wait flashing LEDs until start button is pressed 
        //Condition to start a new game
        if( pad.check_event(Gamepad::A_PRESSED) )
        {
            pad.tone(1000.0,0.5);
            
       
            //Clear, refresh and intialize the game again so we can start a new game
            lcd.clear();
            //fprintf("Entering init from menu()");
            lcd.refresh();
            init();
            //fprintf("Entering the game when A is pressed");
            stickRunner();
       
             
        }
    
        //To continue the same game 
        else if( pad.check_event(Gamepad::B_PRESSED) )
        {
            
             pad.tone(1000.0,0.5);
            
       
            //Simply refreshes the page and continues from where the user left the game
            // as the intialize function init() is not called again 
            lcd.refresh();
            
            pad.led(2,0);
            pad.led(5,0);
           
            
            //fprintf("Entering the game when B is pressed from menu");
            stickRunner();
       
       
        }
    
        //To read the game instructions
        else if( pad.check_event(Gamepad::X_PRESSED) ) 
        {
             pad.tone(1000.0,0.5);
            //fprintf("entering instructions when X is pressed from menu");
            Instructions();
         
            
         }
    
    
        //To see the game high score
        else if( pad.check_event(Gamepad::Y_PRESSED) ) 
        {
            pad.tone(1000.0,0.5);
            //fprintf("Displayibng highscore when Y is pressed from menu");
            displayHighScore();
        
            
            
        }
        
        
            
            
        
        sleep();
    
    
     }
}




//This function is responsible for running the game 
void stickRunner()
{
    //fprintf("IN the game(stickrunner())");
     int fps = 10;  
   
     render();  
     wait(1.0f/fps);  

/*   Main game loop to read input, render the display and update the game state            */
   
     while (1) 
     {
         lcd.setBrightness(pad.read_pot());
         
         //fprintf("printing out the value of counter before updating in each iteration %d",counter);
         //As long as the character survives  update the score 
        counter++;
        //fprintf("printing out the value of counter after updating in each iteration %d",counter);
        
        //Using the gamepad library to move the character using the joystick
        //fprintf("Calling UpdateCharacter from the game func to make it move"); 
        c.updateCharacter(pad.get_direction(),pad.get_mag());
        
        
        
        //Condition to ckeck if the user wants to pause the game
        if(pad.check_event(Gamepad::BACK_PRESSED))
        {
            lcd.clear(); 
            lcd.refresh();
            
           
            pad.led(2,1);
            pad.led(5,1);
           
            
            
            //fprintf("Game paused and sent to menu from the game when BACK is pressed"); 
            menu();
        }
        
        //Loop to make the generation of obstacles a continious loop by checking the status and also to check if the user has been killed
        for(i=0;i<No_OBS;i++)
        {   //fprintf("in to loop to check when to initialise the obstacles and "); 
        
            //To retrieve the status of the obstacle on the screen
            //fprintf("Obstacle Status called from stickrunner()"); 
            obstacle[i].obstacleStatus(obstacle[i].getObstaclePos());
            //fprintf("Value returned from obstacle status %d", obstacle[i].obstacleStatus(obstacle[i].getObstaclePos());
            
            if(obstacle[i].getObstacleStatus() == false)
            {
                //fprintf("Init clalled from stickrunner() in obstaccle");
                obstacle[i].init();
            }
            
            //To check whether the character has been hit by an obstacle by comparing the position of each obstacle
            // relative to the character 
            //fprintf("Character status called from stickrunner() in obstacle loop");
            c.characterStatus(obstacle[i].getObstaclePos());
            //fprintf("the value returned by character status %d", c.characterStatus(obstacle[i].getObstaclePos()));
              
                
        }
        
         //Loop to make the generation of gems a continious loop and also to check if the user has collected them
        for(j=0;j<No_GEMS;j++)
        {
             //fprintf("in to loop to check when to initialise the gems and "); 
             
             //To check whether the character has collected a gem by comparing the position of each gem
            // relative to the character 
            //fprintf("Gems Status called from stickrunner()"); 
            gems[j].gemStatus(c.getCharacterPos());
            //fprintf("Value returned from gem status %d", gem[i].gemStatus(obstacle[i].getGemPos());     
            
            if(gems[j].getGemStatus() == false)
            {
                
                //fprintf("Init clalled from stickrunner() in gem");
                gems[j].init();
                
                
            }
            
          
        }
        
        //To make the obstacles and gems move along the screen 
        
        
        i =0;
        
        for(i=0;i<No_OBS;i++)
        {
              
              //fprintf("update obstacle clalled from stickrunner()");
              obstacle[i].updateObstacle();
        }
         
        
        j =0;
        
        for(j=0;j<No_GEMS;j++)
        {
               //fprintf("update gem clalled from stickrunner()");
               gems[j].updateGems();
              
        }
        
        //fprintf("render called from stickrunner()");    
        render();
       
        wait(1.0f/fps);
    }
    
}


//Function to draw out the pixels on the screen
void render()
{
    //fprintf("In render");
    lcd.clear();  
    
    
    //Only draws the character as long as it survives
     if(c.getCharacterStatus())
     {  
        //fprintf("Character drawn");
        c.draw(lcd);
     }
     
     if(c.getCharacterStatus() == false)
     {
         //fprintf("over called from render()");
         over();
     }
   
   
    //Draws the obstacles if the status returned is true
    
    for(i=0;i<No_OBS;i++)
    {
       if(obstacle[i].getObstacleStatus())
       {
          //fprintf("obstacle drawn");
          obstacle[i].draw(lcd);
       }
    }
            
    //Draws the gems if the status returned is true   
    for(j=0;j<No_GEMS;j++)
    {
      if(gems[j].getGemStatus())
      { 
         //fprintf("gem drawn");
         gems[j].draw(lcd);
        
      }
      
     
    }
      
            
    lcd.refresh();

}



//Function to display end of game and also check whether the user got a new highscore and if not write it on the SD card
void over() 
{
    //fprintf("In over()");
    
 
    
    pad.tone(1000.0,0.5);
    pad.init();
    
   
    
    //Converting the counter into a string 'score' to display on the lcd
    sprintf (score, " Score : %d",counter);
    //fprintf("Counter converted to string %s",score);

    lcd.printString(score,0,2);
    lcd.printString(" GAME  OVER!!  ",0,0);  
    
    
    lcd.printString(" PRESS START  ",0,5);  
    
    lcd.refresh();
   
     
    //Takes the user back to the main for a new game
    while ( pad.check_event(Gamepad::START_PRESSED) == false) 
    {
        pad.leds_on();
        //pad.tone(1000.0,0.5);
        wait(0.1);
        pad.leds_off();
        // pad.tone(1000.0,0.5);
        wait(0.1);
        if( pad.check_event(Gamepad::START_PRESSED)) 
        {
            //fprintf("main called from over() to start a new game");
            main();
            wait(1);
        }
    }
 
}


//Function to display the current High score fo the game and also reset it to 0
void displayHighScore()
{
    //fprintf("In highscore()");
    
   
    lcd.clear();
      
  
    
        if(highScore <= counter)
        {
            highScore = counter;
            //fprintf("value of highscore from if  %d", highScore);
            lcd.printString(" BACK - menu   ",0,5);  
        }
        
        else 
        {
            highScore = highScore;
   
        }  
     //Convert highscore(int) to score(String) to print on the lcd   
    sprintf (score, "    %d",highScore);
    //fprintf("value of score when updated with highscore %s", score);
     lcd.printString("High Score :",0,2);
    lcd.printString(score,0,3);
    
    lcd.printString(" BACK - menu   ",0,5);  
    lcd.refresh();
    sd.unmount();
      
    while(1)
    {
            //Back to menu
            if( pad.check_event(Gamepad::BACK_PRESSED)) 
            {
                    //fprintf("menu called from highscore when back is pressed");
                    menu();
            }
            
            sleep();
          
      }
    
       
}



//Function to display the Instructions for the game
void Instructions()
{
       //fprintf("in instructions()");
       bool i = true;
       lcd.clear();
       lcd.printString("INSTURCTIONS:     ",0,0);  
       lcd.printString("Collect the       ",0,2);
       lcd.printString("gems and dodge    ",0,3);
       lcd.printString("the obstacles     ",0,4);
       lcd.printString("to get points     ",0,5);
       lcd.refresh();
       
       while(i == true)
       {
        
         if( pad.check_event(Gamepad::BACK_PRESSED) ) 
         {
             pad.tone(1000.0,0.5);
             i = false;
             
             //fprintf("menu called from instructions when back pressed");
             menu();
         }
      }
    
}