#ifndef Character_H
#define Character_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"


/** Class Character
@brief Class responsible for all the functionality of the charachter including intialization, drawing, moving and updating it
@author Samrudh Sharma
@date
@classes
*/


class Character
{
public:
/** Initialise display
*
*   Powers up the display and turns on backlight (50% brightness default).
*   Intialises the charchter status, x and y co-ordinate of the character.
*/
    void init();
  
/** Function to draw  the character
*
*   Draws the  character to the display using the N5110 library and its object lcd.  
*   
*/
    void draw(N5110 &lcd);
    
/** Updates/Moves Character
*
*   Helps the charater move using the joystick.
*   @param d - the direction from the joystick
*   @param mag - initalses the speed of the character from the magnitude of the force on the joystick
*/
    void updateCharacter(Direction d,float mag);
    
/** Character Status
*
*   This fuction helps to check if there are any obstacles/gems around the character on the screen 
*   . It checks if any pixels near the body dimensions of the character are lit up and sets the status of the character to false 
*   if any.
*   @param p - stores the 2D location i.e. the (x,y) co-ordinate of the cetre point of the character on the screen .
*/   
     void characterStatus(Vector2D p);

/** Character Position
*
*   Returns the  2D location i.e. the (x,y) co-ordinate of the cetre point of the character on the screen .
*/   
    Vector2D getCharacterPos();
    

/** Return Character Status
*
*   Returns the  status of the character which is sent to the main, where it is used to determine whether the character
*   should be drawn. If true, the character is drwan else not.
*/     
    bool getCharacterStatus();



private:

    //Variables
    int charPosX; // X cocordinate of the character
    int charPosY; // Y cocordinate of the character
    int _speed;   //Variable to help determine the speed of the character from the magnitude of the joystick
    
    bool charStatus; //Variable to store the Cgaracters status
   

};
#endif