
#ifndef Gems_H
#define Gems_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"


/** Class Gems
@brief Class responsible for all the functionality of the gem including intialization, drawing, moving, checking whether the character consumes it 
@brief and updating it
@author Samrudh Sharma
@date
@classes
*/
class Gems
{
public:

/** Initialise display
*
*   Powers up the display and turns on backlight (50% brightness default).
*   Intialises the charchter status, x and y co-ordinate of the gem.
*/
    void init();
    
/** Function to draw  the gem
*
*   Draws the  obstacle to the display using the N5110 library and its object lcd.  
*   
*/ 
    void draw(N5110 &lcd);
    
/** Updates/Moves Obstacle
*
*   Helps the Gem move by updating its position on the screen by 2 pixel each time 
*   therefore setting its speed aswell.
*/  
    void updateGems();
    
/** Gem Status
*
*   This fuction helps to check whether the character has touched a gem and updating it status to make diappear from the screen
*   and also to check if it has reached the bottom of the screen and updates the obstacle status
*   to false so that the gems can be generated again this creating a continuous flow of gems
*   
*   @param p - stores the 2D location i.e. the (x,y) co-ordinate of the cetre point of the gem on the screen .
*/ 
    void gemStatus(Vector2D p);
    
/** Gem Position
*
*   Returns the  2D location i.e. the (x,y) co-ordinate of the cetre point of the gem on the screen .
*/ 
    Vector2D getGemPos();
    
/** Return Gem Status
*
*   Returns the  status of the gem which is sent to the main, where it is used to determine whether the gems have to be intialized or
*   or renderd again.
*/
    
    bool getGemStatus();
 

private:

    //Variables
    int gemPosX; // X cocordinate of the gem
    int gemPosY; // Y cocordinate of the gem
    bool gStatus; //Variable to store the Obstacles status

};
#endif
