#include "Character.h"



void Character::init()
{
     //fprintf("in character init");
    
    //Initializing the X and Y co ordinates of the character
    
    charPosX = 42;
    charPosY = 75;
    
    //variable to store the status of the character
    charStatus = true;
  
}

void Character::draw(N5110 &lcd)
{
     
   
     //Drawing the character 
     //fprintf("character being drawn");
     lcd.setPixel(charPosX,charPosY);
     lcd.setPixel(charPosX-1,charPosY);
     lcd.setPixel(charPosX+1,charPosY);
     lcd.setPixel(charPosX,charPosY+1);
     lcd.setPixel(charPosX-1,charPosY+1);
     lcd.setPixel(charPosX+1,charPosY+1);
     lcd.setPixel(charPosX,charPosY+2);
     lcd.setPixel(charPosX-1,charPosY+2);
     lcd.setPixel(charPosX+1,charPosY+2);
     lcd.setPixel(charPosX,charPosY+3);
     lcd.setPixel(charPosX,charPosY+4);
     lcd.setPixel(charPosX,charPosY+5);
     lcd.setPixel(charPosX-1,charPosY+4);
     lcd.setPixel(charPosX+1,charPosY+4);
     lcd.setPixel(charPosX-2,charPosY+5);
     lcd.setPixel(charPosX+2,charPosY+5);
     lcd.setPixel(charPosX,charPosY+6);
     lcd.setPixel(charPosX-1,charPosY+7);
     lcd.setPixel(charPosX+1,charPosY+7);
     lcd.setPixel(charPosX-2,charPosY+8);
     lcd.setPixel(charPosX+2,charPosY+8);
   
   
   
}


//Function to move the character using the joystick
void Character::updateCharacter(Direction d,float mag)
{
    //fprintf("updating th character speed to make it move");
    _speed = int(mag*10.0f);  // scale is arbitrary, could be changed in future

    // update y value depending on direction of movement
    // North is decrement as origin is at the top-left so decreasing moves up
    if (d == N) 
    {
        charPosY-=_speed;
    }
     
    else if (d == NW) 
    {
        charPosX-=_speed;
        charPosY-=_speed;
    }
    
    else if (d == NE) 
    {
        charPosX+=_speed;
        charPosY-=_speed;
    }
    
    else if (d == S)
    {
        charPosY+=_speed;
    }
    
    else if (d == SW) 
    {
        charPosX-=_speed;
        charPosY+=_speed;
    }
    
    else if (d == SE) 
    {
        charPosX+=_speed;
        charPosY+=_speed;
    }
    
    else if (d == E) 
    {
        charPosX+=_speed;
    }
    
    else if (d == W) 
    {
        charPosX-=_speed;
    }

    // check the y origin to ensure that the Character doesn't go off screen
    
    if(charPosX-2<0)
    {
        charPosX = 2;
    }
    
    
    if(charPosX+2>WIDTH-1)
    {
        charPosX = WIDTH -5;
    }
   
   
    if (charPosY < 1)
    {
        charPosY = 1;
    }
    
    if (charPosY+8 > HEIGHT - 1) 
    {
        charPosY = HEIGHT-10;
    }
}



//Returns the postion (x,y) of the character on the screen 
Vector2D Character::getCharacterPos() 
{
     //fprintf("in character get pos");
    Vector2D p = {charPosX,charPosY};
    return p;    
}


//Function to check if the character has been hit by a obstacle and update the status if yes
void Character::characterStatus(Vector2D p)
{
    //fprintf("IN character status");
    //Using the dimensions of the character we check if there any pixels near it 
    if(((charPosX-5<p.x)&&(charPosX+5>p.x))&&((charPosY-5<p.y)&&(charPosY+5>p.y)))
    {
        //Updating the status
        charStatus = false;
    }
}

//Function to return the status of the character
bool Character::getCharacterStatus()
{
    
    //fprintf("in get character status");
    
    //fprintf("The value of character status is (in 0/1) %d",charStatus);
    
    //Used to determine whether the character has been and hit and charstatus returns false the game is over
    return charStatus;
    
}
    
    