/**
@file SRF02.cpp

@brief Member functions implementations

*/
#include "mbed.h"
#include "SRF02.h"

SRF02::SRF02(PinName sdaPin, PinName sclPin)
{
    i2c = new I2C(sdaPin,sclPin); // create new I2C instance and initialise
    i2c->frequency(400000);       // I2C Fast Mode - 400kHz
    leds = new BusOut(LED4,LED3,LED2,LED1);

}

int SRF02::getDistannceInch()
{
    char data[2];
    
    // need to send CM command to command register
    data[0] = CMD_REG;
    data[1] = INCH_CMD;
    int ack = i2c->write(SRF02_W_ADD,data,2);  
    if (ack)
        error();  // if we don't receive acknowledgement, flash error message
        
    // this will start the sensor ranging, the datasheet suggests a delay of at least 65 ms before reading the result
    wait_ms(70);
    
    // we can now read the result - tell the sensor we want the high byte
    char reg = RANGE_H_REG;   
    ack = i2c->write(SRF02_W_ADD,&reg,1);  
    if (ack)
        error();  // if we don't receive acknowledgement, flash error message
    
    // if we read two bytes, the register is automatically incremented (H and L)
    ack = i2c->read(SRF02_R_ADD,data,2); 
    if (ack)
        error();  // if we don't receive acknowledgement, flash error message

    // high byte is first, then low byte, so combine into 16-bit value
    return (data[0] << 8) | data[1];
}
int SRF02::getDistanceCm()
{
    char data[2];
    
    // need to send CM command to command register
    data[0] = CMD_REG;
    data[1] = CM_CMD;
    int ack = i2c->write(SRF02_W_ADD,data,2);  
    if (ack)
        error();  // if we don't receive acknowledgement, flash error message
        
    // this will start the sensor ranging, the datasheet suggests a delay of at least 65 ms before reading the result
    wait_ms(70);
    
    // we can now read the result - tell the sensor we want the high byte
    char reg = RANGE_H_REG;   
    ack = i2c->write(SRF02_W_ADD,&reg,1);  
    if (ack)
        error();  // if we don't receive acknowledgement, flash error message
    
    // if we read two bytes, the register is automatically incremented (H and L)
    ack = i2c->read(SRF02_R_ADD,data,2); 
    if (ack)
        error();  // if we don't receive acknowledgement, flash error message

    // high byte is first, then low byte, so combine into 16-bit value
    return (data[0] << 8) | data[1];
}

void SRF02::error()
{
    while(1) {
        leds->write(15);
        wait(0.1);
        leds->write(0);
        wait(0.1);    
    }    
}