#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "FXOS8700CQ.h"
#include "Animations.h"
#include "Menu.h"

// CREATE OBJECTS //
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
FXOS8700CQ device(I2C_SDA,I2C_SCL);
Animations animate;
Gamepad pad;
Menu menu;

// FUNCTION PROTOTYPES //
void init();

int main()
{
    init(); // initialise devices
    // printf("Devices initialised \n");
    
    menu.intro(lcd, pad, animate);
    
    while(1) {
        
        menu.main(lcd, pad, device, animate);

    }
}


void init()
{
    menu.init();
    lcd.init();
    pad.init();
    device.init();
    lcd.setBrightness(pad.read_pot());
}
