#ifndef ANIMATIONS_H
#define ANIMATIONS_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/**
 @brief Animations Class contains all the different animations used throughout the game.
 @author Max Houghton
 @date April 13 2017
 */

class Animations
{
    
public:
    
    /**
     *  @details - constructor
     */
    Animations();
    
    /**
     *  @details - destructor
     */
    ~Animations();
    
    /** Intro
     *
     *  @details - Short animation to be used when running the introduction during the loading of the game.
     *  @param - lcd - N5110 Libarary used to print strings and draw the ball
     *
     */
    void intro(N5110 &lcd, Gamepad &pad);
    
    /** Vertical Joystick
     *
     *  @details - Function to draw vertical joystick image. Used in 'animateJoystick()' function in Menu class.
     *  @param - lcd - N5110 Libarary used to draw joystick bitmap.
     *
     */
    void drawVerticalJoystick(N5110 &lcd);
    
    /** Left Joystick
     *
     *  @details - Function to draw joystick image tilting to the left. Used in 'animateJoystick()' function in Menu class.
     *  @param - lcd - N5110 Libarary used to draw joystick bitmap.
     *
     */
    void drawLeftJoystick(N5110 &lcd);
    
    /** Right Joystick
     *
     *  @details - Function to draw joystick image tilting to the right. Used in 'animateJoystick()' function in Menu class.
     *  @param - lcd - N5110 Libarary used to draw joystick bitmap.
     *
     */
    void drawRightJoystick(N5110 &lcd);
    
    /**  Left Joystick
     *
     *  @details - Function to draw gamepad image tilting to the left. Used in 'animateGamepad()' function in Menu class.
     *  @param - lcd - N5110 Libarary used to draw gamepad bitmap.
     *
     */
    void drawLeftGamepad(N5110 &lcd);
    
    /**  Vertical Gamepad
     *
     *  @details - Function to draw vertical gamepad image. Used in 'animateGamepad()' function in Menu class.
     *  @param - lcd - N5110 Libarary used to draw gamepad bitmap.
     *
     */
    void drawVerticalGamepad(N5110 &lcd);
    
    /** Right Gamepad
     *
     *  @details - Function to draw gamepad image tilting to the right. Used in 'animateGamepad()' function in Menu class.
     *  @param - lcd - N5110 Libarary used to draw gamepad bitmap.
     *
     */
    void drawRightGamepad(N5110 &lcd);
    
    /** Rolling Empty Ball
     *
     *  @details - Function to draw transparent-filled ball rolling across the screen. Used in 'ballColourOptions()' function in Menu class.
     *  @param - lcd - N5110 Libarary used to draw circles representing moving ball.
     *
     */
    void rollingEmptyBall(N5110 &lcd);
    
    /** Rolling Solid Ball
     *
     *  @details - Function to draw solid-filled ball rolling across the screen. Used in 'ballColourOptions()' function in Menu class.
     *  @param - lcd - N5110 Libarary used to draw circles representing moving ball.
     *
     */
    void rollingSolidBall(N5110 &lcd);
    
    /** Maze Completed
     *
     *  @details - Short animation to be used when the maze being used has been completed.
     *  @param - lcd - N5110 Libarary used to print strings and draw bitmaps.
     *
     */
    void mazeCompleted(N5110 &lcd);
    
    /** Stickman One
     *
     *  @details - First animation in a series to create a jumping man. Used inside mazeCompleted() function.
     *  @param - lcd - N5110 Libarary used to print strings and draw bitmap.
     *
     */
    void stickmanOne(N5110 &lcd);
    
    /** Stickman Two
     *
     *  @details - Second animation in a series to create a jumping man. Used inside mazeCompleted() function.
     *  @param - lcd - N5110 Libarary used to print strings and draw bitmap.
     *
     */
    void stickmanTwo(N5110 &lcd);
    
    /** Stickman Three
     *
     *  @details - Third animation in a series to create a jumping man. Used inside mazeCompleted() function.
     *  @param - lcd - N5110 Libarary used to print strings and draw bitmap.
     *
     */
    void stickmanThree(N5110 &lcd);
    
    /** Stickman Four
     *
     *  @details - Fourth animation in a series to create a jumping man. Used inside mazeCompleted() function.
     *  @param - lcd - N5110 Libarary used to print strings and draw bitmap.
     *
     */
    void stickmanFour(N5110 &lcd);
    
    /** Stickman Five
     *
     *  @details - Fifth animation in a series to create a jumping man. Used inside mazeCompleted() function.
     *  @param - lcd - N5110 Libarary used to print strings and draw bitmap.
     *
     */
    void stickmanFive(N5110 &lcd);
    
    /** Stickman Six
     *
     *  @details - Sixth animation in a series to create a jumping man. Used inside mazeCompleted() function.
     *  @param - lcd - N5110 Libarary used to print strings and draw bitmap.
     *
     */
    void stickmanSix(N5110 &lcd);
    
    /** Sound Switch
     *
     *  @details - Function to display a switch a made up of one outer rectangle and two inner ones. At any given instant, only one of the inner rectangles is drawn. This is decided by the boolean value of 'tone'.
     *  @param - lcd - N5110 Libarary used to print rectangles on the screen.
     *  @param - tone - Boolean variable to dictate the appearance of the switch being drawn on the screen.
     *
     */
    void soundSwitch(N5110 &lcd, Gamepad &pad, bool tone);
    
private:
    
};

#endif  /*ANIMATIONS_H*/
