#ifndef MAZE_H
#define MAZE_H

#include "mbed.h"
#include "N5110.h"

/**
 @brief Maze Class contains all the mazes in the form of many series of lines.
 @author Max Houghton
 @date March 19 2017
 */

class Maze
{
    
public:
    
    /**
     *  @details - constructor
     */
    Maze();
    
    /**
     *  @details - constructor
     */
    ~Maze();
    
    /** Initialise the maze
     *
     *  @details - maze object is initialised with specific maze index value
     *  @param mazeIndex - int to select which maze shall be drawn.
     */
    void init(int mazeIndex);
    
    /** Draw
     *
     *  @details - Maze is drawn on LCD screen.
     *  @param lcd - N5110 Library used to draw lines and set pixels which make up maze.
     */
    void draw(N5110 &lcd);
    
private:
    
    /** Maze Zero
     *
     *  @details - Adding lines and pixels to lcd buffer which make up first maze (index 0). This is easy maze 1.
     *  @param lcd - N5110 Library used to draw lines and pixels.
     *
     */
    void mazeIndexZero(N5110 &lcd);
    
    /** Maze One
     *
     *  @details - Adding lines and pixels to lcd buffer which make up first maze (index 1). This is easy maze 2.
     *  @param lcd - N5110 Library used to draw lines and pixels.
     *
     */
    void mazeIndexOne(N5110 &lcd);
    
    
    /** Maze Two
     *
     *  @details - Adding lines and pixels to lcd buffer which make up first maze (index 2). This is easy maze 3.
     *  @param lcd - N5110 Library used to draw lines and pixels.
     *
     */
    void mazeIndexTwo(N5110 &lcd);
    
    /** Maze Three
     *
     *  @details - Adding lines and pixels to lcd buffer which make up first maze (index 3). This is medium maze 1.
     *  @param lcd - N5110 Library used to draw lines and pixels.
     *
     */
    void mazeIndexThree(N5110 &lcd);
    
    /** Maze Four.
     *
     *  @details - Adding lines and pixels to lcd buffer which make up first maze (index 4). This is medium maze 2.
     *  @param lcd - N5110 Library used to draw lines and pixels.
     *
     */
    void mazeIndexFour(N5110 &lcd);
    
    /** Maze Five.
     *
     *  @details - Adding lines and pixels to lcd buffer which make up first maze (index 5). This is medium maze 3.
     *  @param lcd - N5110 Library used to draw lines and pixels.
     *
     */
    void mazeIndexFive(N5110 &lcd);
    
    
    /** Maze Six.
     *
     *  @details - Adding lines and pixels to lcd buffer which make up first maze (index 6). This is hard maze 1.
     *  @param lcd - N5110 Library used to draw lines and pixels.
     *
     */
    void mazeIndexSix(N5110 &lcd);
    
    /** Maze Seven.
     *
     *  @details - Adding lines and pixels to lcd buffer which make up first maze (index 7). This is hard maze 2.
     *  @param lcd - N5110 Library used to draw lines and pixels.
     *
     */
    void mazeIndexSeven(N5110 &lcd);
    
    /** Maze Eight.
     *
     *  @details - Adding lines and pixels to lcd buffer which make up first maze (index 8). This is hard maze 3.
     *  @param lcd - N5110 Library used to draw lines and pixels.
     *
     */
    void mazeIndexEight(N5110 &lcd);
    
    /** Maze Nine.
     *
     *  @details - Adding lines and pixels to lcd buffer which make up first maze (index 9). This is the extreme version maze.
     *  @param lcd - N5110 Library used to draw lines and pixels.
     *
     */
    void mazeIndexNine(N5110 &lcd);
    
    /**
     *  @details - Index value which is used in draw() function to allow the desired maze to be drawn.
     *  @param _mazeIndex - integer to specify desired maze.
     */
    int _mazeIndex;
};

#endif /* MAZE_H */
