#include "Animations.h"

/**
 *  @details - constructor
 */
Animations::Animations()
{
    
}

/**
 *  @details - destructor
 */
Animations::~Animations()
{
    
}

/**
 *  @details - Function to draw transparent-filled ball rolling across the screen.
 */
void Animations::rollingEmptyBall(N5110 &lcd)
{
    // shows ball rolling across the screen
    for (int i = 0; i < 100; i++){
        
        lcd.clear();
        lcd.printString("   OUTLINE    ", 0, 1);
        lcd.drawCircle(i, 32, 8, FILL_TRANSPARENT);
        lcd.refresh();
        wait_ms(40);
        
    }
}

/**
 *  @details - Function to draw solid-filled ball rolling across the screen.
 */
void Animations::rollingSolidBall(N5110 &lcd)
{
    // shows ball rolling across the screen
    for (int i = 0; i < 100; i++){
        
        lcd.clear();
        lcd.printString("    SOLID    ", 0, 1);
        lcd.drawCircle(i, 32, 8, FILL_BLACK);
        lcd.refresh();
        wait_ms(40);
    }
    
}

/**
 *  @details - Short intro animation to be used during the loading of the game.
 */
void Animations::intro(N5110 &lcd, Gamepad &pad)
{
    // animation sequence
    // lcd.drawCircle(x, y, radius, type);
    
    // DRAW FIRST SEQUENCE OF CIRLCES MOVING ACROSS LCD //
    for (int i = 0; i < 61; i++){
        
        lcd.clear();
        lcd.printString("  Welcome to  ", 0, 1);
        lcd.printString("  Roller Maze ", 0, 2);
        // printf("loop \n");
        lcd.drawLine(56, 40, 68, 40, FILL_BLACK);
        lcd.drawLine(56, 41, 68, 41, FILL_BLACK);
        lcd.refresh();
        
        if (i < 57){
            lcd.drawCircle(i, 36, 4, FILL_BLACK);
            lcd.refresh();
            wait_ms(50);
            
        }
        
        else if (i == 57){
            
            lcd.clear();
            lcd.printString("  Welcome to  ", 0, 1);
            lcd.printString("  Roller Maze ", 0, 2);
            // printf("loop \n");
            lcd.drawLine(56, 40, 68, 40, FILL_BLACK);
            lcd.drawLine(56, 41, 68, 41, FILL_BLACK);
            lcd.drawCircle(i, 37, 4, FILL_BLACK);
            
            wait_ms(25);
            
            for (int c = 55; c < 68; c++){
                for (int d = 42; d < 47; d++){
                    
                    lcd.clearPixel(c, 42);
                    lcd.clearPixel(c, 43);
                    lcd.clearPixel(c, 44);
                    lcd.clearPixel(c, 45);
                    lcd.clearPixel(c, 46);
                    lcd.clearPixel(c, 47);
                    lcd.refresh();
                    
                }
            }
            
            lcd.refresh();
        }
        else if (i == 58){
            
            lcd.clear();
            lcd.printString("  Welcome to  ", 0, 1);
            lcd.printString("  Roller Maze ", 0, 2);
            // printf("loop \n");
            lcd.drawLine(56, 40, 68, 40, FILL_BLACK);
            lcd.drawLine(56, 41, 68, 41, FILL_BLACK);
            lcd.drawCircle(i, 38, 4, FILL_BLACK);
            
            wait_ms(25);
            
            for (int c = 55; c < 68; c++){
                for (int d = 42; d < 47; d++){
                    
                    lcd.clearPixel(c, 42);
                    lcd.clearPixel(c, 43);
                    lcd.clearPixel(c, 44);
                    lcd.clearPixel(c, 45);
                    lcd.clearPixel(c, 46);
                    lcd.clearPixel(c, 47);
                    lcd.refresh();
                    
                }
            }
            
            lcd.refresh();
            
        }
        else if (i == 59){
            
            lcd.clear();
            lcd.printString("  Welcome to  ", 0, 1);
            lcd.printString("  Roller Maze ", 0, 2);
            // printf("loop \n");
            lcd.drawLine(56, 40, 68, 40, FILL_BLACK);
            lcd.drawLine(56, 41, 68, 41, FILL_BLACK);
            lcd.drawCircle(i, 39, 4, FILL_BLACK);
            
            wait_ms(25);
            
            for (int c = 55; c < 68; c++){
                for (int d = 42; d < 47; d++){
                    
                    lcd.clearPixel(c, 42);
                    lcd.clearPixel(c, 43);
                    lcd.clearPixel(c, 44);
                    lcd.clearPixel(c, 45);
                    lcd.clearPixel(c, 46);
                    lcd.clearPixel(c, 47);
                    lcd.refresh();
                    
                }
            }
            
            lcd.refresh();
            
        }
        else {
            
            for (int j = 40; j < 48; j++){
                
                lcd.clear();
                lcd.printString("  Welcome to  ", 0, 1);
                lcd.printString("  Roller Maze ", 0, 2);
                // printf("loop \n");
                lcd.drawLine(56, 40, 68, 40, FILL_BLACK);
                lcd.drawLine(56, 41, 68, 41, FILL_BLACK);
                lcd.drawCircle(i, j, 4, FILL_BLACK);
                
                wait_ms(12);
                
                for (int c = 55; c < 68; c++){
                    for (int d = 42; d < 47; d++){
                        
                        lcd.clearPixel(c, 42);
                        lcd.clearPixel(c, 43);
                        lcd.clearPixel(c, 44);
                        lcd.clearPixel(c, 45);
                        lcd.clearPixel(c, 46);
                        lcd.clearPixel(c, 47);
                    }
                }
                
            }
            
            lcd.refresh();
        }
        
        // printf("%i \n", i);
    }
}

/**
 *  @details - Function to display a switch.
 */
void Animations::soundSwitch(N5110 &lcd, Gamepad &pad, bool tone)
{
    int exit = 0;
    bool _tone = tone;
    
    while(exit == 0) {
        
        lcd.clear();
        // draw casing rectangle
        lcd.drawRect(33, 27, 17, 9, FILL_TRANSPARENT);
        
        lcd.printString("Sound Settings", 0, 0);
        lcd.printString("  ON     OFF  ", 0, 2);
        
        // casing rectangle is filled in one side
        // depending on value of _tone
        if (_tone){
            lcd.drawRect(34, 28, 7, 7, FILL_BLACK);
        }
        else {
            lcd.drawRect(42, 28, 7, 7, FILL_BLACK);
        }
        
        lcd.refresh();
        
        wait_ms(10);
        
        if (pad.check_event(Gamepad::BACK_PRESSED)){
            
            return;
        }
    }
}

/**
 *  @details - Function to draw vertical joystick image.
 */
void Animations::drawVerticalJoystick(N5110 &lcd)
{
    for (int i = 33; i < 57; i++){
        for (int j = 42; j < 45; j++){
            lcd.setPixel(i, j);
        }
    }
    
    for (int i = 34; i < 56; i++){
        for (int j = 40; j < 42; j++){
            lcd.setPixel(i, j);
        }
    }
    
    for (int i = 35; i < 55; i++){
        for (int j = 38; j < 40; j++){
            lcd.setPixel(i, j);
        }
    }
    
    for (int i = 36; i < 54; i++){
        lcd.setPixel(i, 37);
    }
    
    for (int i = 37; i < 53; i++){
        lcd.setPixel(i, 36);
    }
    
    for (int i = 39; i < 51; i++){
        lcd.setPixel(i, 35);
    }
    
    for (int i = 41; i < 49; i++){
        lcd.setPixel(i, 34);
    }
    
    for (int i = 44; i < 46; i++){
        for (int j = 31; j < 34; j++){
            lcd.setPixel(i, j);
        }
    }
    
    for (int i = 37; i < 53; i++){
        for (int j = 29; j < 31; j++){
            lcd.setPixel(i, j);
        }
    }
    
    for (int i = 38; i < 52; i++){
        lcd.setPixel(i, 28);
    }
    
    for (int i = 40; i < 50; i++){
        lcd.setPixel(i, 27);
    }
    
    for (int i = 42; i < 48; i++){
        lcd.setPixel(i, 26);
    }
}

/**
 *  @details - Function to draw joystick image tilting to the left.
 */
void Animations::drawLeftJoystick(N5110 &lcd)
{
    for (int i = 33; i < 57; i++){
        for (int j = 42; j < 45; j++){
            lcd.setPixel(i, j);
        }
    }
    
    for (int i = 34; i < 56; i++){
        for (int j = 40; j < 42; j++){
            lcd.setPixel(i, j);
        }
    }
    
    for (int i = 35; i < 55; i++){
        for (int j = 38; j < 40; j++){
            lcd.setPixel(i, j);
        }
    }
    
    for (int i = 36; i < 54; i++){
        lcd.setPixel(i, 37);
    }
    
    for (int i = 37; i < 53; i++){
        lcd.setPixel(i, 36);
    }
    
    for (int i = 39; i < 51; i++){
        lcd.setPixel(i, 35);
    }
    
    for (int i = 39; i < 49; i++){
        lcd.setPixel(i, 34);
    }
    
    for (int i = 38; i < 41; i++){
        lcd.setPixel(i, 33);
    }
    
    for (int i = 37; i < 40; i++){
        lcd.setPixel(i, 32);
    }
    
    for (int i = 33; i < 39; i++){
        lcd.setPixel(i, 31);
    }
    
    for (int j = 32; j < 36; j++){
        lcd.setPixel(31, j);
    }
    
    for (int j = 29; j < 35; j++){
        lcd.setPixel(32, j);
    }
    
    for (int j = 28; j < 34; j++){
        lcd.setPixel(33, j);
    }
    
    for (int j = 27; j < 33; j++){
        lcd.setPixel(34, j);
    }
    
    for (int j = 26; j < 32; j++){
        lcd.setPixel(35, j);
    }
    
    for (int j = 26; j < 31; j++){
        lcd.setPixel(36, j);
        lcd.setPixel(37, j);
    }
    
    for (int j = 25; j < 29; j++){
        lcd.setPixel(38, j);
    }
    
    for (int j = 25; j < 28; j++){
        lcd.setPixel(39, j);
    }
    
    lcd.setPixel(40, 25);
    lcd.setPixel(40, 26);
    lcd.setPixel(41, 25);
}

/**
 *  @details - Function to draw joystick image tilting to the right.
 */
void Animations::drawRightJoystick(N5110 &lcd)
{
    for (int i = 33; i < 57; i++){
        for (int j = 42; j < 45; j++){
            lcd.setPixel(i, j);
        }
    }
    
    for (int i = 34; i < 56; i++){
        for (int j = 40; j < 42; j++){
            lcd.setPixel(i, j);
        }
    }
    
    for (int i = 35; i < 55; i++){
        for (int j = 38; j < 40; j++){
            lcd.setPixel(i, j);
        }
    }
    
    for (int i = 36; i < 54; i++){
        lcd.setPixel(i, 37);
    }
    
    for (int i = 37; i < 53; i++){
        lcd.setPixel(i, 36);
    }
    
    for (int i = 39; i < 51; i++){
        lcd.setPixel(i, 35);
    }
    
    for (int i = 41; i < 51; i++){
        lcd.setPixel(i, 34);
    }
    
    for (int i = 49; i < 52; i++){
        lcd.setPixel(i, 33);
    }
    
    for (int i = 50; i < 53; i++){
        lcd.setPixel(i, 32);
    }
    
    for (int i = 51; i < 55; i++){
        lcd.setPixel(i, 31);
    }
    
    for (int j = 32; j < 36; j++){
        lcd.setPixel(58, j);
    }
    
    for (int j = 29; j < 35; j++){
        lcd.setPixel(57, j);
    }
    
    for (int j = 28; j < 34; j++){
        lcd.setPixel(56, j);
    }
    
    for (int j = 27; j < 33; j++){
        lcd.setPixel(55, j);
    }
    
    for (int i = 52; i < 55; i++){
        for (int j = 26; j < 31; j++){
            lcd.setPixel(i, j);
        }
    }
    
    for (int j = 25; j < 29; j++){
        lcd.setPixel(51, j);
    }
    
    for (int j = 25; j < 28; j++){
        lcd.setPixel(50, j);
    }
    
    lcd.setPixel(48, 25);
    lcd.setPixel(49, 25);
    lcd.setPixel(49, 26);
}

/**
 *  @details - Function to draw gamepad image tilting to the left.
 */
void Animations::drawLeftGamepad(N5110 &lcd)
{
    for (int i = 33; i < 42; i++){
        lcd.setPixel(i, 27);
    }
    for (int i = 31; i < 47; i++){
        for (int j = 28; j < 30; j++){
            lcd.setPixel(i, j);
        }
    }
    for (int i = 30; i < 53; i++){
        for (int j = 30; j < 43; j++){
            lcd.setPixel(i, j);
        }
    }
    lcd.clearPixel(51, 30);
    lcd.clearPixel(52, 30);
    lcd.clearPixel(51, 31);
    lcd.clearPixel(52, 31);
    lcd.clearPixel(52, 32);
    
    for (int i = 35; i < 43; i++){
        for (int j = 30; j < 33; j++){
            lcd.clearPixel(i, j);
        }
    }
    
    for (int i = 36; i < 44; i++){
        for (int j = 33; j < 36; j++){
            lcd.clearPixel(i, j);
        }
    }
    
    for (int j = 33; j < 40; j++){
        lcd.setPixel(29, j);
    }
    
    for (int j = 36; j < 42; j++){
        lcd.setPixel(53, j);
    }
    
    for (int i = 31; i < 39; i++){
        lcd.setPixel(i, 43);
    }
    
    for (int i = 32; i < 38; i++){
        lcd.setPixel(i, 44);
    }
    
    for (int i = 33; i < 37; i++){
        lcd.setPixel(i, 45);
    }
    
    for (int i = 46; i < 53; i++){
        lcd.setPixel(i, 43);
        lcd.setPixel(i, 44);
    }
    
    lcd.clearPixel(46, 44);
    
    for (int i = 48; i < 52; i++){
        lcd.setPixel(i, 45);
    }
    
    lcd.clearPixel(31, 45);
    lcd.clearPixel(32, 45);
}

/**
 *  @details - Function to draw vertical gamepad image.
 */
void Animations::drawVerticalGamepad(N5110 &lcd)
{
    for (int i = 38; i < 48; i++){
        lcd.setPixel(i, 27);
    }
    
    for (int i = 35; i < 51; i++){
        lcd.setPixel(i, 28);
    }
    
    for (int i = 33; i < 53; i++){
        for (int j = 29; j < 43; j++){
            lcd.setPixel(i, j);
        }
    }
    
    for (int i = 39; i < 47; i++){
        for (int j = 30; j < 36; j++){
            lcd.clearPixel(i, j);
        }
    }
    
    for (int j = 37; j < 42; j++){
        lcd.setPixel(30, j);
        lcd.setPixel(55, j);
    }
    
    for (int j = 34; j < 44; j++){
        lcd.setPixel(31, j);
        lcd.setPixel(54, j);
    }
    
    for (int j = 31; j < 45; j++){
        lcd.setPixel(32, j);
        lcd.setPixel(53, j);
    }
    
    for (int i = 33; i < 39; i++){
        lcd.setPixel(i, 43);
        lcd.setPixel(i, 44);
        lcd.setPixel(i, 45);
    }
    
    lcd.clearPixel(38, 44);
    lcd.clearPixel(37, 45);
    lcd.clearPixel(38, 45);
    
    for (int i = 47; i < 53; i++){
        lcd.setPixel(i, 43);
        lcd.setPixel(i, 44);
        lcd.setPixel(i, 45);
    }
    
    lcd.clearPixel(47, 44);
    lcd.clearPixel(47, 45);
    lcd.clearPixel(48, 45);
}

/**
 *  @details - Function to draw gamepad image tilting to the right.
 */
void Animations::drawRightGamepad(N5110 &lcd)
{
    for (int i = 43; i < 52; i++){
        lcd.setPixel(i, 27);
    }
    
    for (int i = 38; i < 54; i++){
        lcd.setPixel(i, 28);
    }
    
    for (int i = 36; i < 54; i++){
        lcd.setPixel(i, 29);
    }
    
    for (int i = 34; i < 55; i++){
        for (int j = 30; j < 43; j++){
            lcd.setPixel(i, j);
        }
    }
    
    for (int i = 42; i < 50; i++){
        for (int j = 30; j < 33; j++){
            lcd.clearPixel(i, j);
        }
    }
    
    for (int i = 41; i < 49; i++){
        for (int j = 33; j < 36; j++){
            lcd.clearPixel(i, j);
        }
    }
    
    for (int j = 36; j < 42; j++){
        lcd.setPixel(31, j);
    }
    
    for (int j = 33; j < 45; j++){
        lcd.setPixel(32, j);
    }
    
    for (int j = 32; j < 46; j++){
        lcd.setPixel(33, j);
    }
    
    for (int i = 34; i < 39; i++){
        lcd.setPixel(i, 43);
        lcd.setPixel(i, 44);
        lcd.setPixel(i, 45);
    }
    
    lcd.clearPixel(37, 45);
    lcd.clearPixel(38, 44);
    lcd.clearPixel(38, 45);
    
    for (int i = 46; i < 54; i++){
        lcd.setPixel(i, 43);
    }
    
    for (int i = 47; i < 53; i++){
        lcd.setPixel(i, 44);
    }
    
    for (int i = 48; i < 52; i++){
        lcd.setPixel(i, 45);
    }
    
    for (int j = 33; j < 40; j++){
        lcd.setPixel(55, j);
    }
}

/**
 *  @details - Short animation to be used maze is completed.
 */
void Animations::mazeCompleted(N5110 &lcd)
{
    lcd.printString("  MAZE", 0, 2);
    lcd.printString("  DONE!", 0, 3);
}

/**
 *  @details - First animation in a series to create a jumping man.
 */
void Animations::stickmanOne(N5110 &lcd)
{
    lcd.clear();
    mazeCompleted(lcd);
    
    // drawing arms
    lcd.drawLine(53, 26, 53, 27, FILL_BLACK);
    lcd.setPixel(54, 25);
    lcd.setPixel(55, 24);
    lcd.drawLine(55, 23, 56, 23, FILL_BLACK);
    lcd.drawLine(58, 22, 62, 22, FILL_BLACK);
    lcd.setPixel(63, 22);
    lcd.setPixel(64, 22);
    lcd.setPixel(63, 23);
    lcd.setPixel(64, 23);
    lcd.setPixel(65, 24);
    lcd.setPixel(66, 25);
    lcd.drawLine(67, 26, 67, 27, FILL_BLACK);
    
    // drawing head
    lcd.drawCircle(60, 17, 3, FILL_BLACK);
    
    // draw body and legs
    lcd.drawLine(60, 17, 60, 30, FILL_BLACK);
    lcd.drawLine(59, 31, 59, 35, FILL_BLACK);
    lcd.drawLine(61, 31, 61, 35, FILL_BLACK);
    lcd.drawLine(58, 35, 58, 38, FILL_BLACK);
    lcd.drawLine(62, 35, 62, 38, FILL_BLACK);
    lcd.drawLine(57, 39, 57, 41, FILL_BLACK);
    lcd.drawLine(63, 39, 63, 41, FILL_BLACK);
    
}

/**
 *  @details - Second animation in a series to create a jumping man.
 */
void Animations::stickmanTwo(N5110 &lcd)
{
    lcd.clear();
    mazeCompleted(lcd);
    
    // drawing arms
    lcd.drawLine(53, 25, 56, 22, FILL_BLACK);
    lcd.setPixel(57, 22);
    lcd.drawLine(58, 21, 62, 21, FILL_BLACK);
    lcd.setPixel(63, 22);
    lcd.drawLine(64, 22, 67, 25, FILL_BLACK);
    
    // drawing head
    lcd.drawCircle(60, 16, 3, FILL_BLACK);
    
    // drawing body and legs
    lcd.drawLine(58, 35, 58, 41, FILL_BLACK);
    lcd.drawLine(59, 30, 59, 34, FILL_BLACK);
    lcd.drawLine(60, 16, 60, 29, FILL_BLACK);
    lcd.drawLine(61, 30, 61, 34, FILL_BLACK);
    lcd.drawLine(62, 35, 62, 41, FILL_BLACK);
    
}

/**
 *  @details - Third animation in a series to create a jumping man.
 */
void Animations::stickmanThree(N5110 &lcd)
{
    lcd.clear();
    mazeCompleted(lcd);
    
    // drawing arms
    lcd.drawLine(52, 23, 57, 20, FILL_BLACK);
    lcd.drawLine(57, 20, 63, 20, FILL_BLACK);
    lcd.drawLine(63, 20, 68, 23, FILL_BLACK);
    
    // drawing head
    lcd.drawCircle(60, 15, 3, FILL_BLACK);
    
    // drawing body and legs
    lcd.drawLine(58, 35, 58, 41, FILL_BLACK);
    lcd.drawLine(59, 29, 59, 34, FILL_BLACK);
    lcd.drawLine(60, 16, 60, 28, FILL_BLACK);
    lcd.drawLine(61, 29, 61, 34, FILL_BLACK);
    lcd.drawLine(62, 35, 62, 41, FILL_BLACK);
    
}

/**
 *  @details - Fourth animation in a series to create a jumping man.
 */
void Animations::stickmanFour(N5110 &lcd)
{
    lcd.clear();
    mazeCompleted(lcd);
    
    // drawing arms
    lcd.drawLine(52, 20, 53, 20, FILL_BLACK);
    lcd.drawLine(54, 21, 56, 21, FILL_BLACK);
    lcd.drawLine(57, 20, 63, 20, FILL_BLACK);
    lcd.drawLine(64, 21, 66, 21, FILL_BLACK);
    lcd.drawLine(67, 20, 68, 20, FILL_BLACK);
    
    // drawing head
    lcd.drawCircle(60, 15, 3, FILL_BLACK);
    
    // drawing body and legs
    lcd.drawLine(58, 34, 58, 40, FILL_BLACK);
    lcd.drawLine(59, 29, 59, 33, FILL_BLACK);
    lcd.drawLine(60, 16, 60, 28, FILL_BLACK);
    lcd.drawLine(61, 29, 61, 33, FILL_BLACK);
    lcd.drawLine(62, 34, 62, 40, FILL_BLACK);
    
}

/**
 *  @details - Fifth animation in a series to create a jumping man.
 */
void Animations::stickmanFive(N5110 &lcd)
{
    lcd.clear();
    mazeCompleted(lcd);
    
    // drawing arms
    lcd.drawLine(52, 17, 59, 19, FILL_BLACK);
    lcd.drawLine(61, 19, 68, 17, FILL_BLACK);
    
    // drawing head
    lcd.drawCircle(60, 14, 3, FILL_BLACK);
    
    // drawing body and legs
    lcd.drawLine(58, 33, 58, 39, FILL_BLACK);
    lcd.drawLine(59, 28, 59, 32, FILL_BLACK);
    lcd.drawLine(60, 16, 60, 27, FILL_BLACK);
    lcd.drawLine(61, 28, 61, 32, FILL_BLACK);
    lcd.drawLine(62, 33, 62, 39, FILL_BLACK);
    
}

/**
 *  @details - Sixth animation in a series to create a jumping man.
 */
void Animations::stickmanSix(N5110 &lcd)
{
    lcd.clear();
    mazeCompleted(lcd);
    
    // drawing arms
    lcd.drawLine(52, 15, 59, 18, FILL_BLACK);
    lcd.drawLine(61, 18, 68, 15, FILL_BLACK);
    
    // drawing head
    lcd.drawCircle(60, 13, 3, FILL_BLACK);
    
    // drawing body and legs
    lcd.drawLine(58, 32, 58, 38, FILL_BLACK);
    lcd.drawLine(59, 27, 59, 31, FILL_BLACK);
    lcd.drawLine(60, 16, 60, 26, FILL_BLACK);
    lcd.drawLine(61, 27, 61, 31, FILL_BLACK);
    lcd.drawLine(62, 32, 62, 38, FILL_BLACK);
    
}







