#include "Maze.h"

/**
 *  @details - constructor
 */
Maze::Maze()
{
    
}

/**
 *  @details - constructor
 */
Maze::~Maze()
{
    
}

/**
 *  @details - Initalise object with index value.
 */
void Maze::init(int mazeIndex)
{
    _mazeIndex = mazeIndex;
}

/**
 *  @details - Maze is drawn on LCD screen.
 */
void Maze::draw(N5110 &lcd)
{
    /// EASY MAZES ///
    if (_mazeIndex == 0){
        mazeIndexZero(lcd);
    }
    else if (_mazeIndex == 1){
        mazeIndexOne(lcd);
    }
    else if (_mazeIndex == 2){
        mazeIndexTwo(lcd);
    }
    /// MEDIUM MAZES ///
    else if (_mazeIndex == 3){
        mazeIndexThree(lcd);
    }
    else if (_mazeIndex == 4){
        mazeIndexFour(lcd);
    }
    else if (_mazeIndex == 5){
        mazeIndexFive(lcd);
    }
    /// HARD MAZES ///
    else if (_mazeIndex == 6){
        mazeIndexSix(lcd);
    }
    else if (_mazeIndex == 7){
        mazeIndexSeven(lcd);
    }
    else if (_mazeIndex == 8){
        mazeIndexEight(lcd);
    }
    /// EXTREME MAZE ///
    else if (_mazeIndex == 9){
        mazeIndexNine(lcd);
    }
}

/**
 *  @details - Creating lcd buffer for maze 0
 */
void Maze::mazeIndexZero(N5110 &lcd)
{
    // easy maze 1
    // index 0
    lcd.drawRect(0, 0, 84, 48, FILL_TRANSPARENT);
    
    lcd.drawLine(10, 0, 10, 39, FILL_BLACK);
    lcd.drawLine(10, 39, 20, 39, FILL_BLACK);
    lcd.drawLine(20, 0, 20, 20, FILL_BLACK);
    lcd.drawLine(30, 10, 39, 10, FILL_BLACK);
    lcd.drawLine(20, 30, 30, 30, FILL_BLACK);
    lcd.drawLine(20, 20, 40, 20, FILL_BLACK);
    lcd.drawLine(40, 0, 40, 10, FILL_BLACK);
    lcd.drawLine(30, 30, 30, HEIGHT - 1, FILL_BLACK);
    lcd.drawLine(30, 39, 50, 39, FILL_BLACK);
    lcd.drawLine(40, 20, 40, 30, FILL_BLACK);
    lcd.drawLine(40, 30, 60, 30, FILL_BLACK);
    lcd.drawLine(50, 20, 71, 20, FILL_BLACK);
    lcd.drawLine(50, 10, 50, 20, FILL_BLACK);
    lcd.drawLine(60, 30, 60, 39, FILL_BLACK);
    lcd.drawLine(71, 20, 71, 39, FILL_BLACK);
    lcd.drawLine(50, 10, WIDTH - 1, 10, FILL_BLACK);
    
    // drawing the goal
    for (int j = 1; j < 10; j++){
        lcd.clearPixel(83, j);
    }
}

/**
 *  @details - Creating lcd buffer for maze 1
 */
void Maze::mazeIndexOne(N5110 &lcd)
{
    // easy maze 2
    // index 1
    lcd.drawRect(0, 0, 84, 48, FILL_TRANSPARENT);
    
    lcd.drawLine(10, 0, 10, 20, FILL_BLACK);
    lcd.drawLine(20, 10, 40, 10, FILL_BLACK);
    lcd.drawLine(50, 10, 71, 10, FILL_BLACK);
    lcd.drawLine(30, 10, 30, 30, FILL_BLACK);
    lcd.drawLine(50, 10, 50, 30, FILL_BLACK);
    lcd.drawLine(10, 20, 20, 20, FILL_BLACK);
    lcd.drawLine(40, 20, 50, 20, FILL_BLACK);
    lcd.drawLine(71, 20, 83, 20, FILL_BLACK);
    lcd.drawLine(60, 20, 60, 39, FILL_BLACK);
    lcd.drawLine(71, 20, 71, 30, FILL_BLACK);
    lcd.drawLine(20, 30, 40, 30, FILL_BLACK);
    lcd.drawLine(10, 30, 10, 39, FILL_BLACK);
    lcd.drawLine(40, 30, 40, 47, FILL_BLACK);
    lcd.drawLine(60, 10, 60, 20, FILL_BLACK);
    lcd.drawLine(10, 39, 40, 39, FILL_BLACK);
    lcd.drawLine(50, 39, 83, 39, FILL_BLACK);
    
    // drawing the goal
    for (int j = 21; j < 30; j++){
        lcd.clearPixel(83, j);
    }
}

/**
 *  @details - Creating lcd buffer for maze 2
 */
void Maze::mazeIndexTwo(N5110 &lcd)
{
    // easy maze 3
    // index 2
    lcd.drawRect(0, 0, 84, 48, FILL_TRANSPARENT);
    
    lcd.drawLine(20, 0, 20, 20, FILL_BLACK);
    lcd.drawLine(40, 0, 40, 20, FILL_BLACK);
    lcd.drawLine(0, 10, 10, 10, FILL_BLACK);
    lcd.drawLine(10, 30, 40, 30, FILL_BLACK);
    lcd.drawLine(71, 0, 71, 10, FILL_BLACK);
    lcd.drawLine(10, 10, 10, 20, FILL_BLACK);
    lcd.drawLine(50, 10, 60, 10, FILL_BLACK);
    lcd.drawLine(60, 20, 60, 30, FILL_BLACK);
    lcd.drawLine(71, 30, 83, 30, FILL_BLACK);
    lcd.drawLine(30, 10, 30, 39, FILL_BLACK);
    lcd.drawLine(50, 10, 50, 39, FILL_BLACK);
    lcd.drawLine(60, 20, 83, 20, FILL_BLACK);
    lcd.drawLine(10, 30, 10, 39, FILL_BLACK);
    lcd.drawLine(40, 30, 40, 47, FILL_BLACK);
    lcd.drawLine(71, 30, 71, 39, FILL_BLACK);
    lcd.drawLine(20, 39, 20, 47, FILL_BLACK);
    lcd.drawLine(50, 39, 71, 39, FILL_BLACK);
    
    // drawing the goal
    for (int j = 21; j < 30; j++){
        lcd.clearPixel(83, j);
    }
    
}

/**
 *  @details - Creating lcd buffer for maze 3
 */
void Maze::mazeIndexThree(N5110 &lcd)
{
    // medium maze 1
    // maze index 3
    lcd.drawRect(0, 0, 84, 48, FILL_TRANSPARENT);
    
    lcd.drawLine(16, 0, 16, 8, FILL_BLACK);
    lcd.drawLine(56, 0, 56, 16, FILL_BLACK);
    lcd.drawLine(80, 0, 80, 16, FILL_BLACK);
    lcd.drawLine(8, 8, 24, 8, FILL_BLACK);
    lcd.drawLine(32, 8, 48, 8, FILL_BLACK);
    lcd.drawLine(64, 8, 72, 8, FILL_BLACK);
    lcd.drawLine(8, 8, 8, 40, FILL_BLACK);
    lcd.drawLine(24, 8, 24, 16, FILL_BLACK);
    lcd.drawLine(32, 8, 32, 40, FILL_BLACK);
    lcd.drawLine(48, 8, 48, 16, FILL_BLACK);
    lcd.drawLine(64, 8, 64, 24, FILL_BLACK);
    lcd.drawLine(72, 8, 72, 24, FILL_BLACK);
    lcd.drawLine(16, 16, 16, 24, FILL_BLACK);
    lcd.drawLine(40, 16, 40, 24, FILL_BLACK);
    lcd.drawLine(80, 16, 84, 16, FILL_BLACK);
    lcd.drawLine(16, 24, 32, 24, FILL_BLACK);
    lcd.drawLine(40, 24, 64, 24, FILL_BLACK);
    lcd.drawLine(8, 32, 24, 32, FILL_BLACK);
    lcd.drawLine(40, 32, 40, 40, FILL_BLACK);
    lcd.drawLine(48, 32, 48, 48, FILL_BLACK);
    lcd.drawLine(64, 32, 72, 32, FILL_BLACK);
    lcd.drawLine(72, 32, 72, 40, FILL_BLACK);
    lcd.drawLine(32, 40, 40, 40, FILL_BLACK);
    lcd.drawLine(72, 40, 84, 40, FILL_BLACK);
    lcd.drawLine(16, 40, 16, 48, FILL_BLACK);
    lcd.drawLine(64, 40, 64, 48, FILL_BLACK);
    lcd.drawLine(24, 32, 24, 40, FILL_BLACK);
    lcd.drawLine(40, 24, 40, 40, FILL_BLACK);
    lcd.drawLine(56, 24, 56, 40, FILL_BLACK);
    lcd.drawLine(64, 32, 72, 32, FILL_BLACK);
    lcd.drawLine(56, 40, 64, 40, FILL_BLACK);
    
    // drawing the goal
    for (int j = 41; j < 47; j++){
        lcd.clearPixel(83, j);
    }
}

/**
 *  @details - Creating lcd buffer for maze 4
 */
void Maze::mazeIndexFour(N5110 &lcd)
{
    // medium maze 2
    // index 4
    lcd.drawRect(0, 0, 84, 48, FILL_TRANSPARENT);
    
    // vertical
    lcd.drawLine(8, 0, 8, 8, FILL_BLACK);
    lcd.drawLine(32, 0, 32, 16, FILL_BLACK);
    lcd.drawLine(64, 0, 64, 16, FILL_BLACK);
    
    //horizontal
    lcd.drawLine(16, 8, 24, 8, FILL_BLACK);
    lcd.drawLine(40, 8, 56, 8, FILL_BLACK);
    //vertical
    lcd.drawLine(16, 8, 16, 24, FILL_BLACK);
    lcd.drawLine(40, 8, 40, 32, FILL_BLACK);
    lcd.drawLine(73, 8, 73, 32, FILL_BLACK);
    
    // horizontal
    lcd.drawLine(0, 16, 8, 16, FILL_BLACK);
    lcd.drawLine(24, 16, 32, 16, FILL_BLACK);
    lcd.drawLine(48, 16, 64, 16, FILL_BLACK);
    // vertical
    lcd.drawLine(56, 16, 56, 32, FILL_BLACK);
    
    // horizontal
    lcd.drawLine(8, 24, 48, 24, FILL_BLACK);
    lcd.drawLine(64, 24, 73, 24, FILL_BLACK);
    // vertical
    lcd.drawLine(8, 24, 8, 40, FILL_BLACK);
    lcd.drawLine(64, 24, 64, 40, FILL_BLACK);
    
    // horizontal
    lcd.drawLine(24, 32, 56, 32, FILL_BLACK);
    // vertical
    lcd.drawLine(16, 32, 16, 40, FILL_BLACK);
    lcd.drawLine(32, 32, 32, 40, FILL_BLACK);
    lcd.drawLine(48, 32, 48, 40, FILL_BLACK);
    
    // horizontal
    lcd.drawLine(16, 40, 32, 40, FILL_BLACK);
    lcd.drawLine(64, 40, 83, 40, FILL_BLACK);
    // vertical
    lcd.drawLine(40, 40, 40, 47, FILL_BLACK);
    lcd.drawLine(56, 40, 56, 47, FILL_BLACK);
    
    // drawing the goal
    for (int j = 41; j < 47; j++){
        lcd.clearPixel(83, j);
    }
    
}

/**
 *  @details - Creating lcd buffer for maze 5
 */
void Maze::mazeIndexFive(N5110 &lcd)
{
    // medium maze 3
    // maze index 5
    
    lcd.drawRect(0, 0, 84, 48, FILL_TRANSPARENT);
    
    // vertical
    lcd.drawLine(8, 0, 8, 16, FILL_BLACK);
    lcd.drawLine(24, 0, 24, 16, FILL_BLACK);
    lcd.drawLine(48, 0, 48, 16, FILL_BLACK);
    lcd.drawLine(64, 0, 64, 8, FILL_BLACK);
    
    // horizontal
    lcd.drawLine(32, 8, 40, 8, FILL_BLACK);
    // vertical
    lcd.drawLine(16, 8, 16, 16, FILL_BLACK);
    lcd.drawLine(32, 8, 32, 24, FILL_BLACK);
    lcd.drawLine(56, 8, 56, 24, FILL_BLACK);
    lcd.drawLine(73, 8, 73, 16, FILL_BLACK);
    
    // horizontal
    lcd.drawLine(16, 16, 24, 16, FILL_BLACK);
    lcd.drawLine(40, 16, 48, 16, FILL_BLACK);
    lcd.drawLine(56, 16, 73, 16, FILL_BLACK);
    // vertical
    
    // horizontal
    lcd.drawLine(0, 24, 8, 24, FILL_BLACK);
    lcd.drawLine(16, 24, 56, 24, FILL_BLACK);
    lcd.drawLine(64, 24, 83, 24, FILL_BLACK);
    // vertical
    lcd.drawLine(16, 24, 16, 32, FILL_BLACK);
    lcd.drawLine(40, 24, 40, 40, FILL_BLACK);
    
    // horizontal
    lcd.drawLine(8, 32, 32, 32, FILL_BLACK);
    lcd.drawLine(48, 32, 73, 32, FILL_BLACK);
    // vertical
    lcd.drawLine(8, 32, 8, 40, FILL_BLACK);
    lcd.drawLine(48, 32, 48, 40, FILL_BLACK);
    lcd.drawLine(64, 32, 64, 40, FILL_BLACK);
    lcd.drawLine(73, 32, 73, 47, FILL_BLACK);
    
    // horizontal
    lcd.drawLine(16, 40, 40, 40, FILL_BLACK);
    // vertical
    lcd.drawLine(16, 40, 16, 47, FILL_BLACK);
    lcd.drawLine(56, 40, 56, 47, FILL_BLACK);
    
    // drawing the goal
    for (int j = 41; j < 47; j++){
        lcd.clearPixel(83, j);
    }
    
}

/**
 *  @details - Creating lcd buffer for maze 6
 */
void Maze::mazeIndexSix(N5110 &lcd)
{
    // hard maze 1
    // maze index 6
    
    lcd.drawRect(2, 0, 81, 47, FILL_TRANSPARENT);
    
    lcd.drawLine(7, 1, 7, 6, FILL_BLACK);
    lcd.drawLine(22, 1, 22, 11, FILL_BLACK);
    lcd.drawLine(42, 1, 42, 21, FILL_BLACK);
    lcd.drawLine(57, 1, 57, 16, FILL_BLACK);
    lcd.drawLine(12, 6, 17, 6, FILL_BLACK);
    lcd.drawLine(27, 6, 37, 6, FILL_BLACK);
    lcd.drawLine(47, 6, 52, 6, FILL_BLACK);
    lcd.drawLine(72, 6, 82, 6, FILL_BLACK);
    lcd.drawLine(12, 6, 12, 26, FILL_BLACK);
    lcd.drawLine(37, 6, 37, 16, FILL_BLACK);
    lcd.drawLine(47, 6, 47, 21, FILL_BLACK);
    lcd.drawLine(62, 6, 62, 21, FILL_BLACK);
    lcd.drawLine(67, 6, 67, 11, FILL_BLACK);
    lcd.drawLine(2, 11, 7, 11, FILL_BLACK);
    lcd.drawLine(17, 11, 32, 11, FILL_BLACK);
    lcd.drawLine(52, 11, 57, 11, FILL_BLACK);
    lcd.drawLine(67, 11, 77, 11, FILL_BLACK);
    lcd.drawLine(32, 11, 32, 21, FILL_BLACK);
    lcd.drawLine(72, 11, 72, 21, FILL_BLACK);
    lcd.drawLine(7, 16, 17, 16, FILL_BLACK);
    lcd.drawLine(22, 16, 27, 16, FILL_BLACK);
    lcd.drawLine(37, 16, 42, 16, FILL_BLACK);
    lcd.drawLine(47, 16, 57, 16, FILL_BLACK);
    lcd.drawLine(62, 16, 67, 16, FILL_BLACK);
    lcd.drawLine(77, 16, 82, 16, FILL_BLACK);
    lcd.drawLine(17, 16, 17, 21, FILL_BLACK);
    lcd.drawLine(27, 16, 27, 26, FILL_BLACK);
    lcd.drawLine(2, 21, 7, 21, FILL_BLACK);
    lcd.drawLine(17, 21, 22, 21, FILL_BLACK);
    lcd.drawLine(17, 31, 17, 36, FILL_BLACK);
    lcd.drawLine(32, 21, 37, 21, FILL_BLACK);
    lcd.drawLine(52, 21, 62, 21, FILL_BLACK);
    lcd.drawLine(67, 21, 77, 21, FILL_BLACK);
    lcd.drawLine(22, 21, 22, 26, FILL_BLACK);
    lcd.drawLine(37, 21, 37, 26, FILL_BLACK);
    lcd.drawLine(52, 21, 52, 31, FILL_BLACK);
    lcd.drawLine(77, 21, 77, 31, FILL_BLACK);
    lcd.drawLine(7, 26, 17, 26, FILL_BLACK);
    lcd.drawLine(27, 26, 32, 26, FILL_BLACK);
    lcd.drawLine(37, 26, 52, 26, FILL_BLACK);
    lcd.drawLine(57, 26, 77, 26, FILL_BLACK);
    lcd.drawLine(7, 26, 7, 31, FILL_BLACK);
    lcd.drawLine(17, 26, 17, 26, FILL_BLACK);
    lcd.drawLine(32, 26, 32, 41, FILL_BLACK);
    lcd.drawLine(42, 26, 42, 41, FILL_BLACK);
    lcd.drawLine(67, 26, 67, 41, FILL_BLACK);
    lcd.drawLine(17, 31, 27, 31, FILL_BLACK);
    lcd.drawLine(32, 31, 42, 31, FILL_BLACK);
    lcd.drawLine(52, 31, 62, 31, FILL_BLACK);
    lcd.drawLine(72, 31, 77, 31, FILL_BLACK);
    lcd.drawLine(12, 31, 12, 36, FILL_BLACK);
    lcd.drawLine(47, 31, 47, 46, FILL_BLACK);
    lcd.drawLine(62, 31, 62, 41, FILL_BLACK);
    lcd.drawLine(72, 31, 72, 46, FILL_BLACK);
    lcd.drawLine(2, 36, 12, 36, FILL_BLACK);
    lcd.drawLine(22, 36, 27, 36, FILL_BLACK);
    lcd.drawLine(32, 36, 37, 36, FILL_BLACK);
    lcd.drawLine(47, 36, 57, 36, FILL_BLACK);
    lcd.drawLine(77, 36, 82, 36, FILL_BLACK);
    lcd.drawLine(22, 36, 22, 46, FILL_BLACK);
    lcd.drawLine(7, 41, 22, 41, FILL_BLACK);
    lcd.drawLine(27, 41, 31, 41, FILL_BLACK);
    lcd.drawLine(37, 41, 42, 41, FILL_BLACK);
    lcd.drawLine(52, 41, 62, 41, FILL_BLACK);
    lcd.drawLine(77, 37, 77, 41, FILL_BLACK);
    
    // drawing the goal
    for (int j = 37; j < 42; j++){
        lcd.clearPixel(82, j);
    }
}

/**
 *  @details - Creating lcd buffer for maze 7
 */
void Maze::mazeIndexSeven(N5110 &lcd)
{
    // hard maze 2
    // maze index 7
    lcd.drawRect(2, 1, 82, 46, FILL_TRANSPARENT);
    
    //vertical
    lcd.drawLine(12, 1, 12, 11, FILL_BLACK);
    lcd.drawLine(52, 1, 52, 16, FILL_BLACK);
    lcd.drawLine(67, 1, 67, 11, FILL_BLACK);
    lcd.drawLine(77, 1, 77, 31, FILL_BLACK);
    
    // horizontal
    lcd.drawLine(2, 6, 7, 6, FILL_BLACK);
    lcd.drawLine(17, 6, 32, 6, FILL_BLACK);
    lcd.drawLine(37, 6, 47, 6, FILL_BLACK);
    lcd.drawLine(57, 6, 62, 6, FILL_BLACK);
    // vertical
    lcd.drawLine(32, 6, 32, 21, FILL_BLACK);
    lcd.drawLine(37, 6, 37, 26, FILL_BLACK);
    lcd.drawLine(47, 6, 47, 31, FILL_BLACK);
    lcd.drawLine(62, 6, 62, 36, FILL_BLACK);
    lcd.drawLine(72, 6, 72, 16, FILL_BLACK);
    
    // horizontal
    lcd.drawLine(17, 11, 27, 11, FILL_BLACK);
    lcd.drawLine(17, 11, 27, 11, FILL_BLACK);
    lcd.drawLine(52, 11, 57, 11, FILL_BLACK);
    // vertical
    lcd.drawLine(7, 11, 7, 16, FILL_BLACK);
    lcd.drawLine(17, 11, 17, 31, FILL_BLACK);
    lcd.drawLine(42, 11, 42, 36, FILL_BLACK);
    
    // horizontal
    lcd.drawLine(7, 16, 17, 16, FILL_BLACK);
    lcd.drawLine(22, 16, 27, 16, FILL_BLACK);
    lcd.drawLine(57, 16, 72, 16, FILL_BLACK);
    // vertical
    lcd.drawLine(27, 16, 27, 31, FILL_BLACK);
    
    // horizontal
    lcd.drawLine(2, 21, 12, 21, FILL_BLACK);
    lcd.drawLine(17, 21, 22, 21, FILL_BLACK);
    lcd.drawLine(32, 21, 37, 21, FILL_BLACK);
    lcd.drawLine(47, 21, 57, 21, FILL_BLACK);
    lcd.drawLine(67, 21, 77, 21, FILL_BLACK);
    // vertical
    lcd.drawLine(22, 21, 22, 26, FILL_BLACK);
    
    // horizontal
    lcd.drawLine(7, 26, 12, 26, FILL_BLACK);
    lcd.drawLine(27, 26, 37, 26, FILL_BLACK);
    lcd.drawLine(52, 26, 72, 26, FILL_BLACK);
    // vertical
    lcd.drawLine(7, 26, 7, 41, FILL_BLACK);
    lcd.drawLine(72, 26, 72, 31, FILL_BLACK);
    
    // horizontal
    lcd.drawLine(12, 31, 27, 31, FILL_BLACK);
    lcd.drawLine(32, 31, 41, 31, FILL_BLACK);
    lcd.drawLine(47, 31, 62, 31, FILL_BLACK);
    lcd.drawLine(72, 31, 77, 31, FILL_BLACK);
    // vertical
    lcd.drawLine(12, 31, 12, 36, FILL_BLACK);
    lcd.drawLine(22, 31, 22, 36, FILL_BLACK);
    lcd.drawLine(37, 31, 37, 41, FILL_BLACK);
    lcd.drawLine(67, 31, 67, 36, FILL_BLACK);
    
    // horizontal
    lcd.drawLine(22, 36, 32, 36, FILL_BLACK);
    lcd.drawLine(42, 36, 57, 36, FILL_BLACK);
    lcd.drawLine(67, 36, 82, 36, FILL_BLACK);
    // vertical
    lcd.drawLine(17, 36, 17, 41, FILL_BLACK);
    lcd.drawLine(32, 36, 32, 41, FILL_BLACK);
    lcd.drawLine(57, 36, 57, 45, FILL_BLACK);
    lcd.drawLine(72, 36, 72, 41, FILL_BLACK);
    
    // horizontal
    lcd.drawLine(7, 41, 27, 41, FILL_BLACK);
    lcd.drawLine(37, 41, 52, 41, FILL_BLACK);
    lcd.drawLine(62, 41, 77, 41, FILL_BLACK);
    // vertical
    lcd.drawLine(27, 41, 27, 45, FILL_BLACK);
    
    // drawing the goal
    for (int j = 2; j < 6; j++){
        lcd.clearPixel(83, j);
    }
    
}

/**
 *  @details - Creating lcd buffer for maze 8
 */
void Maze::mazeIndexEight(N5110 &lcd)
{
    // hard maze 3
    // maze index 8
    
    lcd.drawRect(1, 1, 82, 46, FILL_TRANSPARENT);
    
    // vertical
    lcd.drawLine(7, 1, 7, 11, FILL_BLACK);
    lcd.drawLine(32, 1, 32, 21, FILL_BLACK);
    lcd.drawLine(62, 1, 62, 21, FILL_BLACK);
    lcd.drawLine(67, 1, 67, 6, FILL_BLACK);
    lcd.drawLine(77, 1, 77, 6, FILL_BLACK);
    
    // horizontal
    lcd.drawLine(7, 6, 17, 6, FILL_BLACK);
    lcd.drawLine(22, 6, 27, 6, FILL_BLACK);
    lcd.drawLine(37, 6, 57, 6, FILL_BLACK);
    // vertical
    lcd.drawLine(22, 6, 22, 11, FILL_BLACK);
    lcd.drawLine(27, 6, 27, 21, FILL_BLACK);
    lcd.drawLine(57, 6, 57, 16, FILL_BLACK);
    lcd.drawLine(72, 6, 72, 11, FILL_BLACK);
    
    // horizontal
    lcd.drawLine(17, 11, 22, 11, FILL_BLACK);
    lcd.drawLine(32, 11, 37, 11, FILL_BLACK);
    lcd.drawLine(47, 11, 52, 11, FILL_BLACK);
    lcd.drawLine(62, 11, 77, 11, FILL_BLACK);
    // vertical
    lcd.drawLine(12, 11, 12, 21, FILL_BLACK);
    lcd.drawLine(42, 11, 42, 26, FILL_BLACK);
    lcd.drawLine(52, 11, 52, 21, FILL_BLACK);
    
    // horizontal
    lcd.drawLine(2, 16, 7, 16, FILL_BLACK);
    lcd.drawLine(12, 16, 27, 16, FILL_BLACK);
    lcd.drawLine(37, 16, 52, 16, FILL_BLACK);
    lcd.drawLine(57, 16, 62, 16, FILL_BLACK);
    lcd.drawLine(67, 16, 82, 16, FILL_BLACK);
    // vertical
    // NONE //
    
    // horizontal
    lcd.drawLine(7, 21, 12, 21, FILL_BLACK);
    lcd.drawLine(17, 21, 22, 21, FILL_BLACK);
    lcd.drawLine(27, 21, 37, 21, FILL_BLACK);
    lcd.drawLine(47, 21, 57, 21, FILL_BLACK);
    lcd.drawLine(62, 21, 77, 21, FILL_BLACK);
    // vertical
    lcd.drawLine(7, 21, 7, 31, FILL_BLACK);
    lcd.drawLine(17, 21, 17, 41, FILL_BLACK);
    lcd.drawLine(37, 21, 37, 31, FILL_BLACK);
    lcd.drawLine(67, 21, 67, 31, FILL_BLACK);
    
    // horizontal
    lcd.drawLine(22, 26, 32, 26, FILL_BLACK);
    lcd.drawLine(42, 26, 62, 26, FILL_BLACK);
    lcd.drawLine(72, 26, 77, 26, FILL_BLACK);
    // vertical
    lcd.drawLine(12, 26, 12, 36, FILL_BLACK);
    lcd.drawLine(22, 26, 22, 31, FILL_BLACK);
    lcd.drawLine(62, 26, 62, 36, FILL_BLACK);
    lcd.drawLine(77, 26, 77, 41, FILL_BLACK);
    
    // horizontal
    lcd.drawLine(22, 31, 57, 31, FILL_BLACK);
    lcd.drawLine(67, 31, 72, 31, FILL_BLACK);
    // vertical
    lcd.drawLine(52, 31, 52, 41, FILL_BLACK);
    
    // horizontal
    lcd.drawLine(2, 36, 12, 36, FILL_BLACK);
    lcd.drawLine(17, 36, 32, 36, FILL_BLACK);
    lcd.drawLine(37, 36, 47, 36, FILL_BLACK);
    lcd.drawLine(57, 36, 72, 36, FILL_BLACK);
    // vertical
    lcd.drawLine(32, 36, 32, 41, FILL_BLACK);
    lcd.drawLine(47, 36, 47, 46, FILL_BLACK);
    lcd.drawLine(57, 36, 57, 46, FILL_BLACK);
    lcd.drawLine(67, 36, 67, 41, FILL_BLACK);
    
    // horizontal
    lcd.drawLine(7, 41, 17, 41, FILL_BLACK);
    lcd.drawLine(22, 41, 42, 41, FILL_BLACK);
    lcd.drawLine(62, 41, 67, 41, FILL_BLACK);
    lcd.drawLine(72, 41, 77, 41, FILL_BLACK);
    // vertical
    lcd.drawLine(72, 41, 72, 46, FILL_BLACK);
    
    // drawing the goal
    for (int j = 2; j < 5; j++){
        lcd.clearPixel(82, j);
    }
    
}

/**
 *  @details - Creating lcd buffer for maze 9
 */
void Maze::mazeIndexNine(N5110 &lcd)
{
    // maze index 9
    // extreme maze
    
    lcd.drawRect(0, 0, 84, 48, FILL_TRANSPARENT);
    
    // cycle through all rows/colums and set pixels
    int y = 3;
    lcd.drawLine(35, y, 37, y, FILL_BLACK);
    lcd.drawLine(47, y, 51, y, FILL_BLACK);
    
    y++;    // line 4
    lcd.drawLine(8, y, 12, y, FILL_BLACK);
    lcd.drawLine(20, y, 24, y, FILL_BLACK);
    lcd.drawLine(33, y, 34, y, FILL_BLACK);
    lcd.drawLine(51, y, 64, y, FILL_BLACK);
    lcd.drawLine(68, y, 79, y, FILL_BLACK);
    
    y++;    // line 5
    lcd.drawLine(31, y, 32, y, FILL_BLACK);
    lcd.drawLine(53, y, 54, y, FILL_BLACK);
    lcd.setPixel(30, y);
    lcd.setPixel(47, y);
    
    y++;    // line 6
    lcd.setPixel(30, y);
    lcd.drawLine(39, y, 42, y, FILL_BLACK);
    lcd.setPixel(47, y);
    lcd.setPixel(55, y);
    
    y++;    // line 7
    lcd.drawLine(28, y, 29, y, FILL_BLACK);
    lcd.drawLine(36, y, 38, y, FILL_BLACK);
    lcd.drawLine(47, y, 49, y, FILL_BLACK);
    lcd.drawLine(56, y, 57, y, FILL_BLACK);
    
    y++;    // line 8
    lcd.drawLine(0, y, 8, y, FILL_BLACK);
    lcd.drawLine(12, y, 20, y, FILL_BLACK);
    lcd.setPixel(27, y);
    lcd.drawLine(34, y, 35, y, FILL_BLACK);
    lcd.drawLine(50, y, 51, y, FILL_BLACK);
    lcd.drawLine(58, y, 68, y, FILL_BLACK);
    lcd.drawLine(77, y, 83, y, FILL_BLACK);
    
    y++;    // line 9
    lcd.setPixel(26, y);
    lcd.drawLine(32, y, 33, y, FILL_BLACK);
    lcd.drawLine(52, y, 53, y, FILL_BLACK);
    lcd.setPixel(59, y);
    
    y++;    // line 10
    lcd.setPixel(26, y);
    lcd.setPixel(31, y);
    lcd.setPixel(53, y);
    lcd.setPixel(59, y);
    
    y++;    // line 11
    lcd.drawLine(24, y, 25, y, FILL_BLACK);
    lcd.setPixel(30, y);
    lcd.setPixel(52, y);
    lcd.setPixel(60, y);
    
    y++;    // line 12
    lcd.drawLine(4, y, 12, y, FILL_BLACK);
    lcd.drawLine(16, y, 20, y, FILL_BLACK);
    lcd.setPixel(29, y);
    lcd.drawLine(40, y, 45, y, FILL_BLACK);
    lcd.setPixel(51, y);
    lcd.setPixel(61, y);
    lcd.drawLine(66, y, 72, y, FILL_BLACK);
    lcd.drawLine(76, y, 79, y, FILL_BLACK);
    
    y++;    // line 13
    lcd.setPixel(24, y);
    lcd.setPixel(28, y);
    lcd.drawLine(37, y, 39, y, FILL_BLACK);
    lcd.drawLine(46, y, 48, y, FILL_BLACK);
    lcd.setPixel(50, y);
    lcd.setPixel(57, y);
    lcd.setPixel(61, y);
    
    y++;    // line 14
    lcd.setPixel(23, y);
    lcd.setPixel(28, y);
    lcd.setPixel(36, y);
    lcd.setPixel(49, y);
    lcd.setPixel(57, y);
    lcd.setPixel(62, y);
    
    y++;    // line 15
    lcd.setPixel(23, y);
    lcd.setPixel(27, y);
    lcd.setPixel(36, y);
    lcd.setPixel(50, y);
    lcd.setPixel(58, y);
    lcd.setPixel(62, y);
    
    y++;    // line 16
    lcd.drawLine(0, y, 8, y, FILL_BLACK);
    lcd.setPixel(22, y);
    lcd.setPixel(27, y);
    lcd.setPixel(37, y);
    lcd.drawLine(43, y, 45, y, FILL_BLACK);
    lcd.setPixel(51, y);
    lcd.setPixel(58, y);
    lcd.drawLine(63, y, 68, y, FILL_BLACK);
    lcd.drawLine(80, y, 83, y, FILL_BLACK);
    
    y++;    // line 17
    lcd.setPixel(22, y);
    lcd.setPixel(26, y);
    lcd.setPixel(38, y);
    lcd.drawLine(46, y, 47, y, FILL_BLACK);
    lcd.setPixel(52, y);
    lcd.setPixel(59, y);
    lcd.setPixel(63, y);
    
    y++;    // line 18
    lcd.setPixel(22, y);
    lcd.setPixel(26, y);
    lcd.setPixel(32, y);
    lcd.drawLine(37, y, 38, y, FILL_BLACK);
    lcd.setPixel(48, y);
    lcd.setPixel(53, y);
    lcd.setPixel(59, y);
    lcd.setPixel(63, y);
    
    y++;    // line 19
    lcd.setPixel(26, y);
    lcd.setPixel(32, y);
    lcd.setPixel(36, y);
    lcd.setPixel(39, y);
    lcd.setPixel(49, y);
    lcd.setPixel(53, y);
    lcd.setPixel(59, y);
    
    y++;    // line 20
    lcd.drawLine(4, y, 16, y, FILL_BLACK);
    lcd.setPixel(25, y);
    lcd.setPixel(32, y);
    lcd.setPixel(36, y);
    lcd.drawLine(40, y, 44, y, FILL_BLACK);
    lcd.setPixel(49, y);
    lcd.setPixel(53, y);
    
    y++;    // line 21
    lcd.setPixel(45, y);
    
    y++;    // line 22
    /// NO INDIVIDUAL PIXELS/LINES TO DRAW ///
    
    y++;    // line 23
    /// NO INDIVIDUAL PIXELS/LINES TO DRAW ///
    
    y++;    // line 24
    lcd.drawLine(0, y, 4, y, FILL_BLACK);
    lcd.drawLine(21, y, 31, y, FILL_BLACK);
    lcd.setPixel(39, y);
    lcd.drawLine(64, y, 72, y, FILL_BLACK);
    
    y++;    // line 25
    lcd.setPixel(39, y);
    
    y++;    // line 26
    lcd.setPixel(40, y);
    lcd.setPixel(45, y);
    
    y++;    // line 27
    lcd.setPixel(32, y);
    lcd.setPixel(36, y);
    lcd.drawLine(41, y, 44, y, FILL_BLACK);
    lcd.setPixel(49, y);
    
    y++;    // line 28
    lcd.drawLine(4, y, 12, y, FILL_BLACK);
    lcd.drawLine(16, y, 21, y, FILL_BLACK);
    lcd.setPixel(26, y);
    lcd.setPixel(32, y);
    lcd.setPixel(36, y);
    lcd.setPixel(49, y);
    lcd.setPixel(59, y);
    lcd.drawLine(68, y, 83, y, FILL_BLACK);
    
    y++;    // line 29
    lcd.setPixel(22, y);
    lcd.setPixel(26, y);
    lcd.setPixel(32, y);
    lcd.setPixel(37, y);
    lcd.setPixel(48, y);
    lcd.setPixel(59, y);
    lcd.setPixel(63, y);
    
    y++;    // line 30
    lcd.setPixel(22, y);
    lcd.setPixel(26, y);
    lcd.setPixel(33, y);
    lcd.drawLine(38, y, 39, y, FILL_BLACK);
    lcd.drawLine(46, y, 47, y, FILL_BLACK);
    lcd.setPixel(59, y);
    lcd.setPixel(63, y);
    
    y++;    // line 31
    lcd.setPixel(22, y);
    lcd.setPixel(27, y);
    lcd.setPixel(34, y);
    lcd.drawLine(40, y, 45, y, FILL_BLACK);
    lcd.setPixel(51, y);
    lcd.setPixel(58, y);
    lcd.setPixel(63, y);
    
    y++;    // line 32
    lcd.drawLine(12, y, 17, y, FILL_BLACK);
    lcd.setPixel(23, y);
    lcd.setPixel(27, y);
    lcd.setPixel(35, y);
    lcd.setPixel(50, y);
    lcd.setPixel(58, y);
    lcd.drawLine(62, y, 72, y, FILL_BLACK);
    
    y++;    // line 33
    lcd.setPixel(23, y);
    lcd.setPixel(28, y);
    lcd.setPixel(36, y);
    lcd.setPixel(49, y);
    lcd.setPixel(57, y);
    lcd.setPixel(62, y);
    
    y++;    // line 34
    lcd.setPixel(28, y);
    lcd.drawLine(37, y, 38, y, FILL_BLACK);
    lcd.drawLine(46, y, 48, y, FILL_BLACK);
    lcd.setPixel(57, y);
    lcd.setPixel(61, y);
    
    y++;    // line 35
    lcd.setPixel(29, y);
    lcd.drawLine(42, y, 45, y, FILL_BLACK);
    lcd.setPixel(56, y);
    lcd.setPixel(61, y);
    
    y++;    // line 36
    lcd.drawLine(0, y, 8, y, FILL_BLACK);
    lcd.drawLine(12, y, 25, y, FILL_BLACK);
    lcd.setPixel(30, y);
    lcd.setPixel(55, y);
    lcd.setPixel(60, y);
    lcd.drawLine(64, y, 76, y, FILL_BLACK);
    
    y++;    // line 37
    lcd.setPixel(26, y);
    lcd.setPixel(31, y);
    lcd.setPixel(54, y);
    lcd.setPixel(59, y);
    
    y++;    // line 38
    lcd.setPixel(26, y);
    lcd.drawLine(32, y, 33, y, FILL_BLACK);
    lcd.drawLine(52, y, 53, y, FILL_BLACK);
    lcd.setPixel(59, y);
    
    y++;    // line 39
    lcd.setPixel(27, y);
    lcd.drawLine(34, y, 35, y, FILL_BLACK);
    lcd.drawLine(50, y, 51, y, FILL_BLACK);
    lcd.setPixel(58, y);
    
    y++;    // line 40
    lcd.drawLine(4, y, 12, y, FILL_BLACK);
    lcd.drawLine(16, y, 20, y, FILL_BLACK);
    lcd.drawLine(28, y, 29, y, FILL_BLACK);
    lcd.drawLine(36, y, 38, y, FILL_BLACK);
    lcd.drawLine(47, y, 49, y, FILL_BLACK);
    lcd.drawLine(56, y, 68, y, FILL_BLACK);
    lcd.drawLine(72, y, 80, y, FILL_BLACK);
    
    y++;    // line 41
    lcd.setPixel(30, y);
    lcd.drawLine(39, y, 46, y, FILL_BLACK);
    lcd.setPixel(55, y);
    
    y++;    // line 42
    lcd.setPixel(32, y);
    lcd.drawLine(31, y, 31, y, FILL_BLACK);
    lcd.drawLine(53, y, 54, y, FILL_BLACK);
    
    y++;    // line 43
    lcd.drawLine(12, y, 16, y, FILL_BLACK);
    lcd.drawLine(33, y, 34, y, FILL_BLACK);
    lcd.drawLine(51, y, 52, y, FILL_BLACK);
    
    y++;    // line 44
    lcd.drawLine(35, y, 36, y, FILL_BLACK);
    lcd.drawLine(48, y, 50, y, FILL_BLACK);
    lcd.drawLine(60, y, 72, y, FILL_BLACK);
    
    /// NO OTHER NON-VERTICAL LINES ON 45 - 47 (END) ///
    
    int x = 4;  // column 4
    lcd.drawLine(x, 0, x, 4, FILL_BLACK);
    lcd.drawLine(x, 28, x, 32, FILL_BLACK);
    lcd.drawLine(x, 40, x, 43, FILL_BLACK);
    
    x += 4; // column 8
    lcd.drawLine(x, 20, x, 24, FILL_BLACK);
    lcd.drawLine(x, 32, x, 36, FILL_BLACK);
    lcd.drawLine(x, 44, x, 47, FILL_BLACK);
    
    x += 4; // column 12
    lcd.drawLine(x, 4, x, 20, FILL_BLACK);
    lcd.drawLine(x, 24, x, 43, FILL_BLACK);
    
    x += 4; // column 16
    lcd.drawLine(x, 0, x, 4, FILL_BLACK);
    lcd.drawLine(x, 12, x, 28, FILL_BLACK);
    
    x += 4; // column 20
    lcd.drawLine(x, 40, x, 47, FILL_BLACK);
    
    x++;    // column 21
    lcd.drawLine(x, 19, x, 28, FILL_BLACK);
    
    x += 3; // column 24
    lcd.drawLine(x, 4, x, 13, FILL_BLACK);
    lcd.drawLine(x, 34, x, 43, FILL_BLACK);
    
    x++;    // column 25
    lcd.drawLine(x, 20, x, 24, FILL_BLACK);
    
    x += 3; // column 28
    lcd.drawLine(x, 0, x, 2, FILL_BLACK);
    lcd.drawLine(x, 44, x, 47, FILL_BLACK);
    
    x += 3; // column 31
    lcd.drawLine(x, 21, x, 26, FILL_BLACK);
    
    x += 4; // column 35
    lcd.drawLine(x, 21, x, 26, FILL_BLACK);
    
    x += 7; // column 42
    lcd.drawLine(x, 0, x, 6, FILL_BLACK);
    lcd.drawLine(x, 31, x, 47, FILL_BLACK);
    
    x += 4; // column 46
    lcd.drawLine(x, 22, x, 25, FILL_BLACK);
    
    x++;    // column 47
    lcd.drawLine(x, 3, x, 7, FILL_BLACK);
    
    x += 3; // column 50
    lcd.drawLine(x, 21, x, 26, FILL_BLACK);
    
    x += 4; // column 54
    lcd.drawLine(x, 21, x, 26, FILL_BLACK);
    
    x += 6; // column 60
    lcd.drawLine(x, 20, x, 27, FILL_BLACK);
    lcd.drawLine(x, 44, x, 47, FILL_BLACK);
    
    x += 4; // column 64
    lcd.drawLine(x, 19, x, 28, FILL_BLACK);
    
    x += 4;
    lcd.drawLine(x, 16, x, 20, FILL_BLACK);
    
    x += 4; // column 72
    lcd.drawLine(x, 4, x, 24, FILL_BLACK);
    lcd.drawLine(x, 40, x, 44, FILL_BLACK);
    
    x += 4; // column 76
    lcd.drawLine(x, 12, x, 36, FILL_BLACK);
    lcd.drawLine(x, 43, x, 47, FILL_BLACK);
    
    x += 4; // column 80
    lcd.drawLine(x, 16, x, 24, FILL_BLACK);
    lcd.drawLine(x, 32, x, 44, FILL_BLACK);
    
    /// END OF EXTREME MAZE ///
}


