#include "Ball.h"

/**
 *  @details - constructor
 */
Ball::Ball()
{
    
}

/**
 *  @details - destructor
 */
Ball::~Ball()
{
    
}

/**
 * @details - Initiases the ball.
 */
void Ball::init(float x,     // x coordinate for centre
                float y,     // y coordinate for centre
                int radius,  // radius size
                bool colour) // type of ball
{
    // properties of ball are set with values passed down from engine
    _x = x;
    _y = y;
    _radius = radius;
    _colour = colour;
    
    // printf("INPUT: x = %i, y = %i, radius = %i \n", x, y, radius);
    // printf("DRAW FUNCTION: x = %f, y = %f, radius = %f \n", _x, _y, _radius);
}

/**
 *  @details - Updates position of the ball
 */
void Ball::update(Vector2D position)
{
    velocity = position;
    
    // smooths out small signal fluctuations from accelerometer
    // used by joystick output also but with neglible effect
    checkForInterference(velocity);
    
    // new coordinates for the centre of the ball
    _x += velocity.x;
    _y -= velocity.y;   // +ve y joystick motion => -ve ball motion
}

/**
 *  @details - Function draws the ball
 */
void Ball::draw(N5110 &lcd)
{
    // goes into main 'draw' function in engine
    // main draw function in engine then called by menu during 'playGame' function
    if (_colour){// true colour => outline
        lcd.drawCircle(_x, _y, _radius, FILL_TRANSPARENT);
    }
    else {      // false colour => solid
        lcd.drawCircle(_x, _y, _radius, FILL_BLACK);
    }
    
}

/**
 *  @details - Sets the velocity of the ball
 */
void Ball::setVelocity(Vector2D v)
{
    velocity.x = v.x;
    velocity.y = v.y;
}

/**
 *  @details - Sets the position of the ball
 */
void Ball::setPosition(Vector2D p)
{
    _x = p.x;
    _y = p.y;
}

/**
 *  @details - Returns a struct containing current ball velocity information
 */
Vector2D Ball::getVelocity()
{
    Vector2D _velocity = {velocity.x, velocity.y};
    
    return _velocity;
}

/**
 *  @details - Returns a struct containing current ball position information
 */
Vector2D Ball::getPosition()
{
    Vector2D p = {_x,_y};
    
    return p;
}

/**
 *  @details - Smooths out data from accelerometer and returns values in struct
 */
Vector2D Ball::checkForInterference(Vector2D velocity)
{
    // +ve x
    if ((velocity.x < 0.1f) && (velocity.x > 0.0f)){
        velocity.x = 0.0f;
    }
    // -ve x
    if ((velocity.x > -0.1f) && (velocity.x < 0.0f)){
        velocity.x = 0.0f;
    }
    
    // +ve y
    if ((velocity.y < 0.1f) && (velocity.y > 0.0f)){
        velocity.y = 0.0f;
    }
    // -ve y
    if ((velocity.y > -0.1f) && (velocity.y < 0.0f)){
        velocity.y = 0.0f;
    }
    
    return velocity;
}
