#include "QuadratureEncoder.h"

QuadratureEncoder::QuadratureEncoder(PinName pinA, PinName pinB): _channelA(pinA), _channelB(pinB)
{
    _ticks = 0;
    _channelB.rise(this, &QuadratureEncoder::_Brising);
    _channelB.fall(this, &QuadratureEncoder::_Bfalling);
}

int QuadratureEncoder::getTicks()
{
    return _ticks;
}

void QuadratureEncoder::reset()
{
    _ticks = 0;
}

void QuadratureEncoder::_Brising()
{
    if (_channelA.read()) {
        _ticks--;
    } else {
        _ticks++;
    }
}

void QuadratureEncoder::_Bfalling()
{
    if (_channelA.read()) {
        _ticks++;
    } else {
        _ticks--;
    }
}