/**
*       @file QuadratureEncodere.h
*       @brief this library allows the MCU to intepret the signal coming from a quadrature encoder.
*       @author Lupo Manes
*       @date 24/07/2017
*/
#ifndef _QUADRATUREENCODER_H_
#define _QUADRATUREENCODER_H_

#include "mbed.h"
/** QuadrtureEncoder class.
*   Used to interface with quadrature encoder.
*/ 
class QuadratureEncoder
{
public:
    /** Create QuadratureEncode instance
    *   @param pinA Pin to which is connected channel A of the encoder
    *   @param pinB Pin to which is connected channel Bof the encoder
    */
    QuadratureEncoder(PinName pinA, PinName pinB);
    
    /** Return the total number of pulses sent by the encoder.
    */
    int getTicks();
    /** Set the total number of ticks back to 0.
    */
    void reset();

private:
    void _Bfalling();
    void _Brising();
    InterruptIn _channelB;
    DigitalIn _channelA;
    int _ticks;
};

#endif