#ifndef Wall_H
#define Wall_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Column.h
@brief This library handles a rectangular type of obstacle.
*/

class Wall
{
private:

// Variables
    int _posX;
    int _posY;
    int _heigth;
    int _width;
    int _scenePosX;
    int _scenePosY;
    
public:

    /**
    * Class constructor
    */
    Wall();
    
    /**
    * Class destructor
    */
    ~Wall();
    
    /**
    * Getter for the the absolute X cohordinate
    */
    int getPosX();
    
    /**
    * Getter for the the absolute Y cohordinate
    */
    int getPosY();
    
    /**
    * Getter for the the heigth of the wall object
    */
    int getHeigth();
    
    /**
    * Getter for the the width of the wall object
    */
    int getWidth();
    
    /**
    * Getter for the the  X cohordinate relative to the screen
    */
    int getScenePosX();
    
    /**
    * Getter for the the  Y cohordinate relative to the screen
    */
    int getScenePosY();
    
    /** Setter for the the X cohordinate relative to the screen
    * 
    * @param x    X cohordinate relative to the screens
    * 
    */
    void setScenePosX(int x);
    
    /** Setter for the the Y cohordinate relative to the screen
    * 
    * @param y    Y cohordinate relative to the screens
    * 
    */
    void setScenePosY(int y);
    
    /** initialise the wall object
    *
    * @param x        Absolute X cohordinate
    * @param y        Absolute y cohordinate
    * @param heigth   Heigth of the wall object
    * @param width    Width of the wall object
    *
    */
    void init(int x,
              int y,
              int heigth,
              int width);
    
    /** Render the wall object on the screen
    *
    * @param lcd    Display used to render the wall
    *
    */    
    void draw(N5110 &lcd);
};
   
#endif