#ifndef Column_H
#define Column_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Column.h
@brief This library handles a circular type of obstacle.
*/
class Column
{
private:

// Variables
    int _posX;
    int _posY;
    int _radius;
    int _scenePosX;
    int _scenePosY;

public:
    
    /**
    * Class constructor
    */
    Column();
    
    /**
    * Class destructor
    */
    ~Column();

    /**
    * Getter for the the absolute X cohordinate
    */
    int getPosX();
    
    /**
    * Getter for the the absolute Y cohordinate
    */
    int getPosY();
    
    /**
    * Getter for the the radius of the column object
    */
    int getRadius();

    /**
    * Getter for the the  X cohordinate relative to the screen
    */
    int getScenePosX();
    
    /**
    * Getter for the the  Y cohordinate relative to the screen
    */
    int getScenePosY();
 
    /** Setter for the the X cohordinate relative to the screen
    * 
    * @param x    X cohordinate relative to the screens
    * 
    */
    void setScenePosX(int x);
    
    /** Setter for the the Y cohordinate relative to the screen
    * 
    * @param y    Y cohordinate relative to the screens
    * 
    */
    void setScenePosY(int y);

    /** initialise the column object
    *
    * @param x        Absolute X cohordinate
    * @param y        Absolute y cohordinate
    * @param radius   Radius of the column object
    *
    */
    void init(int x,
              int y,
              int radius);
    void draw(N5110 &lcd);
};

#endif