#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Camera.h"
#include "ActionRPGEngine.h"

/////////////// objects ///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
RPGengine engine;
///////////// prototypes ///////////////
void init();
///////////// functions ////////////////
int main()
{
    init();
    while (1) {
        lcd.clear();
        engine.readInput(pad);
        engine.update();
        engine.draw(lcd);
        engine.playerCollisionDetector(lcd);
        engine.draw(lcd);
        wait(0.25);
    }
}

void init()
{
    lcd.init();
    pad.init();
    engine.init(6, 0, 10, 13, 1, N, 0, 0, 48, 84, 84, 80, 150);
}
