/**
@file main.h
@brief Header file containing functions prototypes, defines and and global variables.
@brief Shows examples of creating Doxygen documentation.
@brief Revision 1.0.
@author Chenyu Li(John Lee) SID: 200985958.
@data May 2016
*/

#ifndef MAIN_H
#define MAIN_H

#include "mbed.h"

#include "N5110.h" ///head file for N5110 in order to use the code set in N5110.
#include <stdio.h> ///head file for random number.
#include <stdlib.h> ///head file for random number.
#define DIRECTION_TOLERANCE 0.05 /// change this to alter tolerance of joystick direction 


///VCC,SCE,RST,D/C,MOSI,SCLK,LED
/**
@namespace N5110_lcd
@brief lcd display
*/
N5110 lcd(PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3);
/// Can also power (VCC) directly from VOUT (3.3 V) -
/// Can give better performance due to current limitation from GPIO pin

/**
@namespace buzzer
@brief buzzer connection
*/
PwmOut buzzer(PTA2); ///set PwmOut out as the buzzer
/**
@namespace button
@brief button connection
*/
InterruptIn button(PTB18);/// set button as an interrupt in
/**
@namespace buttonjoystick
@brief buttonjoystick connection
*/
DigitalIn buttonjoystick(PTB11);/// connections for joystick
/**
@namespace xPot
@brief joystick movement in x-axis.
*/
AnalogIn xPot(PTB3);/// connections for joystick
/**
@namespace yPot
@brief joystick movement in y-axis.
*/
AnalogIn yPot(PTB2);/// connections for joystick

Ticker pollJoystick;/// timer to regularly read the joystick
Ticker bullet;/// set 'bullet' as a ticker (not used currently)
Ticker enermy;/// set 'enermy' as a ticker (not used currently)

Serial serial(USBTX,USBRX);/// Serial for debug
/**
create enumerated type (0,1,2,3 etc. for direction)
could be extended for diagonals etc.
*/
enum DirectionName {
    UP,
    DOWN,
    LEFT,
    RIGHT,
    CENTRE,
    UNKNOWN
};

typedef struct JoyStick Joystick;/// struct for Joystick

struct JoyStick {
    float x;    /// current x value
    float x0;   /// 'centred' x value
    float y;    /// current y value
    float y0;   /// 'centred' y value
    int buttonjoystick; /// button state (assume pull-down used, so 1 = pressed, 0 = unpressed)
    DirectionName direction;  /// current direction
};

Joystick joystick;/// create struct variable
int printFlag = 0;/*!< set the printFlag to 0*/

int enermyFlag = 0;/*!< set the enermyFlag to 0*/
int bulletFlag = 0;/*!< set the bulletFlag to 0*/

// function prototypes
/**
initialize the position of the joystick.
*/
void calibrateJoystick();
/**
read the current joystick value.
*/
void updateJoystick();

void createbullet();
void createenermy();
/**
return back the button_isr value.
*/
void button_isr();

int status =1;/*!< set the status to 0*/

volatile int g_button_flag = 0;/// set the original value of "g_button_flag" equals to 0.

///set "wall", "hit", "bullethit" as a boolean value. 
bool wall = false;
bool hit = false;
bool bullethit = false;

#endif
