#include "mbed.h"
#include "N5110.h"
#define DIRECTION_TOLERANCE 0.05// change this to alter tolerance of joystick direction

DigitalIn button(PTB11);// connections for joystick
AnalogIn xPot(PTB2);
AnalogIn yPot(PTB3);
Ticker pollJoystick;// timer to regularly read the joystick
// Serial for debug
Serial serial(USBTX,USBRX);// Serial for debug
// create enumerated type (0,1,2,3 etc. for direction)
// could be extended for diagonals etc.
enum DirectionName {
    UP,
    DOWN,
    LEFT,
    RIGHT,
    CENTRE,
    UNKNOWN
};
typedef struct JoyStick Joystick;// struct for Joystick
struct JoyStick {
    float x;    // current x value
    float x0;   // 'centred' x value
    float y;    // current y value
    float y0;   // 'centred' y value
    int button; // button state (assume pull-down used, so 1 = pressed, 0 = unpressed)
    DirectionName direction;  // current direction
};
Joystick joystick;// create struct variable
int printFlag = 0;

//        VCC,    SCE,    RST,    D/C,    MOSI,   SCLK,   LED
N5110 lcd( PTE26,     PTA0,   PTC4,   PTD0,   PTD2,   PTD1,   PTC3);
DigitalIn buttonA(PTB18);
int ni = 84;
int x = 0;
int x1 = 0;
int x2 = 0;
int x3 = 0;
int x4 = 0;
int x5 = 0;
int x6 = 0;
int x7 = 0;
int x8 = 0;
int x9 = 0;
int x10 = 0;
int x11 = 0;
int x12 = 0;
int x13 = 0;
int x14 = 0;
int x15 = 0;
int x16 = 0;
int x17 = 0;
int x18 = 0;
int x19 = 0;
int x20 = 0;
int x21 = 0;
int x22 = 0;
int x23 = 0;
int x24 = 0;
int y = 0;
int y1 = 1;
int y2 = 2;
int y3 = 3;
int y4 = 4;
int y5 = 5;
int y6 = 6;
int y7 = 7;
int y8 = 8;
int y9 = 9;
int y10 = 10;
int y11 = 11;
int y12 = 12;
int y13 = 13;
int y14 = 14;
int y15 = 15;
int y16 = 16;
int y17 = 17;
int y18 = 18;
int y19 = 19;
int y20 = 20;
int y21 = 21;
int y22 = 22;
int y23 = 23;
int y24 = 24;
int change = 1;
int n[84][48];
int array[48][84];
int nj = 48;
int cells[84][48];
int Score = 0;
int randX;
int randY;
char str[64];
int pause=0;

void Menu();  //Start screen
void Welcomescreen(); //Prints Welcome to snake on screen
void clearCells(); //Clears Screen
void checkerBoard(); //produces checkers before game begins
void DrawArray(); //Sets the pixel depending on whether 0 or higher than 1
void ClearArray();//Checks over each individual pixel and if its 0 it will clear
void GenerateFood();//Generates food at random places
void MakeSnake(); //sets the pixels for the snake
void SnakeGame(); // Game Rules
void MoveSnake(); //moving the snake using the joy stick
void calibrateJoystick();
void updateJoystick();
void SnakeGrowing();
void GameOver();//Game ends
void drawLine();
void calibrateJoystick();
void updateJoystick();

int main()
{
    buttonA.mode(PullDown);
    calibrateJoystick();  // get centred values of joystick
    pollJoystick.attach(&updateJoystick,1.0/10.0);  // read joystick 10 times per second
    calibrateJoystick();
    updateJoystick();
    lcd.init();
    Welcomescreen();
    lcd.clear();
    GenerateFood();
    DrawArray();
    Menu();
    while(1) {

        MakeSnake();
        ClearArray();
        DrawArray();
    }
}
//menu screen
void Menu()
{
    // first need to initialise display

    lcd.clear();
    lcd.printString("Press Button",6,1);
    lcd.printString("To",35,3);
    lcd.printString("START",27,5);
    wait(0.3);

    while(1) {
        if (buttonA==1) {
            lcd.clear();
            checkerBoard();
            wait(0.5);
            lcd.clear();


            while(1) {

                wait(0.005);
                SnakeGame();
                if (buttonA==1) {
                    pause=0;
                    Menu();
                }

                if (button==1) {
                    pause=0;
                    lcd.clear();
                    sprintf(str,"%d",Score);
                    lcd.printString(str,37,2);
                    wait(1);
                }
            }
        }
    }
}

void Welcomescreen()   // Display welcome screen
{
    lcd.printString("Welcome",20,1); // display Welcome
    wait(0.1);
    lcd.printString("To",35,3); // display To
    wait(0.1);
    lcd.printString("SNAKE",27,5);  // display Snake
    wait(1);
}

void checkerBoard()
{
//
    for (int i = 0; i < ni ; i+=2) {
        for (int j = 0; j < nj ; j+=2) {
            lcd.setPixel(i,j);
        }
    }
    lcd.refresh();
}

void DrawArray()
{
    for(int x=0; x<84; x++) {
        for (int y=0; y<48; y++) {
            if(array[y][x]>=1) {
                lcd.setPixel(x,y);
            } else {
                lcd.clearPixel(x,y);
            }
        }
    }
    lcd.refresh();
}

void ClearArray()
{
    for(int x=0; x<84; x++) {
        for(int y=0; y<48; y++) {
            if (array[y][x]==0) {
                lcd.clearPixel(x,y);
            } else {
                lcd.setPixel(x,y);
            }
        }
    }
    lcd.refresh();
}

void calibrateJoystick()// read default positions of the joystick to calibrate later readings
{
    button.mode(PullDown);  // must not move during calibration
    joystick.x0 = xPot;  // initial positions in the range 0.0 to 1.0 (0.5 if centred exactly)
    joystick.y0 = yPot;
}
void updateJoystick()
{
    joystick.x = xPot - joystick.x0;// read current joystick values relative to calibrated values (in range -0.5 to 0.5, 0.0 is centred)
    joystick.y = yPot - joystick.y0;// read button state
    joystick.button = button; // calculate direction depending on x,y values
    if ( fabs(joystick.y) < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) { // tolerance allows a little lee-way in case joystick not exactly in the stated direction
        joystick.direction = CENTRE;
    } else if ( joystick.y > DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = LEFT;
    } else if ( joystick.y < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = RIGHT;
    } else if ( joystick.x > DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = DOWN;
    } else if ( joystick.x < DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = UP;
    } else {
        joystick.direction = UNKNOWN;
    }
    printFlag = 1;// set flag for printing
}

void GenerateFood()
{
    randX = rand() %83; //make random number between 0 - 84
    randY = rand() %47; //make random number between 0 - 48
    while(array[randY][randX]) {
        randX= rand() %83;
        randY= rand() %47;
    }
    array[randY][randX]= 5;
}
void MakeSnake()
{
    array[y+36][x+5]= 1;
    array[y1+36][x1+5]= 1;
    array[y2+36][x2+5]= 1;
    array[y3+36][x3+5]= 1;
    array[y4+36][x4+5]= 1;
    array[y5+36][x5+5]= 0;
    array[y6+36][x6+5]= 0;
    array[y7+36][x7+5]= 0;
    array[y8+36][x7+5]= 0;
    array[y9+36][x9+5]= 0;
    array[y10+36][x10+5]= 0;
    array[y11+36][x11+5]= 0;
    array[y12+36][x12+5]= 0;
    array[y13+36][x13+5]= 0;
    array[y14+36][x14+5]= 0;
    array[y15+36][x15+5]= 0;
    array[y16+36][x16+5]= 0;
    array[y17+36][x17+5]= 0;
    array[y18+36][x18+5]= 0;
    array[y19+36][x19+5]= 0;
    array[y20+36][x20+5]= 0;
    array[y21+36][x21+5]= 0;
    array[y22+36][x22+5]= 0;
    array[y23+36][x23+5]= 0;
    array[y24+36][x24+5]= 0;
}

void SnakeGame()
{
    MakeSnake();
    ClearArray();
    DrawArray();
    SnakeGrowing();
    if(pause==0) {
        MoveSnake();
    }
    if(y+36==randY && x+5==randX) {
        GenerateFood();

        Score= Score+10;
    }

}
void MoveSnake()
{
    array[y+36][x+5]= 0;

    array[y1+36][x1+5]= 0;

    array[y2+36][x2+5]= 0;

    array[y3+36][x3+5]= 0;

    array[y4+36][x4+5]= 0;

    array[y5+36][x5+5]= 0;

    array[y6+36][x6+5]= 0;

    array[y7+36][x7+5]= 0;

    array[y8+36][x8+5]= 0;

    array[y9+36][x9+5]= 0;

    array[y10+36][x10+5]= 0;

    array[y11+36][x11+5]= 0;

    array[y12+36][x12+5]= 0;

    array[y13+36][x13+5]= 0;

    array[y14+36][x14+5]= 0;

    array[y15+36][x15+5]= 0;

    array[y16+36][x16+5]= 0;

    array[y17+36][x17+5]= 0;

    array[y18+36][x18+5]= 0;

    array[y19+36][x19+5]= 0;

    array[y20+36][x20+5]= 0;

    array[y21+36][x21+5]= 0;

    array[y22+36][x22+5]= 0;

    array[y23+36][x23+5]= 0;

    array[y24+36][x24+5]= 0;

    x24=x23;
    y24=y23;
    x23=x22;
    y23=y22;
    x22=x21;
    y22=y21;
    x21=x20;
    y21=y20;
    x20=x19;
    y20=y19;
    x19=x18;
    y19=y18;
    x18=x17;
    y18=y17;
    x17=x16;
    y17=y16;
    x16=x15;
    y16=y15;
    x15=x14;
    y15=y14;
    x14=x13;
    y14=y13;
    x13=x12;
    y13=y12;
    x12=x11;
    y12=y11;
    x11=x10;
    y11=y10;
    x10=x9;
    y10=y9;
    x9=x8;
    y9=y8;
    x8=x7;
    y8=y7;
    x7=x6;
    y7=y6;
    x6=x5;
    y6=y5;
    x5=x4;
    y5=y4;
    x4=x3;
    y4=y3;
    x3=x2;
    y3=y2;
    x2=x1;
    y2=y1;
    x1 = x;
    y1 = y;
    if (joystick.direction == CENTRE) {
        //lcd.printString("CENTRE",20,1); // display welcome
        wait(0.05);
    } else if (joystick.direction == UP) {
        //lcd.printString("UP",20,1); // display welcome
        wait(0.05);
        change = 1;
    } else if (joystick.direction == DOWN) {
        //lcd.printString("DOWN",20,1); // display welcome
        wait(0.05);
        change = 2;
    } else if (joystick.direction == LEFT) {
        //lcd.printString("LEFT",20,1); // display welcome
        wait(0.05);
        change = 3;
    } else if (joystick.direction == RIGHT) {
        //lcd.printString("RIGHT",20,1); // display welcome
        wait(0.05);
        change = 4;
    }
    if (change == 1) {
        y--;
    } else if (change == 2) {
        y++;
    } else if (change == 3) {
        x--;
    } else if (change == 4) {
        x++;
    }

}
void SnakeGrowing()
{


    if(Score>=10) {
        array[y+36][x+5]= 1;

        array[y1+36][x1+5]= 1;

        array[y2+36][x2+5]= 1;

        array[y3+36][x3+5]= 1;

        array[y4+36][x4+5]= 1;

        array[y5+36][x5+5]= 1;

        array[y6+36][x6+5]= 1;

    }


    if(Score>=20) {
        array[y+36][x+5]= 1;

        array[y1+36][x1+5]= 1;

        array[y2+36][x2+5]= 1;

        array[y3+36][x3+5]= 1;

        array[y4+36][x4+5]= 1;

        array[y5+36][x5+5]= 1;

        array[y6+36][x6+5]= 1;

        array[y7+36][x7+5]= 1;

        array[y8+36][x8+5]= 1;
    }
    if(Score>=30) {
        array[y+36][x+5]= 1;

        array[y1+36][x1+5]= 1;

        array[y2+36][x2+5]= 1;

        array[y3+36][x3+5]= 1;

        array[y4+36][x4+5]= 1;

        array[y5+36][x5+5]= 1;

        array[y6+36][x6+5]= 1;

        array[y7+36][x7+5]= 1;

        array[y8+36][x8+5]= 1;

        array[y9+36][x9+5]= 1;

        array[y10+36][x10+5]= 1;

    }
    if(Score>=40) {
        array[y+36][x+5]= 1;

        array[y1+36][x1+5]= 1;

        array[y2+36][x2+5]= 1;

        array[y3+36][x3+5]= 1;

        array[y4+36][x4+5]= 1;

        array[y5+36][x5+5]= 1;

        array[y6+36][x6+5]= 1;

        array[y7+36][x7+5]= 1;

        array[y8+36][x8+5]= 1;

        array[y9+36][x9+5]= 1;

        array[y10+36][x10+5]= 1;

        array[y11+36][x11+5]= 1;

        array[y12+36][x12+5]= 1;

    }
    if(Score>=50) {
        array[y+36][x+5]= 1;

        array[y1+36][x1+5]= 1;

        array[y2+36][x2+5]= 1;

        array[y3+36][x3+5]= 1;

        array[y4+36][x4+5]= 1;

        array[y5+36][x5+5]= 1;

        array[y6+36][x6+5]= 1;

        array[y7+36][x7+5]= 1;

        array[y8+36][x8+5]= 1;

        array[y9+36][x9+5]= 1;

        array[y10+36][x10+5]= 1;

        array[y11+36][x11+5]= 1;

        array[y12+36][x12+5]= 1;

        array[y13+36][x13+5]= 1;

        array[y14+36][x14+5]= 1;

    }
    if(Score>=60) {
        array[y+36][x+5]= 1;

        array[y1+36][x1+5]= 1;

        array[y2+36][x2+5]= 1;

        array[y3+36][x3+5]= 1;

        array[y4+36][x4+5]= 1;

        array[y5+36][x5+5]= 1;

        array[y6+36][x6+5]= 1;

        array[y7+36][x7+5]= 1;

        array[y8+36][x8+5]= 1;

        array[y9+36][x9+5]= 1;

        array[y10+36][x10+5]= 1;

        array[y11+36][x11+5]= 1;

        array[y12+36][x12+5]= 1;

        array[y13+36][x13+5]= 1;

        array[y14+36][x14+5]= 1;

        array[y15+36][x15+5]= 1;

        array[y16+36][x16+5]= 1;

    }
    if(Score>=70) {
        array[y+36][x+5]= 1;

        array[y1+36][x1+5]= 1;

        array[y2+36][x2+5]= 1;

        array[y3+36][x3+5]= 1;

        array[y4+36][x4+5]= 1;

        array[y5+36][x5+5]= 1;

        array[y6+36][x6+5]= 1;

        array[y7+36][x7+5]= 1;

        array[y8+36][x8+5]= 1;

        array[y9+36][x9+5]= 1;

        array[y10+36][x10+5]= 1;

        array[y11+36][x11+5]= 1;

        array[y12+36][x12+5]= 1;

        array[y13+36][x13+5]= 1;

        array[y14+36][x14+5]= 1;

        array[y15+36][x15+5]= 1;

        array[y16+36][x16+5]= 1;

        array[y17+36][x17+5]= 1;

        array[y18+36][x18+5]= 1;

    }
    if(Score>=80) {
        array[y+36][x+5]= 1;

        array[y1+36][x1+5]= 1;

        array[y2+36][x2+5]= 1;

        array[y3+36][x3+5]= 1;

        array[y4+36][x4+5]= 1;

        array[y5+36][x5+5]= 1;

        array[y6+36][x6+5]= 1;

        array[y7+36][x7+5]= 1;

        array[y8+36][x8+5]= 1;

        array[y9+36][x9+5]= 1;

        array[y10+36][x10+5]= 1;

        array[y11+36][x11+5]= 1;

        array[y12+36][x12+5]= 1;

        array[y13+36][x13+5]= 1;

        array[y14+36][x14+5]= 1;

        array[y15+36][x15+5]= 1;

        array[y16+36][x16+5]= 1;

        array[y17+36][x17+5]= 1;

        array[y18+36][x18+5]= 1;

        array[y19+36][x19+5]= 1;

        array[y20+36][x20+5]= 1;

    }
    if(Score>=90) {
        array[y+36][x+5]= 1;

        array[y1+36][x1+5]= 1;

        array[y2+36][x2+5]= 1;

        array[y3+36][x3+5]= 1;

        array[y4+36][x4+5]= 1;

        array[y5+36][x5+5]= 1;

        array[y6+36][x6+5]= 1;

        array[y7+36][x7+5]= 1;

        array[y8+36][x8+5]= 1;

        array[y9+36][x9+5]= 1;

        array[y10+36][x10+5]= 1;

        array[y11+36][x11+5]= 1;

        array[y12+36][x12+5]= 1;

        array[y13+36][x13+5]= 1;

        array[y14+36][x14+5]= 1;

        array[y15+36][x15+5]= 1;

        array[y16+36][x16+5]= 1;

        array[y17+36][x17+5]= 1;

        array[y18+36][x18+5]= 1;

        array[y19+36][x19+5]= 1;

        array[y20+36][x20+5]= 1;

        array[y21+36][x21+5]= 1;

        array[y22+36][x22+5]= 1;

    }
    if(Score>=100) {
        array[y+36][x+5]= 1;

        array[y1+36][x1+5]= 1;

        array[y2+36][x2+5]= 1;

        array[y3+36][x3+5]= 1;

        array[y4+36][x4+5]= 1;

        array[y5+36][x5+5]= 1;

        array[y6+36][x6+5]= 1;

        array[y7+36][x7+5]= 1;

        array[y8+36][x8+5]= 1;

        array[y9+36][x9+5]= 1;

        array[y10+36][x10+5]= 1;

        array[y11+36][x11+5]= 1;

        array[y12+36][x12+5]= 1;

        array[y13+36][x13+5]= 1;

        array[y14+36][x14+5]= 1;

        array[y15+36][x15+5]= 1;

        array[y16+36][x16+5]= 1;

        array[y17+36][x17+5]= 1;

        array[y18+36][x18+5]= 1;

        array[y19+36][x19+5]= 1;

        array[y20+36][x20+5]= 1;

        array[y21+36][x21+5]= 1;

        array[y22+36][x22+5]= 1;

        array[y23+36][x23+5]= 1;

        array[y24+36][x24+5]= 1;

    }
    DrawArray();



}


/*void GameOver()
{

    if (button==1) {

        lcd.clear();

        lcd.printString("Welcome",20,1); // display welcome
        //wait(0.1);
        lcd.printString("To",35,3); // display To the game
        //wait(0.1);
        lcd.printString("SNAKE",27,5);  // display of life
        //wait(1);
    }
}
*/