/**
@file Ball.h
@brief Header file containing functions for the ball.

*/

#ifndef BALL_H
#define PADDLE_H

#include "mbed.h"
#include "N5110.h"

/**
@brief This library has been made to allow the ball to update, check its position. etc This will make the coding later on in the main file a bit easier to manipulate.
@brief Revision 1.0
@author Jefferson Sanchez
@date  April 2016
 **/

class ball
{
    /**  Ball will give me the integers for x1,y1,xi position, y1 position .
    */
    int x, y;
    int x_Pos_state, y_Pos_state;
public:
    /**  Ball will give me the integers for x1,y1,x1 position, y1 position .
      * @param pin connected to PTB3 in a Digital Input
      * @param Pin Connected to PTB2 in a Digital Input
      * @param Pins connected to +5v and GND to be able to obtain an integer value.
      */
    ball(int x1, int y1, int x1_Pos_state, int y1_Pos_state) : x(x1), y(y1), x_Pos_state(x1_Pos_state), y_Pos_state(y1_Pos_state) {}

    /**  Switches a pixel on in a particular coordinate in the X axis.
       *
       *     ball.setX(41);
       */
    void setX(int value);
    /**  Switches a pixel on in a particular coordinate in the Y axis.
     *
     *     ball.setY(23);
     *
     */
    void setY(int value);
    /** Switches a pixel on in a particular coordinate in the X axis.
    *
    *     ball.setY(23);
    *
    */
    int lookforX();
    /**
    *@param Allows me to check to see what pixels are on in the Y coordinate.
    @returns y value.
    */
    int lookforY();
    /**
       *@param  Checks the position state on  the X coordinate.
       *@returns x position state.
          */
    int lookforPos_stateX();
    /**  Checks the position state on  the Y coordinate.
     @returns y position state.
     */
    int lookforPos_stateY();
    /**  Checks the Collisions state on  the X and Y  coordinates.
    */

    void BallcollisionState(int xPos_state, int yPos_state);
    /** Diameter of the ball.
        */
    void dbal(N5110 &display);
    /** States the clearing of pixels for the ball as it moves
    */
    void clear_dbal(N5110 &display);
    /** This is used to refresh the position of the ball.
     */
    void Refresh_pos();

};

#endif
