
/**
@file Paddle.h
@brief Header file containing functions.
*/
/**Identifications for the paddle library.
*/
#ifndef PADDLE_H
#define PADDLE_H

#include "mbed.h"
#include "N5110.h"

/**
@brief This library has been made to allow the paddle to update, check its position .etc This will make the coding later on in the main file a bit easier to manipulate.
@brief Revision 1.0
@author Jefferson Sanchez
@date  April 2016
 **/

// the class is used to store a type of variable in this case the variable is the “paddle"
class Paddle
{
    int x1, x2, y1, y2;// the integers are x and y
public:
    /** The following show the connections to the K64F
        *
        * @param pin connected to PTB3 in a Digital Input
        * @param Pin Connected to PTB2 in a Digital Input
        * @param Pin connected to +5v and GND to be able to obtain a interger value.
        *
        */
    Paddle(int x_1, int x_2, int y_1, int y_2) : x1(x_1), x2(x_2), y1(y_1), y2(y_2) {}
 /** Checks to see what pixels are on in the X coordinate for player 1 and returns a value for X1.
    */
    int lookforX1();
   /** Allows to check to see what pixels are on in the X coordinate for player 2 and returns a value for X2.
    */
    int lookforX2();
    /** Checks to see what pixels are on in the Y coordinate for player 1 and returns a value for Y1 .
    */
    int lookforY1();
     /** Check to see what pixels are on in the Y coordinate for player 2 and returns a value for Y2.
    */
    int lookforY2();
   /**  Once the coordinates have been obtained it will display them on the lcd.
     *   for(int i = y1; i <= y2; i++)
    * {
    *    display.setPixel(x1, i);
    *   display.setPixel(x2, i);
    * }

    display.refresh();
    }
    */
    void YPaddle(N5110 &display);
    /**  Once the coordinates have been obtained it will update the display when the paddle moves.
    */
    void Moving_Paddle(N5110 &display);
    /** This function allow me to refresh the position of Player 1 */
    void Refresh_pos(AnalogIn &p1);
    
};

#endif
