
/**
@file main.cpp
@brief Program implementation
@author Vivien Pizzini
@date May 2015

*/

#include "mbed.h"
#include "MMA8452.h"
#include "N5110.h"
#include "PowerControl.h"
#define PI 3.14159265    




MMA8452 mma8452(p28,p27); /*!< Data and clock line for sensor-SDA,SCL */ 
N5110 lcd(p7,p8,p9,p10,p11,p13,p26);
Serial serial(USBTX,USBRX);/*!< Serial ports for USB */


/**
@namespace counter
@brief counter to count the seconds
*/
Timer counter; 



void intro();
void sleepF(); 
void slopeOptions();
void spiritOptions();
void spiritOptionsxy();
void spiritBoth();
void spiritLevelx();
void spiritLevely();
void percentage();
void stopwatch();
void coordinates();
void buttonPressed();





InterruptIn button1(p16); /*!< Create object connected to pin 16*/
InterruptIn button2(p17); /*!< Create object connected to pin 17*/
InterruptIn button3(p15); /*!< Create object connected to pin 15*/



/**
@brief Integer variables, will use as flag to tell us when interrupt occurs
*/

int buttonFlag1 = 0;  
int buttonFlag2 = 0; 
int buttonFlag3 = 0;  



/**
@brief ISR
@details after 200 ms, sets the flag and resets the timer
*/

void buttonPressed1(){
    if(counter.read_ms()>200) 
buttonFlag1 = 1 ;   
counter.reset();
}
void buttonPressed2(){
    if(counter.read_ms()>200)
buttonFlag2 = 1 ;    
counter.reset();
}
void buttonPressed3(){
    if(counter.read_ms()>200)
buttonFlag3 = 1 ;   
counter.reset();
}




int main()       /*!< Main function*/
{
    
/**
@brief     Initialise display and sensor
@details   We tell InterruptIn object to generate interrupt when rising edge occurs in the pin
*/
    lcd.init();   
    mma8452.init();       /*!<sensor, 100 Hz update rate, ±4g scale */
      
button1.rise(&buttonPressed1); 
button2.rise(&buttonPressed2); 
button3.rise(&buttonPressed3); 


    counter.start();      /*!< Counter starts*/
    intro();              /*!< Call of intro function*/
}









/**   
    @namespace intro
    @brief     First menu
    @details   Prints the first three options on display 
*/
void intro()
{

lcd.init();

    while(1) {

/**   
    @brief   Prints menu on display
    @details Each option in different line of display
*/
        
        
        lcd.printString("1.Sleep",1,1);              /*!< Prints Sleep option                */
        lcd.printString("2.Slope menu",1,2);         /*!< Prints Slope menu option           */
        lcd.printString("3.Stopwatch ",1,3);         /*!< Prints Stopwatch option            */
        
        
 
/**   
   @brief Depending on button pressed, according function is called
*/


        if (buttonFlag1==1) {  /*!< If buttonFlag1=1, first button has been pressed    */
             buttonFlag1=0;    /*!< Flag is reset to 0                                 */
            lcd.clear();       /*!< Clear display                                      */
            sleepF();          /*!< Call of related function                           */
        }
        if (buttonFlag2==1) {  /*!< If buttonFlag2=1, second button has been pressed   */
             buttonFlag2=0;    /*!< Flag is reset to 0                                 */
            lcd.clear();       /*!< Clear display                                      */
            slopeOptions();    /*!< Call of related function                           */
        }
        if (buttonFlag3==1) {  /*!< If buttonFlag3=1, third button has been pressed    */
             buttonFlag3=0;    /*!< Flag is reset to 0                                 */
            lcd.clear();       /*!< Clear display                                      */
            stopwatch();       /*!< Call of related function                           */
            }}}





       
/**   
 @namespace sleepF
 @brief     Sleep feature
 @details   Puts the mbed in Sleep mode and turns off lcd
 @details   To go back buttons 3 is pressed  
*/      

void sleepF(){
    while(1){
        lcd.turnOff();           /*!< Lcd turned off         */
        Sleep();                 /*!< Mbed in sleep mode     */
        if(buttonFlag3==1){      /*!< Button 1 is pressed    */
            buttonFlag1=0;       /*!< Resets flag            */
            break;               /*!< Break while loop       */
    }}
    }








/**   
    @namespace stopwatch
    @brief     Stopwatch feature
    @brief     Third option in initial menu
    @details   Prints a timer which can be reset by pressing a button
    @details   Can also print the value below the timer without having to reset
*/

void stopwatch()
{


    while(1) {
        
/**   
    @brief    Prints strings on bottom of display
    @details  Options can be triggered by pressing a button
    @details  First button resets timer, second button saves timer, third button goes back to menu
*/

        lcd.printString("Butt1 to reset",0,4);    /*!< Prints Reset option    */
        lcd.printString("Butt2 to save",0,5);     /*!< Prints Save option     */



/**   
    @brief    Set and display timer
*/


        time_t seconds = time(NULL);                                       /*!< Get current time   */

        printf("Time as seconds since January 1, 1970 = %d\n", seconds);   /*!< Print over serial  */

        printf("%s", ctime(&seconds));                                     /*!< Print over serial  */
        
/**   
    @brief    Set buffer
*/
        char buffer[14];                                                   /*!< Characters in buffer = 14   */
        strftime(buffer, 14, "%H:%M:%S ", localtime(&seconds));            /*!< Set time in buffer          */
        lcd.printString(buffer,0,1);                                       /*!< Print buffer                */
        
        
        
/**   
   @brief     Depending on button pressed, according function is called
*/    

        if (buttonFlag1==1) {       /*!< If buttonFlag1=1, first button has been pressed   */
         buttonFlag1=0;             /*!< Flag is reset to 0                                */
            set_time(0);            /*!< Sets time to 0                                    */
        }

        if ( buttonFlag2==1) {      /*!< If buttonFlag2=1, second button has been pressed  */
          buttonFlag2=0;            /*!< Flag is reset to 0                                */
lcd.printString(buffer,0,2);        /*!< Prints time to buffer                             */

        }
         if ( buttonFlag3==1) {     /*!< If buttonFlag3=1, third button has been pressed    */
          buttonFlag3=0;            /*!< Flag is reset to 0                                 */
          lcd.clear();              /*!< Clear display                                      */
          intro();                  /*!< Go back to initial menu                            */
    }}}








/**   
    @namespace slopeOptions
    @brief prints slope options on display
    @details each option in different line of display
*/

void slopeOptions(){
    
    while(1){
      lcd.printString("1.Percentages",1,1);        /*!< Prints Percentages option    */
      lcd.printString("2.Spirit level",1,2);       /*!< Prints Spirit level option   */
      lcd.printString("3.Back",1,4);               /*!< Prints Back option           */
      
      
      
/**   
   @brief      Depending on button pressed, according function is called
*/

      if ( buttonFlag1==1) {       /*!< If buttonFlag1=1, first button has been pressed    */
          buttonFlag1=0;           /*!< Flag is reset to 0                                 */
          lcd.clear();             /*!< Clear display                                      */
          percentage();            /*!< Go to Percentage feature                           */      
        }
      if ( buttonFlag2==1) {       /*!< If buttonFlag2=1, second button has been pressed    */
          buttonFlag2=0;           /*!< Flag is reset to 0                                 */
          lcd.clear();             /*!< Clear display                                      */
          spiritOptions();         /*!< Go to Spirit Options menu                          */
     
        }
        if ( buttonFlag3==1) {     /*!< If buttonFlag3=1, third button has been pressed    */
          buttonFlag3=0;           /*!< Flag is reset to 0                                 */
          lcd.clear();             /*!< Clear display                                      */
          intro();                 /*!< Go back to initial menu                            */
        }}}
        










/**   
 @namespace percentage
 @brief     Percentage feature
 @details   Calculates percentage of slope in x direction and prints on screen
 @details   Prints if slope is Uphill or Downhill   
*/

void percentage()
{


    Acceleration acceleration;                       /*!< Acceleration structure declared in MMA8452 class   */

    while(1) {
        
        lcd.printString("Back",55,0);                /*!< Prints Back option                                 */

        acceleration = mma8452.readValues();         /*!< Read current values and print over serial port     */
        serial.printf("x = %.2f g y = %.2f g z = %.2f g\n",acceleration.x,acceleration.y,acceleration.z);
        
        wait(0.3);                                   /*!< Short delay until next reading                     */
        lcd.clear();                                 /*!< Clear Display                                      */




        double slope = (-acceleration.x*90.0);       /*!< Variable named slope= -acceleration on x axis*90.0 */
        double perc;                                 /*!< Variable named perc                                */
        perc = tan ( slope * PI / 180.0 ) *100;      /*!< Perc is given by 100* the tangent of slope*Pi/180  */
        
        char bufferPerc[14];                         /*!< Characters in buffer = 14                          */
        int lengthPerc = sprintf(bufferPerc,"p= %.1f %%",perc);     /*!< Set buffer                          */

        if (lengthPerc <= 14)                        /*!< If characters in buffer are less than 14           */
            lcd.printString(bufferPerc,0,2);         /*!< Print buffer                                       */



        if(slope<0) {                               /*!< If slope value is negative                          */

            lcd.printString("  Downhill",0,4);        /*!< Print Downhill on display                           */

        } else if(slope>0) {                        /*!< If slope value is positive                          */
            lcd.printString("  Uphill",0,4);        /*!< Print Uphill on display                             */

        }
        
        if ( buttonFlag3==1) {     /*!< If buttonFlag3=1, third button has been pressed    */
          buttonFlag3=0;           /*!< Flag is reset to 0                                 */
          lcd.clear();             /*!< Clear display                                      */
          slopeOptions();          /*!< Go back to Slope Options menu                      */
        }}}









/**   
 @namespace spiritOptions
 @brief     Spirit Level Options
 @brief     Displays menu with different options for spirit levels
 @details   First option brings to a different menu to choose either x or y
 @details   Second options displays spirit level on both x and y axis   
*/
        
        void spiritOptions(){
            
            while(1){
      lcd.printString("1.X or Y",1,1);       /*!< Prints X/Y option             */
      lcd.printString("2.Both",1,2);         /*!< Prints Both x and y option    */
      lcd.printString("3.Back",1,4);         /*!< Prints Back option            */
      
              
/**   
   @brief      Depending on button pressed, according function is called
*/

      if ( buttonFlag1==1) {        /*!< If buttonFlag1=1, first button has been pressed    */
          buttonFlag1=0;            /*!< Flag is reset to 0                                 */
          lcd.clear();              /*!< Clear display                                      */
          spiritOptionsxy();        /*!< Go to Spirit Options X or Y menu                   */
        }
      if ( buttonFlag2==1) {        /*!< If buttonFlag2=1, second button has been pressed   */
          buttonFlag2=0;            /*!< Flag is reset to 0                                 */
          lcd.clear();              /*!< Clear display                                      */
          spiritBoth();             /*!< Open Spirit Level on both X and Y axis             */
        }
        if ( buttonFlag3==1) {      /*!< If buttonFlag3=1, third button has been pressed    */
          buttonFlag3=0;            /*!< Flag is reset to 0                                 */
          lcd.clear();              /*!< Clear display                                      */
          slopeOptions();           /*!< Go back to Slope Options menu                      */
        }}}
            
            
            
   
  
  
  
  
  
  
  
    
    
             
/**   
 @namespace spiritOptionsxy
 @brief     Menu to choose either X or Y spirit level
 @details   First button brings to X axis spirit level
 @details   Second button brings to Y axis spirit level
 @details   Third button brings back to previous menu  
*/              
            
void spiritOptionsxy(){
         
         while(1){
      lcd.printString("1.X",1,1);               /*!< Prints X option           */
      lcd.printString("2.Y",1,2);               /*!< Prints Y option           */
      lcd.printString("3.Back",1,4);            /*!< Prints Back option        */
      
/**   
   @brief depending on button pressed, according function is called
*/
      if ( buttonFlag1==1) {       /*!< If buttonFlag1=1, first button has been pressed    */
          buttonFlag1=0;           /*!< Flag is reset to 0                                 */
          lcd.clear();             /*!< Clear display                                      */
          spiritLevelx();          /*!< Go to Spirit Level on x axis                       */ 
        }
      if ( buttonFlag2==1) {       /*!< If buttonFlag2=1, second button has been pressed   */
          buttonFlag2=0;           /*!< Flag is reset to 0                                 */
          lcd.clear();             /*!< Clear display                                      */
          spiritLevely();          /*!< Go to Spirit Level on y axis                       */  
        }
        if ( buttonFlag3==1) {     /*!< If buttonFlag3=1, third button has been pressed    */
          buttonFlag3=0;           /*!< Flag is reset to 0                                 */
          lcd.clear();             /*!< Clear display                                      */
          spiritOptions();         /*!< Go back to Spirit Options menu                     */
        }}}
    
    
      
      







/**   
 @namespace spiritBoth
 @brief     X and Y axis spirit level feature
*/   
     
 void spiritBoth(){
                
                Acceleration acceleration;           /*!< Acceleration structure declared in MMA8452 class   */

    while(1) {

        acceleration = mma8452.readValues();         /*!< Read current values and print over serial port     */
        serial.printf("x = %.2f g y = %.2f g z = %.2f g\n",acceleration.x,acceleration.y,acceleration.z);
        
        wait(0.1);                                   /*!< Short delay until next reading                     */
        lcd.clear();
        
        
/**   
 @brief   Draws three circles
 @details First Circle has coordinates that vary with acceleration on x and y axis
 @details Second and third circle determine centre of screen as reference for user
*/
lcd.drawCircle(acceleration.y*42+42,acceleration.x*24+24,5,0); 
lcd.drawCircle(WIDTH/2,HEIGHT/2,3,0);
lcd.drawCircle(WIDTH/2,HEIGHT/2,1,1);

lcd.refresh();                     /*!< Refresh the screen */
        

       if ( buttonFlag3==1) {      /*!< If buttonFlag3=1, third button has been pressed    */
          buttonFlag3=0;           /*!< Flag is reset to 0                                 */
          lcd.clear();             /*!< Clear display                                      */
          spiritOptions();         /*!< Go back to Spirit Options menu                     */
        }}}
                
                
                
                
    
    
    
    
    
    
    
/**   
 @namespace spiritLevelx
 @brief     X axis spirit level feature
*/     
void spiritLevelx(){
                
    Acceleration acceleration;                       /*!< Acceleration structure declared in MMA8452 class            */

    while(1) {

        acceleration = mma8452.readValues();         /*!< Read current values and print over serial port              */
        serial.printf("x = %.2f g y = %.2f g z = %.2f g\n",acceleration.x,acceleration.y,acceleration.z);
        
        wait(0.1);                                   /*!< Short delay until next reading                              */
        lcd.clear();                                 /*!< Clear Display                                               */
           
         float valuex;                               /*!<  Variable name = valuex                                     */
         valuex= (acceleration.x*90.0);              /*!<  Variable value= acceleration in x axis * 90.0              */ 
        
        char bufferx[14];                            /*!< Characters in buffer = 14                                   */


int lengthx = sprintf(bufferx,"%.2f deg",valuex);    /*!< Print valuex in buffer                                      */
            if (lengthx <= 14)                       /*!< If characters in lentghtx are less than 14                  */
            lcd.printString(bufferx,18,2);           /*!< Print buffer                                                */

            
  
        
        


/**   
 Draws a circle and two lines across the screen
 @param i - integer for length of line
*/

lcd.drawCircle(9,acceleration.x*24+24,5,0);   /*!< Draws circle with coordinates that vary with acceleration on x axis     */

        for (int i = 0; i < WIDTH; i++) {     /*!< i starts from 0, if i is less than the width of the screen, increment i */
            lcd.setPixel(3,i);                /*!< First line,x coordinate = 3,  y coordinate = i                          */
            lcd.setPixel(15,i);               /*!< First line,x coordinate = 15, y coordinate = i                          */
            lcd.refresh();                    /*!< Refresh the screen                                                      */
        }
        


        if ( buttonFlag3==1) {     /*!< If buttonFlag3=1, third button has been pressed    */
          buttonFlag3=0;           /*!< Flag is reset to 0                                 */
          lcd.clear();             /*!< Clear display                                      */
          spiritOptionsxy();       /*!< Go back to Spirit Options X or Y menu              */
        
        }}}
                
    
 
 
 
 
 
    
/**   
 @namespace spiritLevely
 @brief     Y axis spirit level feature
*/ 
void spiritLevely()
{

    Acceleration acceleration;                       /*!< Acceleration structure declared in MMA8452 class            */

    while(1) {

        acceleration = mma8452.readValues();         /*!< Read current values and print over serial port              */
        serial.printf("x = %.2f g y = %.2f g z = %.2f g\n",acceleration.x,acceleration.y,acceleration.z);
        
        wait(0.1);                                   /*!< Short delay until next reading                              */
        lcd.clear();                                 /*!< Clear Display                                               */
           
         float valuey;                               /*!<  Variable name = valuey                                     */
         valuey= (acceleration.y*90.0);              /*!<  Variable value= acceleration in y axis * 90.0              */ 
        
        char buffery[14];                            /*!< Characters in buffer = 14                                   */


int lengthy = sprintf(buffery,"%.2f deg",valuey);    /*!< Print valuey in buffer                                      */
            if (lengthy <= 14)                       /*!< If characters in lentghty are less than 14                  */
            lcd.printString(buffery,0,4);            /*!< Print buffer                                                */
            


/**   
 Draws a circle and two lines across the screen
 @param i - integer for length of line
*/

lcd.drawCircle(acceleration.y*42+42,18,5,0); /*!< Draws circle with coordinates that vary with acceleration on y axis    */
        
        
        for (int i = 0; i < WIDTH; i++) {   /*!< i starts from 0, if i is less than the width of the screen, increment i */
            lcd.setPixel(i,24);             /*!< First line,  x coordinate = i, y coordinate = 24                        */
            lcd.setPixel(i,12);             /*!< Second line, y coordinate = i, y coordinate = 12                        */
            lcd.refresh();                  /*!< Refresh the screen                                                      */
        }
        


        if ( buttonFlag3==1) {              /*!< If buttonFlag3=1, third button has been pressed                         */
          buttonFlag3=0;                    /*!< Flag is reset to 0                                                      */
          lcd.clear();                      /*!< Clear display                                                           */
          spiritOptionsxy();                /*!< Go back to Spirit Options X or Y menu                                   */
        }}}


    
