/**
* @file main.cpp
* @brief Distance Sensor Project
* @brief Main file containing all of the functions and the int main().
* @brief Version: 1.0c
* @author Sam Russell
* @date March 2015
*/

#include "main.h"


void welcomeScreen()
{
    display.init(); // Initialise the display.
    display.clear(); // Clears the starting pattern from the screen.
    display.printString("--++--++--++--",0,0);     //Print string of "" at x,y locations.
    display.printString("Distance",18,1);
    display.printString("Sensor",22,2);
    display.printString("--++--++--++--",0,3);
    display.printString("Sam Russell",10,4);
    display.printString("--++--++--++--",0,5);
    wait(4); //Delay between the introduction and the begining of the game.
    display.clear(); //Clears the display.
}

void barChart()
{
    int buzz=0;
    display.drawRect(0,0,82,20,0); //Draw initial bar graph border.
    if (distance>240) {
        display.drawRect(72,2,8,16,1); //Draw 8 Bars
        if(mode==0 && buzz==0) { //when mode is normal buzz is zero, play a note.
            buzzer.period(1/349.23); //Plays note 'Fa'
            buzz=1; //sets buzz to one, to prevent multiple notes playing.
        }
    }if(distance>210) {
        display.drawRect(62,2,8,16,1); //Draw 7 Bars
        if(mode==0&&buzz==0) {
            buzzer.period(1/329.63); //Plays note 'Mi'
            buzz=1; //sets buzz to one, to prevent multiple notes playing.
        }
    }if(distance>180) {
        display.drawRect(52,2,8,16,1); //Draw 6 Bars
        if(mode==0 && buzz==0) { //when mode is normal buzz is zero, play a note.
            buzzer.period(1/329.63); //Plays note 'Mi'
            buzz=1; //sets buzz to one, to prevent multiple notes playing.
        }
    }  if(distance>150) {
        display.drawRect(42,2,8,16,1); //Draw 5 Bars
        if(mode==0 && buzz==0) { //when mode is normal buzz is zero, play a note.
            buzzer.period(1/293.66); //Plays note 'Re'
            buzz=1; //sets buzz to one, to prevent multiple notes playing.
        }
    } if(distance>120) {
        display.drawRect(32,2,8,16,1); //Draw 4 Bars
        if(mode==0 && buzz==0) { //when mode is normal buzz is zero, play a note.
            buzzer.period(1/293.66); //Plays note 'Re'
            buzz=1; //sets buzz to one, to prevent multiple notes playing.
        }
    }  if(distance>90) {
        display.drawRect(22,2,8,16,1); //Draw 3 Bars
        if(mode==0 && buzz==0) { //when mode is normal buzz is zero, play a note.
            buzzer.period(1/261.63); //Plays note 'Do'
            buzz=1; //sets buzz to one, to prevent multiple notes playing.
        }
    }if(distance>60) {
        display.drawRect(12,2,8,16,1); //Draw 2 Bars
        if(mode==0 && buzz==0) { //when mode is normal buzz is zero, play a note.
            buzzer.period(1/261.63); //Plays note 'Do'
            buzz=1; //sets buzz to one, to prevent multiple notes playing.
        }
    } if(distance>=30) {
        display.drawRect(2,2,8,16,1); //Draw 1 Bar
        if(mode==0 && buzz==0) { //when mode is normal buzz is zero, play a note.
            buzzer.period(1/246.94); //Plays note 'Si'
            buzz=1; //sets buzz to one, to prevent multiple notes playing.
        }
    } 
    if(distance<30) {
        if(mode==0 && buzz==0) { //when mode is normal buzz is zero, play a note.
            buzzer.period(1/246.94); //Plays note 'Si'
            buzz=1; //sets buzz to one, to prevent multiple notes playing.
        }
    } 
}

void error(int code)
//ERROR CODE
{
    while(1) {
        leds = 0;
        wait(0.25);
        leds = code;
        wait(0.25);
    }
}

void setTime()
{
// print time for debugging
    pc.printf("set_time - %s",rxString);
// atoi() converts a string to an integer
    int time = atoi(rxString);
// update the time
    set_time(time);
}

void serialISR()
{
// when a serial interrupt occurs, read rx string into buffer
    pc.gets(rxString,16);
// set flag
    setTimeFlag = 1;
}

void writeDataToFile(char* data, int dataDistance)
{
    if (mode<2){
    leds = 7; //logging indicator
    logLED = 1; // turn on LEDs for feedback
    }
    pc.printf("Data Logged\n"); //DEBUG MESSAGE
    FILE *fp = fopen("/local/log.csv", "a"); // open 'log.txt' for appending
// if the file doesn't exist it is created, if it exists, data is appended to the end
    fprintf(fp,"%s,%d\n",data,dataDistance); // print string to file
    fclose(fp); // close file
    if (mode<2) {
    leds = 1;
    }
}

//When timer expires set flag to equal 1.
void timerExpired()
{
    timerflag = 1;
}

float avgDist()
//After 10 readings calculate the average and define that as the total distance.
{
    float d1 = SRF02.getDistanceCm();
    float d2 = SRF02.getDistanceCm();
    float d3 = SRF02.getDistanceCm();
    float d4 = SRF02.getDistanceCm();
    float d5 = SRF02.getDistanceCm();
    float d6 = SRF02.getDistanceCm();
    float d7 = SRF02.getDistanceCm();
    float d8 = SRF02.getDistanceCm();
    float d9 = SRF02.getDistanceCm();
    float d10 = SRF02.getDistanceCm();
    float distance = (d1+d2+d3+d4+d5+d6+d7+d8+d9+d10)/10;
    return distance;
}

void buttonPressed()
{
    wait(0.2);
    mode++; //count up mode when button is pressed.
    leds = 15;
}

int main()
{
    PHY_PowerDown(); ///1) Powers down the ethernet, function taken from the Ethernet Power Cotrnol library by Michael Wei.
    pc.baud(9600); ///2) Sets the baud rate to 9600 (default)
    timer.attach(&timerExpired,1); ///3) Configures & Initalises Timer
    welcomeScreen(); ///4) Displays welcome screen.
    pc.attach(&serialISR); ///5) Attaches PC so when an interupt occurs over the serial the function "serialISR" is executed.
    char buffer[30]; ///6) Buffer created to store time string

    Button.rise(&buttonPressed); ///8) Configures & Initalises button pressed function.

    while(1) {
        ///9) When timer expires and the timerflag boolean value is true, run the following.
        if(timerflag) {
            leds = 1; ///10) sets LED indication.
            timerflag = 0; ///11) Reset timer flag.
            distance = avgDist(); ///12) Set the distance variable to the averaged value from the sensor.
            time_t seconds = time(NULL); ///13) Get current time
            strftime(buffer, 30 , "%R %d/%m/%y", localtime(&seconds)); ///14) Format time into a string (time and date)
            pc.printf("%s , %d cm\n",buffer,distance); ///15) Print the distance value and the date/time to the serial.
            display.clear(); ///16) Clear the display, updating bar graph.
            ///17) Checks which mode the device is in and prints the mode name to the screen and executes the required actions of that mode.
            if(mode==0) {
                display.printString("Normal Mode",8,5); //Print mode name to screen.
                buzzer =0.5; //turns buzzer on
            } else if(mode==1) {
                display.printString("Quiet Mode",10,5); //Print mode name to screen.
                buzzer =0; //turns buzzer off
            } else if(mode==2) {
                display.printString("Power Saving",8,5); //Print mode name to screen.
                backlight = 0; //sets the backlight off
                Sleep(); //mbed power saving sleep mode.
                leds = 0; //led indication OFF
            } else if(mode==3) {
                ///17b) when mode becomes an integer value of 3, reset mode and backlight.
                backlight =1; //sets the backlight on
                mode=0; // resets mode flag.
                leds = 0; //LED indication reset
            }
            char buffer2[50]; ///18) Buffer2 is used to store the distance string.
            sprintf (buffer2, "%d cm", distance); ///19) Composes a printf compatable string and stores the distance in the buffer2.
            display.printString(buffer2,25,3); ///20) Prints the string stored in buffer2
            float L = Switch.read(); ///21) Checks switch value/position.
            if(L>0.9) {
                ///22) When switch is on, save the data to file and turn indicator on.
                writeDataToFile(buffer,distance);
                pc.printf("Logging Data\n"); //DEBUG MESSAGE
            } else {
                ///22b) When switch is off, don't save the data to file and turn indictor off.
                logLED = 0;
                pc.printf("Not Logging Data\n");
            }
            barChart(); ///23) Function which creates and updates the visual and audible indication of the distance.
        }
        if (setTimeFlag) { ///24) If setTimeFlag is TRUE then set the time and reset the flag.
            setTimeFlag = 0; // clear flag
            setTime(); // update time
        }
        sleep(); ///25) Return the mbed to power saving sleep mode.
    }
}
