/**
@file main.h
@brief Header file containing functions prototypes, defines and global variables.
@brief Revision 1.0.
@author Nikhil Suresh Pillai
@date   May 2015
*/

#ifndef MAIN_H
#define MAIN_H

#include "mbed.h"
#include "N5110.h"
#include "BMP180.h"
#include "beep.h"
#include "PowerControl/PowerControl.h"
#include "PowerControl/EthernetPowerControl.h"

#define celcius 0
#define fahrenheit 1

/**
@namespace bmp180
@brief I2C Bus for barometric pressure sensor chip's SDA and SCL
*/
BMP180 bmp180(p28,p27);

/**
@namespace leds
@brief GPIO bus output for onboard status leds
*/
BusOut leds(LED4,LED3,LED2,LED1);

/**
@namespace local
@brief Create local filesystem
*/
LocalFileSystem local("local");

/**
@namespace POT1
@brief Analog GPIO for potentiometer
*/
AnalogIn POT1(p20);

/**
@namespace logSwitch
@brief GPIO for logging switch
*/
DigitalIn logSwitch(p21);

/**
@namespace redled
@brief GPIO for warning led
*/
DigitalOut redled(p25);

/**
@namespace greenled
@brief GPIO for logging status led
*/
DigitalOut greenled(p24);

/**
@namespace buzzer
@brief GPIO for warning buzzer
*/
Beep buzzer(p22);

/**
@namespace buttonA
@brief GPIO for temperature graph button A
*/
InterruptIn buttonA(p15);

/**
@namespace buttonB
@brief GPIO for pressure graph button B
*/
InterruptIn buttonB(p18);

/**
@namespace buttonC
@brief GPIO for weather prediction button C
*/
InterruptIn buttonC(p17);

/**
@namespace buttonD
@brief GPIO for unit change button D
*/
InterruptIn buttonD(p16);

/**
@namespace lcd
@brief GPIO for LCD display
*/
N5110 lcd(p7,p8,p9,p10,p11,p13,p26);

/**
@namespace serial
@brief GPIO for serial reading and writing
*/
Serial serial(USBTX,USBRX);

Ticker timer; /*!< timer Ticker initialised */
Ticker stateTimer; /*!< state timer Ticker initialised */
Ticker alarmTimer; /*!< alarm timer Ticker initialised */
Ticker writingTimer; /*!< writing timer Ticker initialised */
Ticker graphTimer; /*!< graph timer Ticker initialised */

int timerFlag=0; /*!< timer flag set in ISR */
int stateTimerFlag=0; /*!< state timer flag set in ISR */
int alarmTimerFlag=0; /*!< alarm timer flag set in ISR */
int writingTimerFlag=0; /*!< writing timer flag set in ISR */
int graphTimerFlag=0; /*!< graph timer flag set in ISR */
int setTimeFlag = 0; /*!< set time flag set in ISR */
int buttonAFlag = 0; /*!< button A flag set in ISR */
int buttonBFlag = 0; /*!< button B flag set in ISR */
int buttonCFlag = 0; /*!< button C flag set in ISR */
int initFlag = 0; /*!< init flag set in ISR */

int alarm = 0; /*!< alarm flag set in ISR */
int state = 0; /*!< state flag set in ISR */
int prediction = 0; /*!< prediction flag set in ISR */
int i = 0; /*!< Initialise increment variable i */
int j = 0; /*!< Initialise increment variable j*/
int unit = celcius; /*!< unit flag set in ISR */

char rxString[16]; /*!< buffer to store received string for time */

float temparray[84]; /*!< Array to hold temperature readings */
float pressarray[84]; /*!< Array to hold pressure readings */
float presscompare[12];  /*!< Array to hold pressure readings for prediction*/

/**
ISR that is called when serial data is received
*/
void serialISR();

/**
Sets the UNIX time
*/
void setTime();

/**
Checks the state for weather prediction
*/
void setState();

/**
Logs data to csv file on the flash memory
@param temp - Temperature to log
@param press - Pressure to log
@param time - Time to log
*/
void writeDataToFile(float temp,float press,char* time);

/**
Sets pixels to display sunny weather
*/
void sunny();

/**
Sets pixels to display mild cloudy weather
*/
void cloudySun();

/**
Sets pixels to display cloudy weather
*/
void clouds();

/**
Sets pixels to display rainy weather
*/
void rainy();

/**
Sets pixels to display stormy weather
*/
void stormy();

#endif