/**
@file main.h
@brief Header file containing functions prototypes, defines and global variables.
@brief Shows examples of creating Doxygen documentation.
@brief Revision 1.0.
*/

#ifndef MAIN_H
#define MAIN_H

#define PI 3.14159265359

#include "mbed.h"



N5110 lcd(p7,p8,p9,p10,p11,p13,p26);
/**
@namespace lcd
@brief input for lcd screen
*/

Serial serial(USBTX,USBRX);
/**
@namespace serial
@brief serial port for debugging
*/

BusOut leds(LED4,LED3,LED2,LED1);  
/**
@namespace leds
@brief output for mbed leds
*/
DigitalIn pushbutton1(p19);
/** 
@namespace 
@brief output for onboard button
*/

BMP180 bmp180(p28,p27);
/**
@namespace
@brief SDA and SCL line for sensor
*/

PwmOut Redled(p24);
/**
@namespace
@brief PWM output for onboard led
*/

int selectedOption1 = 0;
int selectedOption2 = 0;
int selectedOption3 = 0;
int selectedOption4 = 0;
   
/**
@brief the variables for the menus
*/
int buttonPressed = 0;

/**
@brief the button initalized as not pressed
*/

int cells[84][48];
/**
@brief boundary conditions of lcd pixels*/

Timer t1; 
Timer t2;
Timer t3;
Timer t4;
Timer t5;
Timer t6;
/** 
@namespace
@brief the timers used for while loops in measure/graph functions
*/



#endif
