
/**
@file main.cpp

@brief Program implementation
@brief multi sensor device
@author Keiarash Zoughi
@date May 2015
*/


#include "mbed.h"
#include "N5110.h"
#include "BMP180.h"
#include "main.h"


#define PI 3.14159265359


   

void checkt()///checks the temp
{
    lcd.clear();

    Measurement measurement;  /// measurement structure declared in BMP180 class


    // /read values (T in Celsius and P in mb) and print over serial port
    measurement = bmp180.readValues();
    serial.printf("T = %.2f C P = %.2f mb\n",measurement.temperature,measurement.pressure);

    /// so can display a string of a maximum 14 characters in length
    // /or create formatted strings - ensure they aren't more than 14 characters long
    float temperature = measurement.temperature;
    /// display on screen
char buffer[14];  // each charact
int length = sprintf(buffer,"T = %.2f C",temperature); /// print formatted data to buffer
        /// it is important the format specifier ensures the length will fit in the buffer
        if (length <= 14)  /// if string will fit on display
        lcd.printString(buffer,0,5);           /// display on screen



    if(temperature > 30.0 ) {

        lcd.printString("TEMP IS HIGH!",0,1); //boundaries
        Redled=1.0;



    } else if(temperature < 3.0) {

        lcd.printString("TEMP IS LOW!",0,1);
        Redled= 1.0;


    } else {
        lcd.printString("TEMP IS OK!",0,1);
        Redled = 0.0;
    }


    wait(3);
lcd.clear();


}

void checka()///checks the altitude
{
    lcd.clear();

    Measurement measurement;  /// measurement structure declared in BMP180 class


    /// read values (T in Celsius and P in mb) and print over serial port
    measurement = bmp180.readValues();
        char buffer[14];
        int temperature = measurement.temperature;
        float pressure = measurement.pressure;  /// same idea with floats

        float altitude = -(log(pressure/1013.25)*1.38e-23*(273+temperature))/(9.81*28.95);
 /**
@param pressure
@param temperature
@returns the anser of equation and defines as altitude
*/            
        
        
        serial.printf("A = %.2f m",altitude);
        int length = sprintf(buffer,"A = %.2f m",altitude); // print formatted data to buffer
        /// it is important the format specifier ensures the length will fit in the buffer
        if (length <= 14)  
            lcd.printString(buffer,0,5);   


    if(altitude > 1800.0 ) {

        lcd.printString("ALTITUDE IS HIGH!",0,1); ///boundaries
        Redled=1.0;

}



     else {
        lcd.printString("ALTITUDE OK!",0,1);
        Redled = 0.0;
    }


    wait(3);
lcd.clear();


}


void pie(){
lcd.clear();

    Measurement measurement;  /// measurement structure declared in BMP180 class
    t5.start();
    while(t5.read()<10) { // if timer reaches point, tehn breaks loop, stopped at resetted at the end     
    

        /// read values (T in Celsius and P in mb) and print over serial port
        measurement = bmp180.readValues();
        serial.printf("T = %.2f C ",measurement.temperature);

        
        /// so can display a string of a maximum 14 characters in length
        /// or create formatted strings - ensure they aren't more than 14 characters long
        int z = pow(measurement.temperature,2)/30;
 /**
 @param measurement.temperature
 @returns value of equation as int z
 @brief in order to scale temperature in proportion to the screen
 */       
        
        
        lcd.drawCircle(42,24,22,0);  /// x,y,radius,transparent with outline
        for (int x = 0; x < WIDTH ; x+=10) {
            /// x0,y0,x1,y1,type 0-white,1-black,2-dotted
            lcd.drawLine(42,24,62,z,1);
            lcd.drawLine(42,24,62,34,1);
            lcd.printString("T",1,3);
            lcd.printString("1/V",64,3);

lcd.clear();
lcd.printString("T",1,3);
            lcd.printString("1/V",64,3);

        lcd.drawCircle(42,24,22,0);  /// x,y,radius,transparent with outline

    }

 
        
}
 t5.stop();       
 t5.reset();       

lcd.clear();   
}


///shows pressure reading and temperature


void temperature()
{
    lcd.clear();

    Measurement measurement;  /// measurement structure declared in BMP180 class
    t1.start();
    while(t1.read()<5) { /// if timer reaches point, tehn breaks loop, stopped at resetted at the end     
    

        /// read values (T in Celsius and P in mb) and print over serial port
        measurement = bmp180.readValues();
        serial.printf("T = %.2f C P = %.2f mb\n",measurement.temperature,measurement.pressure);

        char buffer[14];  // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
        /// so can display a string of a maximum 14 characters in length
        // or create formatted strings - ensure they aren't more than 14 characters long
        int temperature = measurement.temperature;
        int length = sprintf(buffer,"T = %2d C",temperature); // print formatted data to buffer
        /// it is important the format specifier ensures the length will fit in the buffer
        if (length <= 14)  // if string will fit on display
            lcd.printString(buffer,0,1);           //

   
   
   lcd.drawLine(42,40,42,18,1);
   lcd.drawLine(47,40,47,18,1); ///the whole thing is a thermometer
   lcd.drawLine(42,40,44,40,1);
   lcd.drawLine(42,35,44,35,1);
   lcd.drawLine(42,30,44,30,1);
   lcd.drawLine(42,25,44,25,1);
   lcd.drawLine(42,20,44,20,1);
   lcd.setPixel(41,41);
   lcd.setPixel(48,41);
   lcd.setPixel(40,42);
   lcd.setPixel(49,42);
   lcd.setPixel(41,43);
   lcd.setPixel(48,43);
   lcd.setPixel(42,44);
   lcd.setPixel(47,44);
   lcd.drawLine(42,44,47,44,1);

/**
@param draw line from two points/sets pixel
@returns line is drawn/pixel is set
*/

   lcd.refresh();


   
   
   
    }
t1.stop();
 t1.reset();       


lcd.clear();

}

void pressure()
{
    lcd.clear();

    Measurement measurement;  // measurement structure declared in BMP180 class
    
    t2.start();

    while(t2.read()<5) { // if timer reaches point, tehn breaks loop, stopped at resetted at the end     
    

        // read values (T in Celsius and P in mb) and print over serial port
        measurement = bmp180.readValues();
        serial.printf("T = %.2f C P = %.2f mb\n",measurement.temperature,measurement.pressure);

        char buffer[14];  // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
        // so can display a string of a maximum 14 characters in length
        // or create formatted strings - ensure they aren't more than 14 characters long

//
        float pressure = measurement.pressure;  // same idea with floats
        int length = sprintf(buffer,"P = %.2f mb",pressure);
        if (length <= 14)
            lcd.printString(buffer,0,1);
            
            
                        lcd.drawLine(42,38,42,48,1);
                        lcd.drawLine(47,33,57,33,1);
                        lcd.drawLine(42,27,42,17,1);
                        lcd.drawLine(37,33,27,33,1);
                        lcd.drawRect(27,17,30,30,0);    // transparent, just outline
                        lcd.drawLine(40,38,44,38,1);
                        lcd.drawLine(47,31,47,35,1);//pressure box shape
                        lcd.drawLine(40,27,44,27,1);
                        lcd.drawLine(37,31,37,35,1);
            /**
@param draw line from two points/sets pixel
@returns line is drawn/pixel is set
       */     
    }
t2.stop();
 t2.reset();       


lcd.clear();

}



void altitude()  // creating a new reading from the current ones, this appoximates the altitude in metres.
{

    lcd.clear();

    Measurement measurement;  // measurement structure declared in BMP180 class


t3.start();

    while(t3.read()<5) { // if timer reaches point, tehn breaks loop, stopped at resetted at the end     
    
        // read values (T in Celsius and P in mb) and print over serial port
        measurement = bmp180.readValues();
        char buffer[14];
        int temperature = measurement.temperature;
        float pressure = measurement.pressure;  // same idea with floats

        float altitude = -(log(pressure/1013.25)*1.38e-23*(273+temperature))/(9.81*28.95);
/**
@param pressure
@param temperature
@returns the anser of equation and defines as altitude
*/        
        
        
        serial.printf("A = %.2f m",altitude);
        int length = sprintf(buffer,"A = %.2f m",altitude); // print formatted data to buffer
        // it is important the format specifier ensures the length will fit in the buffer
        if (length <= 14)  // if string wi
            lcd.printString(buffer,0,1);           // display on screen


            lcd.drawLine(4,48,24,28,1);
            lcd.drawLine(24,28,44,48,1);
            lcd.drawLine(34,38,44,28,1);  // sketch of two mountains using pythagoras
            lcd.drawLine(44,28,64,48,1);
   /**
@param draw line from two points/sets pixel
@returns line is drawn/pixel is set
       */                


    }
t3.stop();
 t3.reset();       

lcd.clear();

}
//pushbutton - 0

//plots graph of temperature point by point
void graph()
{
    lcd.clear();

    Measurement measurement;  // measurement structure declared in BMP180 class
    int i = 0;
    float graph[84]= {0};
    
    
   t4.start(); 
    while(t4.read()<15) { // if timer reaches point, tehn breaks loop, stopped at resetted at the end     
    

        // read values (T in Celsius and P in mb) and print over serial port
        measurement = bmp180.readValues();

        int temperature = measurement.temperature;
/**
@brief the temperature changed to integer value
*/

        graph[i]= temperature ;
        lcd.plotArray(graph);
/**
@brief plots the graph using the array
*/        
        
        wait(0.1);  
/**
@param delay
@brief allows time till next reading
*/        
        
        
        i++;
        if (i>83) {
            i=0;
            lcd.clear();
        }
    }

t4.stop();
 t4.reset();       

lcd.clear();
}




void graphScreen(){
    
 lcd.clear();
    lcd.printString("Hold Button!",6,2);//select measure menu
    wait(2);
    lcd.clear();
    selectedOption1 = 0;

    while(1) {

        lcd.drawRect(70,6,10,10,1);
        lcd.drawRect(70,21,10,10,0);
        lcd.drawRect(70,37,10,10,0);//check box 3
        lcd.printString("line graph",1,1);
        lcd.printString("pie chart",1,3);
        lcd.printString("go back",1,5);
/**
@Brief sets the first scene of menu
*/
        
        
        lcd.printString(">",62,1);
        selectedOption1 = 1;
        if (pushbutton1)
            break;
        wait(2);
        lcd.clear();

        lcd.drawRect(70,6,10,10,0);
        lcd.drawRect(70,21,10,10,1);
        lcd.drawRect(70,37,10,10,0);//check box 3
        lcd.printString("line graph",1,1);
        lcd.printString("pie chart",1,3);

        lcd.printString("go back",1,5);
        lcd.printString(">",62,3);
        selectedOption1 = 2;
        if (pushbutton1)
            break;
        wait(2);
        lcd.clear();

        lcd.drawRect(70,6,10,10,0);
        lcd.drawRect(70,21,10,10,0);
        lcd.drawRect(70,37,10,10,1);//check box 3
        lcd.printString("line graph",1,1);
        lcd.printString("pie chart",1,3);
        lcd.printString("go back",1,5);
        lcd.printString(">",62,5);
        selectedOption1 = 3;
        if (pushbutton1)
            break;
        wait(2);
        lcd.clear();

    }

    if(selectedOption1 == 1) {  //selected option is tied to a certain output depending on its value

        lcd.clear();
    }

    if(selectedOption1 == 2) {

        graph();

    }

    if(selectedOption1 == 3) {

        pie();
    }


}   



void measurementsScreen()
{
    lcd.clear();
    lcd.printString("Hold Button!",6,2);//select measure menu
    wait(2);
    lcd.clear();
    selectedOption2 = 0;

    while(1) {

        lcd.drawRect(70,6,10,10,1);
        lcd.drawRect(70,21,10,10,0);
        lcd.drawRect(70,37,10,10,0);//check box 3
        lcd.printString("temperature",1,1);
        lcd.printString("altitude",1,3);
        lcd.printString("pressure",1,5);
/**
@Brief sets the first scene of menu
*/
        lcd.printString(">",62,1);
        selectedOption2 = 1;
        if (pushbutton1)
            break;
        wait(2);
        lcd.clear();

        lcd.drawRect(70,6,10,10,0);
        lcd.drawRect(70,21,10,10,1);
        lcd.drawRect(70,37,10,10,0);//check box 3
        lcd.printString("temperature",1,1);
        lcd.printString("pressure",1,5);

        lcd.printString("altitude",1,3);
        lcd.printString(">",62,3);
        selectedOption2 = 2;
        if (pushbutton1)
            break;
        wait(2);
        lcd.clear();

        lcd.drawRect(70,6,10,10,0);
        lcd.drawRect(70,21,10,10,0);
        lcd.drawRect(70,37,10,10,1);//check box 3
        lcd.printString("temperature",1,1);
        lcd.printString("altitude",1,3);
        lcd.printString("pressure",1,5);
        lcd.printString(">",62,5);
        selectedOption2 = 3;
        if (pushbutton1)
            break;
        wait(2);
        lcd.clear();

    }

    if(selectedOption2 == 1) {//selected option is tied to a certain output depending on its value


        pressure();
    }

    if(selectedOption2 == 2) {

        temperature();

    }

    if(selectedOption2 == 3) {

        altitude();
    }


}

void introScreen()
{

   lcd.printString("Welcome to",11,1);
    lcd.printString("Keiarash's",12,2);
    lcd.printString("Multi Sensor",7,3);
    Redled= 1.0;
 
      for(int i = 0; i < 84 ; i+=6) {     //checkerboard
        for (int j = 0; j < 48 ; j+=6) {
            lcd.setPixel(i,j);

/**
@param set the pixel at designated i,j point
@return pixel is set
*/

        }
        }
lcd.refresh();

t6.start();

while(t6.read()<3){    // if timer reaches point, tehn breaks loop, stopped at resetted at the end     
    
    lcd.inverseMode();//inverse used to make flashy effect
    wait(0.5);
    lcd.normalMode();
    wait(0.5);
}

t6.stop();
t6.reset();

}


void extrasScreen()
{
    lcd.clear();
    lcd.printString("Hold Button!",6,2);//select measure menu
    wait(2);
    lcd.clear();
    selectedOption3 = 0;

    while(1) {

        
        lcd.drawRect(70,6,10,10,1);
        lcd.drawRect(70,21,10,10,0);
        lcd.drawRect(70,37,10,10,0);//check box 3
        lcd.printString("check temp",1,1);
        lcd.printString("check alt",1,3);
        lcd.printString("go back",1,5);
/**
@Brief sets the first scene of menu
*/
        lcd.printString(">",62,1);
        selectedOption3 = 1;
        if (pushbutton1)
            break;
        wait(2);
        lcd.clear();

        lcd.drawRect(70,6,10,10,0);
        lcd.drawRect(70,21,10,10,1);
        lcd.drawRect(70,37,10,10,0);//check box 3
        lcd.printString("check temp",1,1);
        lcd.printString("check alt",1,3);
        lcd.printString("go back",1,5);
        lcd.printString(">",62,3);
        selectedOption3 = 2;
        if (pushbutton1)
            break;
        wait(2);
        lcd.clear();
        
          lcd.drawRect(70,6,10,10,0);
        lcd.drawRect(70,21,10,10,0);
        lcd.drawRect(70,37,10,10,1);//check box 3
        lcd.printString("check temp",1,1);
        lcd.printString("check alt",1,3);
        lcd.printString("go back",1,5);
        lcd.printString(">",62,5);
        selectedOption3 = 3;
        if (pushbutton1)
            break;
        wait(2);
        lcd.clear();


    }

    if(selectedOption3 == 1) {// using the same method as mainscreen, if the option is the one in the loop, then it will go to that function

        lcd.clear();
    }

    if(selectedOption3 == 2) {//selected option is tied to a certain output depending on its value


        checkt();

    }


    if(selectedOption3 == 3) {

        checka();

    }

}



void mainScreen()
{
    lcd.clear();
    lcd.printString("Hold Button!",6,2);//select measure menu

    wait(2);
    lcd.clear();

    selectedOption4 = 0;

    while(1) {//initialse pushbutton as 0

        //check boxes-options to be selected
        lcd.drawRect(70,6,10,10,1);//check box 1
        lcd.drawRect(70,21,10,10,0);//check box 2
        lcd.drawRect(70,37,10,10,0);//check box 3
/**
@Brief sets the first scene of menu
*/
        //option titles-appropriate to check boxes
        lcd.printString("extras",1,1);//select measure menu
        lcd.printString("graph",1,3);//select settings menu
        lcd.printString("measure",1,5);//select graph plot
        lcd.printString(">",62,1);//pointer
        selectedOption4 = 1;
        if (pushbutton1)
            break;

        wait(2);
        lcd.clear();

        lcd.drawRect(70,6,10,10,0);
        lcd.drawRect(70,21,10,10,1);
        lcd.drawRect(70,37,10,10,0);


        lcd.printString("extras",1,1);
        lcd.printString("graph",1,3);
        lcd.printString("measure",1,5);
        lcd.printString(">",62,3);
        selectedOption4 = 2;
        if (pushbutton1)
            break;


        wait(2);
        lcd.clear();

        lcd.drawRect(70,6,10,10,0);
        lcd.drawRect(70,21,10,10,0);
        lcd.drawRect(70,37,10,10,1);


        lcd.printString("extras",1,1);
        lcd.printString("graph",1,3);
        lcd.printString("measure",1,5);
        lcd.printString(">",62,5);
        selectedOption4 = 3;
        if (pushbutton1)
            break;


        wait(2);
        lcd.clear();


    }

    if(selectedOption4 == 1) {            //if these options are at their value, then it will go to corresponding menu

        measurementsScreen();
    }

    if(selectedOption4 == 2) {

        extrasScreen();
    }

    if(selectedOption4 == 3) {

        graphScreen();
    }
}


int main()
{ Redled.period(0.02); // set PWM period to 20m     //pwm
   pushbutton1.mode(PullUp);//initial value 0       //set button to pullup, singe it is connected to gnd
    // initiliase barometer
    bmp180.init();

    lcd.init();
    introScreen();
    
/**
@brief calls introScreen function
*/    

    
    wait(1);
    Redled =0;   //turn led off
    

   while(1) {
   
    lcd.clear();
    lcd.printString("MAIN MENU...",6,2); //tells user where they are going
    /**
    @param prints string
    @return shows string
    @brief helps user navigate
    */
    
    wait(2);
/**
@param delay given amount of seconds
@brief allows string to stay on string for user to see
*/    
    
    mainScreen();
    

    }

sleep();
}

