/**
@file main.cpp

@brief Program implementation

*/
#include "main.h"

// Function Prototypes
void pressStart();
void pause();
void winningcondition();
void losingcondition();
void  drawMap();
void  drawCoin();
void  drawGhost();
void  checkRight();
void  checkLeft();
void  checkDown();
void  checkUp();
void  Boundarycheck();
void  WastedCheck();
void  checkCoin();
void  creditscreen();
void writeScore();

void ghosttimerexpired()
{
    followflag=1;
}

void scoreexpired()
{
    scoreflag=1;
}

void ghostfollow()
{

    if( y<j) { // If ghost id above pacman, move downwards
        y++;
    }

    if(y>j) { // If ghost is  below pacman, move upwards
        y--;

    }
    if ( x>i) {// If ghost is to the right of pacman, move left
        x--;
    }
    if (x<i) {// If ghost is to the left of pacman, move right
        x++;
    }
}

void tune()
{

    for (int q=0; q<32; q++) {
        buzzer.period(1.0/(frequency[q])); // set PWM period
        buzzer=0.5; // set duty cycle
        wait(0.5*beat[q]); // hold for beat period
    }
    buzzer=0;
}

void  creditscreen()
{

    lcd.printString("Thank You",15,1);
    lcd.printString("For",25,20);
    lcd.printString("Playing",16,3);
}
void calibrateJoystick() // read default positions of the joystick to calibrate later readings
{
    button.mode(PullDown);
    // must not move during calibration
    joystick.x0 = xPot;  // initial positions in the range 0.0 to 1.0 (0.5 if centred exactly)
    joystick.y0 = yPot;
}

void updateJoystick()
{
    joystick.x = xPot - joystick.x0; // read current joystick values relative to calibrated values (in range -0.5 to 0.5, 0.0 is centred)
    joystick.y = yPot - joystick.y0;
    joystick.button = button; // read button state

    // calculate direction depending on x,y values
    // tolerance allows a little lee-way in case joystick not exactly in the stated direction
    if ( fabs(joystick.y) < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = CENTRE;
    } else if ( joystick.y > DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = UP;
    } else if ( joystick.y < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = DOWN;
    } else if ( joystick.x > DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = LEFT;
    } else if ( joystick.x < DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = RIGHT;
    } else {
        joystick.direction = UNKNOWN;
    }
}

void timerExpired() // ISR for timeout function
{
    timerflag=1;
}

void pressPause()// Interrupt Service Routine (ISR) for pause button
{
    buttonflag=!buttonflag;// set button flag
}

void pause()
{
    timer.attach(&timerExpired,15.0);// Call timeout after 15 seconds
    Jbutton.rise(&pressPause); // event generated on rising edge
    while (buttonflag) {
        lcd.clear();
        lcd.printString("Pause", 25,21);
        lcd.setBrightness(bright);
        while (timerflag) {// Device goes into sleep and lcd is powered down after 15 seconds in pause menu
            timer.detach();
            lcd.turnOff();
            Sleep();
            if (!buttonflag) { // Press button again to wake the device up
                timerflag=0;
                lcd.init();
                buttonflag=0;
            }
        }
    }

}
void drawPacman2()
{
    if(joystick.direction == RIGHT) {
        lcd.setPixel(i,j);
        lcd.setPixel(i+1,j);
        lcd.setPixel(i+2,j);
        lcd.setPixel(i+3,j);
        lcd.setPixel(i-1,j);
        lcd.setPixel(i-2,j);
        lcd.setPixel(i-3,j);
        lcd.setPixel(i,j+1);//Direction dependent(Up and Down)
        lcd.setPixel(i+1,j+1);//Direction dependent(Up and Down)
        lcd.setPixel(i+2,j+1);
        lcd.setPixel(i+3,j+1);
        lcd.setPixel(i-1,j+1);//Direction dependent(Up and Down)
        lcd.setPixel(i-2,j+1);
        lcd.setPixel(i-3,j+1);
        lcd.setPixel(i,j+2);//Direction dependent(Up and Down)
        lcd.setPixel(i+1,j+2);//Direction dependent(Up and Down)
        lcd.setPixel(i+2,j+2);
        lcd.setPixel(i-1,j+2);//Direction dependent(Up and Down)
        lcd.setPixel(i-2,j+2);
        lcd.setPixel(i-1,j+3);//Direction dependent(Up and Down)
        lcd.setPixel(i,j+3);//Direction dependent(Up and Down)
        lcd.setPixel(i+1,j+3);//Direction dependent(Up and Down)
        lcd.setPixel(i-2,j-1);
        lcd.setPixel(i-3,j-1);
        lcd.setPixel(i+3,j-1);
        lcd.setPixel(i+2,j-1);
        lcd.setPixel(i+2,j-2);
        lcd.setPixel(i-2,j-2);


    }   else if(joystick.direction == LEFT) {
        lcd.setPixel(i,j);
        lcd.setPixel(i+1,j);
        lcd.setPixel(i+2,j);
        lcd.setPixel(i+3,j);
        lcd.setPixel(i-1,j);
        lcd.setPixel(i-2,j);
        lcd.setPixel(i-3,j);
        lcd.setPixel(i,j-1);//Direction dependent(Up and Down)
        lcd.setPixel(i+1,j-1);//Direction dependent(Up and Down)
        lcd.setPixel(i+2,j+1);
        lcd.setPixel(i+3,j+1);
        lcd.setPixel(i-1,j-1);//Direction dependent(Up and Down)
        lcd.setPixel(i-2,j+1);
        lcd.setPixel(i-3,j+1);
        lcd.setPixel(i,j-2);//Direction dependent(Up and Down)
        lcd.setPixel(i+1,j-2);//Direction dependent(Up and Down)
        lcd.setPixel(i+2,j+2);
        lcd.setPixel(i-1,j-2);//Direction dependent(Up and Down)
        lcd.setPixel(i-2,j+2);
        lcd.setPixel(i-1,j-3);//Direction dependent(Up and Down)
        lcd.setPixel(i,j-3);//Direction dependent(Up and Down)
        lcd.setPixel(i+1,j-3);//Direction dependent(Up and Down)
        lcd.setPixel(i-2,j-1);
        lcd.setPixel(i-3,j-1);
        lcd.setPixel(i+3,j-1);
        lcd.setPixel(i+2,j-1);
        lcd.setPixel(i+2,j-2);
        lcd.setPixel(i-2,j-2);


    } else if(joystick.direction == UP) {
        lcd.setPixel(i,j);
        lcd.setPixel(i-1,j);//Direction dependent (left and right)
        lcd.setPixel(i-2,j);//Direction dependent (left and right)
        lcd.setPixel(i-3,j);//Direction dependent (left and right)
        lcd.setPixel(i,j+1);
        lcd.setPixel(i,j+2);
        lcd.setPixel(i,j+3);
        lcd.setPixel(i,j-1);
        lcd.setPixel(i,j-2);
        lcd.setPixel(i,j-3);
        lcd.setPixel(i-1,j+3);
        lcd.setPixel(i+1,j+3);
        lcd.setPixel(i,j-1);
        lcd.setPixel(i-2,j+2);
        lcd.setPixel(i-1,j+2);
        lcd.setPixel(i+2,j+2);
        lcd.setPixel(i+1,j+2);
        lcd.setPixel(i-1,j+1);//Direction dependent (left and right)
        lcd.setPixel(i-2,j+1);//Direction dependent (left and right)
        lcd.setPixel(i-3,j+1);//Direction dependent (left and right)
        lcd.setPixel(i-1,j-1);//Direction dependent (left and right)
        lcd.setPixel(i-2,j-1);//Direction dependent (left and right)
        lcd.setPixel(i-3,j-1);//Direction dependent (left and right)
        lcd.setPixel(i-1,j-2);
        lcd.setPixel(i-2,j-2);
        lcd.setPixel(i+1,j-2);
        lcd.setPixel(i+2,j-2);
        lcd.setPixel(i+1,j-3);
        lcd.setPixel(i-1,j-3);

    } else if (joystick.direction == DOWN) {
        lcd.setPixel(i,j);
        lcd.setPixel(i,j+1);
        lcd.setPixel(i,j+2);
        lcd.setPixel(i,j+3);
        lcd.setPixel(i,j-1);
        lcd.setPixel(i,j-2);
        lcd.setPixel(i,j-3);
        lcd.setPixel(i-1,j+3);
        lcd.setPixel(i+1,j+3);
        lcd.setPixel(i,j-1);
        lcd.setPixel(i-2,j+2);
        lcd.setPixel(i-1,j+2);
        lcd.setPixel(i+2,j+2);
        lcd.setPixel(i+1,j+2);
        lcd.setPixel(i-1,j-2);
        lcd.setPixel(i-2,j-2);
        lcd.setPixel(i+1,j-2);
        lcd.setPixel(i+2,j-2);
        lcd.setPixel(i+1,j-3);
        lcd.setPixel(i-1,j-3);
        lcd.setPixel(i+1,j);//Direction dependent(left and right)
        lcd.setPixel(i+2,j);//Direction dependent(left and right)
        lcd.setPixel(i+3,j);//Direction dependent (left and right)
        lcd.setPixel(i+1,j+1);//Direction dependent (left and right)
        lcd.setPixel(i+2,j+1);//Direction dependent (left and right)
        lcd.setPixel(i+3,j+1);//Direction dependent (left and right)
        lcd.setPixel(i+1,j-1);//Direction dependent (left and right)
        lcd.setPixel(i+2,j-1);//Direction dependent (left and right)
        lcd.setPixel(i+3,j-1);//Direction dependent (left and right)



    } else {
        lcd.setPixel(i,j);
        lcd.setPixel(i-1,j);//Direction dependent (left and right)
        lcd.setPixel(i-2,j);//Direction dependent (left and right)
        lcd.setPixel(i-3,j);//Direction dependent (left and right)
        lcd.setPixel(i,j+1);
        lcd.setPixel(i,j+2);
        lcd.setPixel(i,j+3);
        lcd.setPixel(i,j-1);
        lcd.setPixel(i,j-2);
        lcd.setPixel(i,j-3);
        lcd.setPixel(i-1,j+3);
        lcd.setPixel(i+1,j+3);
        lcd.setPixel(i,j-1);
        lcd.setPixel(i-2,j+2);
        lcd.setPixel(i-1,j+2);
        lcd.setPixel(i+2,j+2);
        lcd.setPixel(i+1,j+2);
        lcd.setPixel(i-1,j+1);//Direction dependent (left and right)
        lcd.setPixel(i-2,j+1);//Direction dependent (left and right)
        lcd.setPixel(i-3,j+1);//Direction dependent (left and right)
        lcd.setPixel(i-1,j-1);//Direction dependent (left and right)
        lcd.setPixel(i-2,j-1);//Direction dependent (left and right)
        lcd.setPixel(i-3,j-1);//Direction dependent (left and right)
        lcd.setPixel(i-1,j-2);
        lcd.setPixel(i-2,j-2);
        lcd.setPixel(i+1,j-2);
        lcd.setPixel(i+2,j-2);
        lcd.setPixel(i+1,j-3);
        lcd.setPixel(i-1,j-3);
    }
}
void drawGhost()
{
    lcd.setPixel(x,y);
    lcd.setPixel(x+2,y);
    lcd.setPixel(x-2,y);
    lcd.setPixel(x,y+1);
    lcd.setPixel(x,y-1);
    lcd.setPixel(x-1,y-1);
    lcd.setPixel(x-2,y-1);
    lcd.setPixel(x+1,y-1);
    lcd.setPixel(x+2,y-1);
    lcd.setPixel(x+2,y+1);
    lcd.setPixel(x+1,y+1);
    lcd.setPixel(x-1,y+1);
    lcd.setPixel(x-2,y+1);
    lcd.setPixel(x+2,y+2);
    lcd.setPixel(x-1,y+2);
    lcd.setPixel(x+1,y+2);
    lcd.setPixel(x+2,y-2);
    lcd.setPixel(x-1,y-2);
    lcd.setPixel(x+1,y-2);
    lcd.setPixel(x-2,y-2);
    lcd.setPixel(x-2,y+2);
}
void drawPacman()
{
    if(joystick.direction == RIGHT) {
        lcd.setPixel(i,j);
        lcd.setPixel(i-1,j);//Direction dependent (left and right)
        lcd.setPixel(i-2,j);//Direction dependent (left and right)
        lcd.setPixel(i-3,j);//Direction dependent (left and right)
        lcd.setPixel(i,j+1);
        lcd.setPixel(i,j+2);
        lcd.setPixel(i,j+3);
        lcd.setPixel(i,j-1);
        lcd.setPixel(i,j-2);
        lcd.setPixel(i,j-3);
        lcd.setPixel(i-1,j+3);
        lcd.setPixel(i+1,j+3);
        lcd.setPixel(i,j-1);
        lcd.setPixel(i-2,j+2);
        lcd.setPixel(i-1,j+2);
        lcd.setPixel(i+2,j+2);
        lcd.setPixel(i+1,j+2);
        lcd.setPixel(i-1,j+1);//Direction dependent (left and right)
        lcd.setPixel(i-2,j+1);//Direction dependent (left and right)
        lcd.setPixel(i-3,j+1);//Direction dependent (left and right)
        lcd.setPixel(i-1,j-1);//Direction dependent (left and right)
        lcd.setPixel(i-2,j-1);//Direction dependent (left and right)
        lcd.setPixel(i-3,j-1);//Direction dependent (left and right)
        lcd.setPixel(i-1,j-2);
        lcd.setPixel(i-2,j-2);
        lcd.setPixel(i+1,j-2);
        lcd.setPixel(i+2,j-2);
        lcd.setPixel(i+1,j-3);
        lcd.setPixel(i-1,j-3);


    }   else if(joystick.direction == LEFT) {
        lcd.setPixel(i,j);
        lcd.setPixel(i,j+1);
        lcd.setPixel(i,j+2);
        lcd.setPixel(i,j+3);
        lcd.setPixel(i,j-1);
        lcd.setPixel(i,j-2);
        lcd.setPixel(i,j-3);
        lcd.setPixel(i-1,j+3);
        lcd.setPixel(i+1,j+3);
        lcd.setPixel(i,j-1);
        lcd.setPixel(i-2,j+2);
        lcd.setPixel(i-1,j+2);
        lcd.setPixel(i+2,j+2);
        lcd.setPixel(i+1,j+2);
        lcd.setPixel(i-1,j-2);
        lcd.setPixel(i-2,j-2);
        lcd.setPixel(i+1,j-2);
        lcd.setPixel(i+2,j-2);
        lcd.setPixel(i+1,j-3);
        lcd.setPixel(i-1,j-3);
        lcd.setPixel(i+1,j);//Direction dependent(left and right)
        lcd.setPixel(i+2,j);//Direction dependent(left and right)
        lcd.setPixel(i+3,j);//Direction dependent (left and right)
        lcd.setPixel(i+1,j+1);//Direction dependent (left and right)
        lcd.setPixel(i+2,j+1);//Direction dependent (left and right)
        lcd.setPixel(i+3,j+1);//Direction dependent (left and right)
        lcd.setPixel(i+1,j-1);//Direction dependent (left and right)
        lcd.setPixel(i+2,j-1);//Direction dependent (left and right)
        lcd.setPixel(i+3,j-1);//Direction dependent (left and right)

    } else if(joystick.direction == UP) {
        lcd.setPixel(i,j);
        lcd.setPixel(i+1,j);
        lcd.setPixel(i+2,j);
        lcd.setPixel(i+3,j);
        lcd.setPixel(i-1,j);
        lcd.setPixel(i-2,j);
        lcd.setPixel(i-3,j);
        lcd.setPixel(i,j+1);//Direction dependent(Up and Down)
        lcd.setPixel(i+1,j+1);//Direction dependent(Up and Down)
        lcd.setPixel(i+2,j+1);
        lcd.setPixel(i+3,j+1);
        lcd.setPixel(i-1,j+1);//Direction dependent(Up and Down)
        lcd.setPixel(i-2,j+1);
        lcd.setPixel(i-3,j+1);
        lcd.setPixel(i,j+2);//Direction dependent(Up and Down)
        lcd.setPixel(i+1,j+2);//Direction dependent(Up and Down)
        lcd.setPixel(i+2,j+2);
        lcd.setPixel(i-1,j+2);//Direction dependent(Up and Down)
        lcd.setPixel(i-2,j+2);
        lcd.setPixel(i-1,j+3);//Direction dependent(Up and Down)
        lcd.setPixel(i,j+3);//Direction dependent(Up and Down)
        lcd.setPixel(i+1,j+3);//Direction dependent(Up and Down)
        lcd.setPixel(i-2,j-1);
        lcd.setPixel(i-3,j-1);
        lcd.setPixel(i+3,j-1);
        lcd.setPixel(i+2,j-1);
        lcd.setPixel(i+2,j-2);
        lcd.setPixel(i-2,j-2);


    } else if (joystick.direction == DOWN) {
        lcd.setPixel(i,j);
        lcd.setPixel(i+1,j);
        lcd.setPixel(i+2,j);
        lcd.setPixel(i+3,j);
        lcd.setPixel(i-1,j);
        lcd.setPixel(i-2,j);
        lcd.setPixel(i-3,j);
        lcd.setPixel(i,j-1);//Direction dependent(Up and Down)
        lcd.setPixel(i+1,j-1);//Direction dependent(Up and Down)
        lcd.setPixel(i+2,j+1);
        lcd.setPixel(i+3,j+1);
        lcd.setPixel(i-1,j-1);//Direction dependent(Up and Down)
        lcd.setPixel(i-2,j+1);
        lcd.setPixel(i-3,j+1);
        lcd.setPixel(i,j-2);//Direction dependent(Up and Down)
        lcd.setPixel(i+1,j-2);//Direction dependent(Up and Down)
        lcd.setPixel(i+2,j+2);
        lcd.setPixel(i-1,j-2);//Direction dependent(Up and Down)
        lcd.setPixel(i-2,j+2);
        lcd.setPixel(i-1,j-3);//Direction dependent(Up and Down)
        lcd.setPixel(i,j-3);//Direction dependent(Up and Down)
        lcd.setPixel(i+1,j-3);//Direction dependent(Up and Down)
        lcd.setPixel(i-2,j-1);
        lcd.setPixel(i-3,j-1);
        lcd.setPixel(i+3,j-1);
        lcd.setPixel(i+2,j-1);
        lcd.setPixel(i+2,j-2);
        lcd.setPixel(i-2,j-2);

    } else {
        lcd.setPixel(i,j);
        lcd.setPixel(i-1,j);//Direction dependent (left and right)
        lcd.setPixel(i-2,j);//Direction dependent (left and right)
        lcd.setPixel(i-3,j);//Direction dependent (left and right)
        lcd.setPixel(i,j+1);
        lcd.setPixel(i,j+2);
        lcd.setPixel(i,j+3);
        lcd.setPixel(i,j-1);
        lcd.setPixel(i,j-2);
        lcd.setPixel(i,j-3);
        lcd.setPixel(i-1,j+3);
        lcd.setPixel(i+1,j+3);
        lcd.setPixel(i,j-1);
        lcd.setPixel(i-2,j+2);
        lcd.setPixel(i-1,j+2);
        lcd.setPixel(i+2,j+2);
        lcd.setPixel(i+1,j+2);
        lcd.setPixel(i-1,j+1);//Direction dependent (left and right)
        lcd.setPixel(i-2,j+1);//Direction dependent (left and right)
        lcd.setPixel(i-3,j+1);//Direction dependent (left and right)
        lcd.setPixel(i-1,j-1);//Direction dependent (left and right)
        lcd.setPixel(i-2,j-1);//Direction dependent (left and right)
        lcd.setPixel(i-3,j-1);//Direction dependent (left and right)
        lcd.setPixel(i-1,j-2);
        lcd.setPixel(i-2,j-2);
        lcd.setPixel(i+1,j-2);
        lcd.setPixel(i+2,j-2);
        lcd.setPixel(i+1,j-3);
        lcd.setPixel(i-1,j-3);
    }
}

void pressStart()  // ISR to Start game
{

    buttonflag1++;
}

void WastedMode()
{

    if (joystick.direction == UP) {
        i++;
    }
    if (joystick.direction == DOWN) {
        i--;
    }
    if (joystick.direction == LEFT) {
        j++;
    }
    if (joystick.direction == RIGHT) {
        j--;
    }
}
void startscreen()
{
    lcd.printString("Welcome to",15,1);
    lcd.printString("Pacman",20,2);
    lcd.printString("Press Start",6,3);
    button.rise(&pressStart); // event generated on rising edge
    PWM1.period_us(25);// Set time period
    if(buttonflag1==1) {
        lcd.clear();
        lcd.printString("Ready",21,2);
        PWM1 = 0.0;//Duty Cycle of Green pin
        PWM2 = 0.0;//Duty cycle of Yellow pin
        PWM3 = 0.5;//Duty Cycle of Red pin
        wait(1.0) ;
        lcd.clear();
        lcd.printString("Set",23,2);
        PWM1 = 0.5;//Duty Cycle of Yellow pin
        PWM2 = 0.0;//Duty cycle of Grren pin
        PWM3 = 0.0;//Duty Cycle of Red pin
        wait(1.0);
        lcd.clear();
        lcd.printString("Go!",23,2);
        PWM1 = 0.0;//Duty Cycle of Yellow pin
        PWM2 = 0.5;//Duty cycle of Green pin
        PWM3 = 0.0;//Duty Cycle of Red pin
        wait(1.0);
        lcd.clear();
        lcd.refresh();
        drawMap();
        buttonflag1++;
    }
    if(buttonflag1==0) {
        startscreen();
    }
}
void WastedCheck()
{

    if(w<=8) {
        WastedMode();
        drawPacman2();
    } else {
        Joystickcheck();
        drawPacman();
    }
}
void drawMap()
{

    lcd.drawRect(39,0,3,10,1);//x-coordinate (top-left),y-coordinate(top-left), width, height, fill - 0 transparent (w/outline), 1 filled black, 2 filled white (wo/outline)
    lcd.drawRect(40,40,2,7,1);// T-shaped obstacle Vertical
    lcd.drawRect(7,8,23,2,1);// Left hand "Hook" shaped obstacle horizontal
    lcd.drawRect(51,8,24,2,1);//Right hand "Hook" shaped obstacle horizontal
    lcd.drawRect(0,18,3,29,1);// left hand border
    lcd.drawRect(78,18,5,29,1);// Right hand border
    lcd.drawRect(11,18,3,21,1);//Left hand C shape obstacle vertical
    lcd.drawRect(27,11,3,18,1);// Left hand "Hook" shaped obstacle vertical
    lcd.drawRect(35,37,12,2,1);//T-shaped obstacle Horizontal
    lcd.drawRect(67,18,3,21,1);// Right hand C shaped obstacle vertical
    lcd.drawRect(51,11,3,18,1);//Right hand "Hook" shaped obstacle vertical
    lcd.drawRect(38,18,5,11,1);// Central block
    lcd.drawRect(15,18,4,2,1);//Left hand C shape obstacle horizontal
    lcd.drawRect(22,27,5,2,1);//Left hand "Hook" shaped obstacle
    lcd.drawRect(15,37,4,2,1);//Left hand C shape obstacle
    lcd.drawRect(55,27,3,2,1);// Right hand "Hook" shaped obstacle
    lcd.drawRect(63,18,4,2,1);//Right hand C shape obstacle horizontal
    lcd.drawRect(63,37,4,2,1);//Right hand C shape obstacle

}

void checkRight()
{


    int r = 0;//Variable for right movement check
    if(lcd.getPixel (i+3,j))//Check 4 pixels to the right
        r++;
    if(lcd.getPixel (i+4,j))//Check 5 pixels to the right
        r++;
    if (r==2) { // Condition for solid obstacles
        i--;

    }
}
void checkLeft()
{
    int l = 0 ; // Variable for left movement check
    if(lcd.getPixel (i-3,j))//Check 4 pixels to the left
        l++;
    if(lcd.getPixel (i-4,j))//Check 5 pixels to the left
        l++;
    if (l==2) { // Condition for solid obstacles
        i++;


    }
}
void checkUp()
{
    int u=0;
    if(lcd.getPixel (i,j-3))//Check 4 pixels above
        u++;
    if(lcd.getPixel (i,j-4))//Check 5 pixels above
        u++;
    if(lcd.getPixel (i+1,j-4))
        u++;
    if(lcd.getPixel (i-1,j-4))
        u++;
    if(lcd.getPixel (i-2,j-4))
        u++;
    if (u>=4) { // Condition for solid obstacles
        j++;
    }
}
void checkDown()
{
    int d=0;
    if(lcd.getPixel (i,j+3))//Check 4 pixels below
        d++;
    if(lcd.getPixel (i,j+4))//Check 5 pixels below
        d++;
    if(lcd.getPixel (i+1,j+4))
        d++;
    if(lcd.getPixel (i-1,j+4))
        d++;
    if(lcd.getPixel (i-2,j+4))
        d++;
    if (d>=4) { // Condition for solid obstacles
        j--;
    }
}
void drawCoin(void)
{
    for (int k=0; k<28; k++) {
        lcd.drawCircle(coins[k][0], coins[k][1],2,0);
    }
}
void checkCoin()
{
    for (int c=0; c<28; c++) {
        if(i==coins[c][0]&& j==coins[c][1]) {
            coins[c][0]=90;
            coins[c][1]=50;
           
            w--;
        }
    }
}
void Joystickcheck()
{
    if (joystick.direction == UP) {
        j--;
    }
    if (joystick.direction == DOWN) {
        j++;
    }
    if (joystick.direction == LEFT) {
        i--;
    }
    if (joystick.direction == RIGHT) {
        i++;
    }

}
void Boundarycheck()   // Set boundary conditions so that ghost and pacman cannot move off screen
{
    if (i<3) {
        i=3;
    }
    if (j<3) {
        j=3;
    }
    if (j>44) {
        j=44;
    }
    if (i>80) {
        i=80;
    }
}
void winningcondition()   // Player wins if all coins are eaten
{
    if(w==0) {
        win=true;
    }
}

void losingcondition()   //Player loses if pacman is eaten by ghost
{
    if (i==x && j==y) {
        win = false;
        lose = true;
    }
}

void writeScore()
{

    FILE* fp = fopen("/local/pacmanScore.txt","w"); // open file
    fprintf(fp,"%i",e); // print string to file
    fclose(fp); // close file
}

void readScore()
{
    FILE* File2 = fopen ("/local/pacmanScore.txt","r"); // open file for reading

    fscanf(File2,"%i",&score1);
    sprintf(buffer1,"%i",score1);
    fclose(File2); // close file

    //lcd.printString(buffer1,10,0); // display read data value
}
void compareScore()
{
    readScore();
    if(e>=score1) {

        lcd.printString("Yay!!",25,0);
        lcd.printString("New High Score",0,1);
        writeScore();
        readScore();
        lcd.printString(buffer1,25,4);
    }
    if (e<score1) {
        sprintf(buffer,"Score=%i",e);
        readScore();
        lcd.printString("High Score=",0,0);
        lcd.printString(buffer1,0,1); // display read data value
        lcd.printString("Your",0,3);
        lcd.printString(buffer,0,4);
    }
}
int main()
{

    lcd.init();
    calibrateJoystick();  // get centred values of joystick
    pollJoystick.attach(&updateJoystick,1.0/10.0);  // read joystick 10 times per second
    PHY_PowerDown();
    ghost.attach(&ghosttimerexpired,0.2);
    score.attach(&scoreexpired,1.0);
    tune();
    while(win==false&& lose==false) {
        startscreen();
        lcd.setBrightness(bright);
        lcd.clear();
        pause();
        winningcondition();
        losingcondition();
        drawMap();
        drawCoin();
        drawGhost();
        checkRight();
        checkLeft();
        checkDown();
        checkUp();
        Boundarycheck();
        WastedCheck();
        checkCoin();
        if (followflag) {
            followflag=0;
            ghostfollow();
        }
        if (scoreflag) {
            scoreflag=0;
            e--;
        }
        lcd.refresh();
        wait_ms(35);

    }
    if (win==true) {
        lcd.setBrightness(bright);
        lcd.clear();
        lcd.printString("Well Done!", 25,21);
        tune();
        lcd.clear();
        compareScore();
        wait(5.0);
        lcd.clear();
        creditscreen();
    }
    if (lose==true) {
        lcd.setBrightness(bright);
        lcd.clear();
        lcd.printString("Game Over",10,3);
        tune();
        lcd.clear();
        creditscreen();
    }
}


