/**
@file main.h
@brief Header file containing functions prototypes, defines and global variables.
@see "Pacman" by Shawn Rigdon
@see "Joystick" by Craig Evans
@brief Revision 1.0.
@author Konlatee Sittichaivijit
@date   April 2015
*/

#ifndef MAIN_H
#define MAIN_H
#include "mbed.h"
#include "N5110.h"
#define DIRECTION_TOLERANCE 0.2// Tolerance of Joystick 
#include "tone.h"
#define PI 3.14159265359
#include "PowerControl/PowerControl.h"
#include "PowerControl/EthernetPowerControl.h"


/**
@namespace LocalFileSystem local("local")
@brief Creates a local file on the flash memory of the mbed for high score storage
*/

LocalFileSystem local("local"); // define local file system
/**
@namespace PWM3
@brief Red LED
*/


PwmOut PWM3(p24);//Red LED
/**
@namespace PWM2
@brief Green LED
*/

PwmOut PWM2(p22);//Green LED

/**
@namespace PWM1
@brief yellow LED
*/



PwmOut PWM1(p23); //Yellow LED
/**
@namespace buzzer
@brief Piezo buzzer to output game music
*/
PwmOut buzzer(p25);

/**Starting "i" coordinate for pacman*/
int i=3;
/**Starting "j" coordinate for pacman*/
int j = 3;
/**Flag for Start button*/
int buttonflag=0;
/**
@namespace bright
@brief Potentiometer For LCD brightness adjustment
*/
AnalogIn bright(p20);
/**
@namespace timer
@brief Timeout object to put mbed into sleep mode and turn off lcd after a period of inactivity
*/
Timeout timer; //Create timeout object
/**
@namespace Jbutton
@brief Joystick button for pausing game
*/
InterruptIn Jbutton(p17);// Joystick Button
/**
@namespace xPot
@brief Joystick x-direction adjustment
*/
AnalogIn xPot(p15);// Joystick x-direction
/**
@namespace yPot
@brief Joystick y-direction adjustment
*/
AnalogIn yPot(p16);// Joystick y-direction
/**
@namespace button
@brief Button to start game
*/
InterruptIn button(p18);//Pause button
/**
@namespace pollJoystick
@brief Ticker object to regularly read the joystick
*/

Ticker pollJoystick; // timer to regularly read the joystick
/**
@namespace score
@brief Ticker object to count score
*/

Ticker score;// ticker object to count the score
/**
@namespace ghost
@brief Ticker object to regularly update the ghost
*/



Ticker ghost;// Ticker object to update ghost



/**Flag for pause button*/

int buttonflag1=0;
/**Flag for ghost movement*/
int followflag=0;// flag for ghost to follow pacman

/**Buffer to print new player score*/

char buffer[14];// buffer for printing latest player score
/**Buffer to print high score*/
char buffer1[14];// buffer for printing high score
/**int for starting score, decreases every 1 second */
int e =1000;// Starting score, decreases by 1 every second
/**int to store highscore*/
int score1;// int for high score

/**Flag for updating score */
int scoreflag=0;// flag for score function
/** @namespace N5110lcd
    @brief Create a N5110 object connected to the specified pins
    */
N5110 lcd(p7,p8,p9,p10,p11,p13,p26); //PWR, SCE, RST, DC, MOSI, SCLK, LED
/** Boolean Variable for winning condition
    */
volatile bool win=false;
/** Boolean Variable for losing condition
    */
volatile bool lose= false;
/** Starting "i" coordinate for ghost
    */

int x=67; // Ghost starting position
/** Starting "j" coordinate for ghost
    */
int y = 44;
/** Flag for timeout object
    */
int timerflag=0;// flag for timeout function
/** Variable for starting number of coins, if this variable reaches 0, the user wins the game
    */
int w=28;// winning condition variable



/** An array for beat of music notes
    */



float beat[]= {0.5,0.5,0.5,0.5,0.5,1,1,0.5,0.5,0.5,0.5,0.5,1,1,0.5,0.5,0.5,0.5,0.5,1,1,0.25,0.5,0.25,0.25,0.5,0.25,0.25,0.5,1,1,1}; //beat arrayfor pacman soundtrack

/** An array for frequency of music notes
    */



float frequency[]= {494,494,988,988,740,622,988,587,622,440,1047,784,659,1047,784,659,494,988,740,622,988,587,622,659,698,698,740,784,784,831,880,988}; //frequency array for pacman soundtrack
/** An array indicating the location of each coin
    */
int coins[28][2] = { // array for location of coins
    {10,3},{22,3},{35,3},{47,3},{65,3},{80,3},
    {41,14},
    {3,13},{13,15},{65,15},{80,14},
    {7,24},{18,24},{34,24},{47,24},{62,24},{74,24},
    {7,33},{23,34},{41,33},{61,34},{74,33},
    {7,44},{21,44},{35,44},{47,44},{61,44},{74,44}
};
/** Enumerated type for direction
    */
enum DirectionName { // create enumerated type (0,1,2,3 etc. for direction)
    UP,         // could be extended for diagonals etc.
    DOWN,
    LEFT,
    RIGHT,
    CENTRE,
    UNKNOWN
};
/** Creates a type definition struct for the joystick
    */


typedef struct JoyStick Joystick; // struct for Joystick





/** Creates a  struct object for the joystick
    */

struct JoyStick {
    float x;    // current x value
    float x0;   // 'centred' x value
    float y;    // current y value
    float y0;   // 'centred' y value
    int button; // button state (assume pull-down used, so 1 = pressed, 0 = unpressed)
    DirectionName direction;  // current direction
};

/** Create struct variable
    */

Joystick joystick; // create struct variable
/** Credit screen to be displayed at end of game
    */
void  creditscreen();
/** Outputs pacman sountrack
    @param q - integer to store which note is playing
    */
void tune();
/** Compares repsective position of ghost and pacman, and the ghost chases pacman
    @param y - Current y-position of the ghost
    @param x - Current x-position of the ghost
    @param j - Current y-position of the pacman
    @param i - Current x-position of the pacman

    */

void ghostfollow();
/** Set  the scoreflag
    @param scoreflag - flag to be set for updating score

    */


void scoreexpired();
/** Set  the followflag
    @param followflag - flag to be set for updating the ghost

    */
void ghosttimerexpired();

/** Defaults the current position of the joystick
    @param xPot - Current x-position of the joystick
    @param yPot - Current y-position of the joystick
    @param joystick.x0 - Defaulted position of xPot
    @param joystick.y0 - Defaulted position of yPot
    @param button.mode(PullDown)- Define mode of joystci button
    */
void calibrateJoystick();
/** Reads current position of joystick and compare it to the defaulted values
    @param joystick.x - Read current position of joystick in x-axis
    @param joystick.y - Read current position of joystick in x-axis
    @param joystick.button- Reads current state of  joystick button
    @param joystick.direction- Defines the direction of joystick
    */
void updateJoystick();
/** Moves the player in the direction of the joystick

    */


void Joystickcheck();
/** Sets the timerflag
    @param timerflag - flag to be set

    */

void timerExpired();
/** Set or reset the buttonflag
    @param buttonflag - flag to be set

    */

void pressPause();
/** Pauses the game if button is pressed
    Takes user to pause screen
    After 15 seconds of inactivity in the pause screen, the mbed enters sleep mode and lcd powers down
    Press the pause button to wake the device back up


    */
void pause();
/** Draws Map
    Obstacles are drawn using the drawRect function
    */
void drawMap();


/** Function to draw pacman during wasted mode, and ensures he faces the direction of travel
    All relevant pixels set with reference to "i" and "j"
    @param i-location of centre of pacman
    @param j-location of centre of pacman

    */

void drawPacman2();
/** Check to see if there are any obstacles to the right of the player
    Each pixel found to the right adds 1 to r
    If there are more than a set number of pixels, player cannot move further in that direction
    @param r - variable to count the number of pixels to the right


    */


void checkRight();
/** Check to see if there are any obstacles to the left of the player
    Each pixel found to the right adds 1 to l
    If there are more than a set number of pixels, player cannot move further in that direction
    @param l - variable to count the number of pixels to the left


    */
void checkLeft();
/** Check to see if there are any obstacles above  the player
    Each pixel found to the right adds 1 to u
    If there are more than a set number of pixels, player cannot move further in that direction
    @param u - variable to count the number of pixels above


    */


void checkUp();
/** Check to see if there are any obstacles below  the player
    Each pixel found to the right adds 1 to d
    If there are more than a set number of pixels, player cannot move further in that direction
    @param d - variable to count the number of pixels below
    */
void checkDown();
/** Function to draw coins in the locations specified in the coin array

    @param k - integer to count the number of coins drawn
    */


void drawCoin(void);
/** Function to check whether coins have been eaten
    If so, the coin disappears, and 1 is subtracted from "w"

    @param w - integer to count the number of coins uneaten
    */



void checkCoin();
/** Function to draw pacman, and ensures he faces the direction of travel
    All relevant pixels set with reference to "i" and "j"
    @param i-location of centre of pacman
    @param j-location of centre of pacman

    */


void drawPacman();
/** Function to draw ghost
    All relevant pixels set with reference to "x" and "y"
    @param x-location of centre of ghost
    @param y-location of centre of ghost

    */


void drawGhost();
/** Ensures that player cannot move off screen


    */


void Boundarycheck();
/** Checks if all coins have been eaten



    */


void winningcondition();
/** Checks if ghost has eaten pacman



    */



void losingcondition();

/** Adds 1 to buttonflag1

    @param buttonflag1 - flag for direction start button
*/
void pressStart();

/** Moves player in opposite way to joystick direction


*/


void Wastedmode();
/** Check to see whethert the direction swap button has been pressed
    If so, pacman will start moving in opposite direction to joystick
    If not pacman continues to move in direction of joystick


*/

void WastedCheck();

/** Displayes start screen
    Remain in start screen until start button is pressed
    LEDs light up as count down towards start of game
    @param buttonflag1 - flag for direction start button


*/



void startscreen();



/** Open local file "/local/pacmanScore.txt","w"
    Overwrites high score with current score
    @param e - Current score

*/
void writeScore();
/** Open local file "/local/pacmanScore.txt","w"
    Reads stored high score
    Stores read score in buffer
     @param score1 - Previously stored high score
      @param buffer1 - buffer to store high score that was read off flash memory

*/
void readScore();
/** Compares new score to high score
   If new score is higher than stored highscore, overwrite new score
   If new score is lower that stored highscore, display both scores
    @param score1 - Previously stored high score
     @param buffer1 - buffer to store high score that was read off flash memory
  @param buffer - buffer to store new score
  @param e - Current score
*/



void compareScore();
#endif