/**
@file   main.h
@brief  Header file containing functions prototypes, defines and global variables.
@brief  Distance Sensor Project
@brief  ELEC 2645
@author James A. Robinson
@date   March 2015
*/

#include "SRF02.h"
#include "N5110.h"
#include "PowerControl/PowerControl.h"
#include "PowerControl/EthernetPowerControl.h"
#define USR_POWERDOWN (0x104)

int semihost_powerdown() /*!<definition of powerdown function */
{
    uint32_t arg;
    return __semihost(USR_POWERDOWN, &arg);
}

//I/O

/**  
@namespace leds
@brief bus output for the LED's
*/
BusOut leds(LED4,LED3,LED2,LED1);

/**  
@namespace lcd
@brief outputs for the N5110 lcd display
@breif lcd (VCC,SCE,RST,D/C,MOSI,SCLK,LED)
*/
N5110 lcd(p7,p8,p9,p10,p11,p13,p26);

/**  
@namespace serial
@brief serial I/O for serial printing over usb
*/
Serial serial(USBTX,USBRX);

SRF02 sensor(p28,p27);//SDA,SCL
Ticker timer; // timer


InterruptIn P17(p17); //button MODE
InterruptIn P16(p16); //button LOG
PwmOut P21(p21); //output BUZZER
PwmOut P26(p26); //output BACKLIGHT
AnalogIn P19(p19); //potentiometer VOLUME
AnalogIn P20(p20); //potentiometer BACKLIGHT

 //flags/variables

int timerflag = 0; /*!<initialise timer flag to 0*/
int setTimeFlag = 0; /*!<initialise setTime flag to 0*/
int MFlag=0; /*!<initialise Mflag to 0*/
int M=0; /*!<initialise variable M to 0*/
int LogFlag=0; /*!<initialise LogFlag to 0*/

char rxString[16]; /*!<buffer to store received string */
char* buffer;/*!<buffer to store data and time string*/
int distance;/*!<variable to store average distance measurment */
const char* PrintDistance;/*!<buffer to store diatance string for LCD printing */


//functions

/**
\This function reads the distance value and sets an integer ten times, before taking 
the sum(dt) and dividing by 10 to get an average returning distance for use within 
other functions. This was done to reduce the impact of noise on the returned value.
@param a - int d0
@param b - int d1
@param c - int d2
@param d - int d3
@param e - int d4
@param f - int d5
@param g - int d6
@param h - int d7
@param i - int d8
@param j - int d9
@param k - int dt (sum of d0:d9)
@param l - distance
@returns distance the average of dt
*/
void GetDistance();

/**
\This function reads the backlight potentiometer (P20) and using this value sets the 
pwm output to the lcd backlight (P26) as the inverse, this varies the brightness of 
the lcd display.
@param a - P20
@param b - P26
*/
void backlight();

/**
\This function reads the volume potentiometer (P19) and sets a float to 1/5th of this 
value before adding this value to 0.8, then using it to set the pwm duty cycle output 
to the buzzer (P21). This function causes the volume of the buzzer to increase from 
silence to a loud audible alert.
@param a - P19
@param b - V
@param c - P21
*/
void volume();

/**
This function is called if MFlag=1, where MFlag=1 when MButtonPressed interrupt is 
called. The function firstly increments the value of M, then checks if the value is 
equal to 2, if so the value is set to 0, it is then checked if the value is equal to
 0 if so the lcd is set to normal mode, before finally checking if the value is equal
  to 1, if it does the lcd is set to inverse mode.
@param a - M
*/
void modeChange(); 

/**
\This function is called if the interupt P17.rise(&MButtonPressed) is activated, it
 sets the MFlag to 1 which causes the function modeChange() to be called in the main().
@param a - MFlag
*/
void MButtonPressed();

/**
\This function is called if the interrupt P16.rise(&LButtonPressed) is activated, 
this function sets LogFlag to be the inverse of its current value. If the value is 
equal to 1 this causes the function WriteDataToFile() to be called in the main. Also 
includes a short delay to prevent accidental switching.  
@param a - LogFlag
*/
void LButtonPressed();

/**
\This function is called when serial interrupts, this indicates that data has been 
received. The function then reads the received string into a buffer (rxString) for 
use in the function setTime().The SetTimeFlag is set to 1 which in turn causes the 
function setTime() to be called in the main.
@param a - SetTimeFlag
@param b - rxString
@author Dr Craig A. Evans (University Of Leeds)
*/
void serialISR();

/**
\This function is called as result of SetTimeFlag equalling 1, the function converts 
the string saved in a buffer(rxString) from the serialISR() function into an 
integer(time), this integer is then used to set the time.
@param a - rxString
@param b - time
@author Dr Craig A. Evans (University Of Leeds)
*/
void setTime();

/**
\This function is called when the timer.attach(&timerexpired,1) expires every 1 
seconds. The function sets the timerflag to 1, which in turn causes the code in 
the main while loop to be ran, if the timerflag does not equal 1 the while loop 
remains in the power saving mode "sleep".
@param a - timerflag
@author Dr Craig A. Evans (University Of Leeds)
*/
void timerexpired();

/**
This function is called in the main if LogFlag equals 1. The function opens the 
local file 'local', or if it does not exist it is created then opened, the data 
buffers for time/date and distance are then printed to this file, before closing.
The mbed leds are used as feedback to the user, at the start of the function the 
mbed led bus(leds) is set to 15, which turns all the leds on and at the end set 
to 0, which turns them all off again.
[writeDataToFile (time and date , distance)]
@param a - bufferdata
@param b - distancedata
@author Dr Craig A. Evans (University Of Leeds)
*/
void writeDataToFile(char* bufferdata,float distancedata);
 
