/**
@file main.cpp
@brief Program implementation
*/

#include "mbed.h"
#include "main.h"

int main()
{
// Initialise; pwm output,timers,interrupts,power saving functions,buffers
    P21.period(0.0005);

    timer.attach(&timerexpired,1); //attach ISR expiring every 1 second(s)
    serial.attach(&serialISR); //attach serial ISR
    LocalFileSystem local("local"); // create local filesystem
    P17.rise(&MButtonPressed);//interrupt for mode change
    P16.rise(&LButtonPressed);//interrupt for log change

    char buffer[30]; //buffer used to store time string
    char buf[10];//buffer used to store distance string

    PHY_PowerDown();
    //semihost_powerdown();

    //set_time(0);

    lcd.init();

    //lcd.printString("--  --  --  --",0,0);
    lcd.printString("DISTANCE",18,1);
    lcd.printString("SENSOR",24,2);
    //lcd.printString("  --  --  --  ",0,3);
    lcd.printString("James Robinson",0,4);
    lcd.printString("200775267",16,5);
    wait(3);

    lcd.clear();

    while(1) {

        if (timerflag) {
            timerflag = 0;

            backlight();
            GetDistance();

            time_t seconds = time(NULL); // get current time

            strftime(buffer, 30 , "%X %d/%m/%y", localtime(&seconds));
            //format time into a string (time and date)

            serial.printf("%s , Distance = %dcm\n",buffer,distance);//print over serial

            if (LogFlag==1) { //if flag log
                writeDataToFile(buffer,distance); //write to disk
                serial.printf("LOGGED\n");
            }

            if (setTimeFlag) { //if updated time has been sent
                setTimeFlag = 0; //clear flag
                setTime(); //update time
            }

            //printing to lcd
            lcd.clear();
            float A=distance*0.2;
            lcd.drawRect(0,0,84,A,1);

            sprintf(buf, "%dcm",distance); //function to convert int to string
            lcd.printString(buf,28,5);//print converted string
            lcd.refresh();

            if (MFlag) { //if flag change mode
                MFlag=0;
                modeChange();
            }

            if(distance<40) {
                volume();
            } else {
                P21=1;
            }
        }
        Sleep();
    }
}


//functions

void GetDistance()
{
    /// read sensor distance 10 times take an average, return distance
    int d0 = sensor.getDistanceCm();
    int d1 = sensor.getDistanceCm();
    int d2 = sensor.getDistanceCm();
    int d3 = sensor.getDistanceCm();
    int d4 = sensor.getDistanceCm();
    int d5 = sensor.getDistanceCm();
    int d6 = sensor.getDistanceCm();
    int d7 = sensor.getDistanceCm();
    int d8 = sensor.getDistanceCm();
    int d9 = sensor.getDistanceCm();
    int dt=d0+d1+d2+d3+d4+d5+d6+d7+d8+d9;
    distance=dt/10;
}

void MButtonPressed()
{
    MFlag=1;///flag for mode set to 1
}

void LButtonPressed()
{
    LogFlag=!LogFlag;///inverse flag
    serial.printf("LOG BUTTON PRESSED\n");
    wait(0.5);
}

void modeChange()
{
    M++;
    if (M==2) {
        M=0;
    }
    if (M==0) {
        lcd.normalMode();
        serial.printf("NORMAL MODE\n");
    } else if (M==1) {
        lcd.inverseMode();
        serial.printf("INVERSE MODE\n");
    } else {}
}

void backlight()
{
    P20.read(); ///check backlight potentiometer value
    P26=1-P20; ///adjust backlight pwm output according to the value
}

void volume()
{
    P19.read(); ///check volume potentiometer value
    float V=(P19/5); ///assign variable 1/5 of the read p19 value
    //serial.printf("%f\n",V);
    P21=(0.8+V);///adjust volume pwm output according to variable V value
    //serial.printf("%f\n",P21);
}

void setTime()
{
    serial.printf("set_time - %s",rxString);/// print time for debugging
    int time = atoi(rxString);/// atoi() converts a string to an integer
    set_time(time);/// update the time
}

void serialISR()
{
    serial.gets(rxString,16);/// when a serial interrupt occurs, read rx string into buffer
    setTimeFlag = 1;/// set flag
}


void writeDataToFile(char* bufferdata,float distancedata)
{
    leds = 15; /// turn on LEDs for feedback
    FILE *fp = fopen("/local/log.csv", "a"); /// open 'log.csv' for appending
    /// if the file doesn't exist it is created, if it exists, data is appended to the end
    fprintf(fp," %s , %f\n",bufferdata,distancedata); /// print string to file
    fclose(fp); /// close file
    leds = 0; /// turn off LEDs to signify file access has finished
}

void timerexpired ()
{
    timerflag=1;
}
