/**
@file tower.h
@brief Revision 1.0.
@author Daniel R. Tomlinson
@date   May 2015

@brief Header file - Contains Global Variables, Inputs/Outputs and Function prototypes. 
*/

///Alters tolerance of Joystick directions
#define DIRECTION_TOLERANCE 0.05
#include "ConfigFile.h"

/**
@namespace lcd
@brief Object of the N5110 class, allocates pins to the LCD screen
       (VCC, SCE, RST, D/C, MOSI, SCLK, LED).
*/
N5110 lcd(p7,p8,p9,p10,p11,p13,p22);//VCC, SCE, RST, D/C, MOSI, SCLK, LED - assign pins for LCD.


/**
@namespace local
@brief Local file system, used to create read/write file path within the Mbeds flash memory.
*/
LocalFileSystem local("local");

/**
@namespace cfg
@brief Object of the ConfigFile, used to create read/write file path within the Mbeds flash memory.
*/
ConfigFile cfg;

/**
@namespace serial
@brief Serial port out - Generic protocol used to send and receive data, used for debugging.
*/
Serial serial(USBTX, USBRX);

/**  
@namespace deBounce A
@brief Creates a minimum time span before buttonA is acknowledged; at intervals of 0.1 sec.
*/
Timer deBounce1;//for buttonA

/**  
@namespace deBounce B
@brief Creates a minimum time span before buttonB is acknowledged; at intervals of 0.1 sec.
*/
Timer deBounce2;//for buttonB

/**  
@namespace timerGame
@brief Calls the function, gameLoop(); at intervals of 0.1 sec.
*/
Ticker timerGame;//for game

/**  
@namespace timerA
@brief Calls the function, timerExpiredA(); at intervals of 0.1 sec.
*/
Ticker timerA;//for buttonA

/**
@namespace timerB
@brief Calls the function, timerExpiredB(); at intervals of 0.1 sec.
*/
Ticker timerB;//for buttonB

/**
@namespace pollJoystick
@brief Calls the function, updateJoystick(); at intervals of 1/10 seconds.
*/
Ticker pollJoystick;

/**
@namespace standby
@brief Calls the function, screenOff(); at intervals of 60 seconds.
*/
Ticker standby;

/**
@namespace buzzer
@brief Object of the beep class, allocates a pin to the Piezo buzzer.
*/
Beep buzzer(p21);

/**  
@namespace buttonA
@brief DigitalIn, allocates a pin to push button A.
*/
DigitalIn buttonA(p20);

/**  
@namespace buttonB
@brief DigitalIn, allocates a pin to push button B.
*/
DigitalIn buttonB(p19);

/**
@namespace ledA
@brief AnalgOut,allocates a pin to the Action LED.
*/
AnalogOut ledA(p18);//action LED

/**
@namespace ledP
@brief DigitalOut, allocates a pin to the Power LED.
*/
DigitalOut ledP(p24);//Power LED

/**
@namespace joyButton
@brief InterruptIn, allocates a pin to the Joy Stick button.
*/
InterruptIn joyButton(p17);//Interrupt for ISR

/**
@namespace xpot
@brief AnalogIn, allocates a pin to xPot.
*/
AnalogIn xPot(p15);//left/right

/**
@namespace ypot
@brief AnalogIn, allocates a pin to yPot.
*/
AnalogIn yPot(p16);//up/down

//Globabl Variables

//sound FX toggle
int FX = 0;/*!< Toggle for Sound FX. */

//previous Direction
//stops continuous scrolling on some features
int preDirection;/*!< Used to stop continuous scrolling. */

//timer flags to check state of the buttons
int buttonFlagA = 0;/*!< Button flag set for ISR when state of buttonA changes. */
int buttonFlagB = 0;/*!< Button flag set for ISR when state of buttonB changes. */

//flag for game loop
int gameFlag = 0;/*!< Button flag set for ISR when game has started. */

//flag for joystick reading
int printFlag = 0;/*!< Print flag set for ISR when Joystick is moved. */

//boundary conditions
int cells [84][48];/*!< Boundary conditions for cells.*/

//real time score
int score = 0;/*!< Integer to show and print Scores. */

//stored high score variables
int highScore1;/*!< Integer to store Score 1. */
int highScore2;/*!< Integer to store Score 2. */
int highScore3;/*!< Integer to store Score 3. */

//global char buffers to store initials/score
char player1initials[14];/*!< Buffer for printing Initials and Top Score 1.*/
char player2initials[14];/*!< Buffer for printing Initials and Top Score 2.*/
char player3initials[14];/*!< Buffer for printing Initials and Top Score 3.*/

//difficulty variable - hazards fall at 2 pixels per refresh
int fall = 2;/*!< Increments hazards each Iteration by the Integer stored. */

//global variables for movement (pixelNinja)
int a1 = 22;
int a2 = 24;
int a3 = 23;
int a4 = 22;
int a5 = 22;
int a6 = 24;
int a7 = 25;
int a8 = 20;
int a9 = 20;
int a10 = 26;
int a11 = 26;
int a12 = 26;
int a13 = 24;
int a14 = 19;
int a15 = 20;
int a16 = 21;

//global variable for hazard X co-ordinates
int randX1;/*!< X co-ordinate for Hazard 1. */
int randX2;/*!< X co-ordinate for Hazard 2. */
int randX3;/*!< X co-ordinate for Hazard 3. */
int randX4;/*!< X co-ordinate for Hazard 4. */
int randX5;/*!< X co-ordinate for Hazard 5. */
int randX6;/*!< X co-ordinate for Hazard 6. */

//global variable for hazard Y co-ordinates
int randY1 = 1;/*!< Y co-ordinate for Hazard 1. */
int randY2 = 1;/*!< Y co-ordinate for Hazard 2. */
int randY3 = 1;/*!< Y co-ordinate for Hazard 3. */
int randY4 = 1;/*!< Y co-ordinate for Hazard 4. */
int randY5 = 1;/*!< Y co-ordinate for Hazard 5. */
int randY6 = 1;/*!< Y co-ordinate for Hazard 6. */

//integers for changing struct ouput states
int state1 = 0;/*!< State number for Output 1.*/
int state2 = 0;/*!< State number for output 2.*/
int state3 = 0;/*!< State number for output 3.*/

/**
*/
void write();

/**
*/
void read();

/**
*/
void timerExpiredA();

/**
*/
void timerExpiredB();

/**
*/
void randomise();

/**
*/
void drawBackground();

/**
*/
void drawWelcome();

/**
*/
void drawNinja();

/**
*/
void ninjaBoundaries();

/**
*/
void resetGame();

/**
*/
void drawHazards();

/**
*/
void hazardFall();

/**
*/
void startrek();

/**
*/
void refreshCursor1();

/**
*/
void refreshCursor2();

/**
*/
void refreshCursor3();
/**
*/
void actionbuttons();

/**
Uses a counter and Joystick directions for navigation
Presents user with options
@param mainOption - integer to increment / decrement
*/
void mainMenu();

/**
*/
void drawMainMenu();

/**
Uses a counter and Joystick directions for navigation
Presents user with options
@param exitOption - integer to increment / decrement
*/
void exitMenu();

/**
*/
void ninjaLeft();

/**
*/
void ninjaRight();

/**
*/
void drawExitMenu();

/**
Uses a counter and Joystick directions for navigation
Presents user with options
@param option - integer to incremenet / decrement
*/
void optionsMenu();

/**
*/
void drawOptionsMenu();

/**
Uses a counter and Joystick directions for navigation
Presents user the options
@param subOption - integer to increment / decrement
*/
void difficultyMenu();

/**
*/
void drawDifficultyMenu();

/**
Uses a counter and Joystick directions for navigation
Presents user the options
@param fxOption - integer to increment / decrement
*/
void soundFXMenu();

/**
*/
void drawSoundFXMenu();

/**
*/
void gameLoop();

/**
*/
void newScore();

/**
Uses a counter and Joystick directions to navigate the exitMenu
Presents user with options
@param exitFlag - integer set to break main loop and return to the main menu 
@param exitOption - integer to increment / decrement
*/
void game();


/**
*/
void scores();

/**
*/
void optionsMenu();

/**
*/
void calibrateJoystick();

/**
*/
void updateJoystick();

/**
*/
void screenOff();

/**
*/
void idleMode();
