#ifndef HEXAPOD_LEG_GROUP_H
#define HEXAPOD_LEG_GROUP_H

#define NUM_STEPS 20
#define STEP_DELAY 0.015

#include "mbed.h"
#include "PCA9685.h"
#include "HEXAPOD_LEG.h"
#include "angles_9.h"
#include "global_definitions.h"

class Tripod {
    
    public:
        Tripod(PCA9685 Board, Hexapod_Leg Leg_1, Hexapod_Leg Leg_2, Hexapod_Leg Leg_3, int group, int start_point);
        void gait_smooth(void);
        void gait_step(void);
        void set_gait_start(int start_point);
        void set_direction(int dir);
        
    public:
        //int direction;
        
        
    private:
        void sweep_step_group(void);
        
        
    private:
        Hexapod_Leg leg_1;
        Hexapod_Leg leg_2;
        Hexapod_Leg leg_3;
        int group_number;
        PCA9685 board;
        
        int current_state;
        int next_state;
        
        
        
        int i;
        
        Ticker group_ticker;
        
};

#endif