#include "Tripod.h"

Tripod::Tripod(PCA9685 Board, Hexapod_Leg Leg_1, Hexapod_Leg Leg_2, Hexapod_Leg Leg_3, int group, int start_point) :

    leg_1(Leg_1),
    leg_2(Leg_2),
    leg_3(Leg_3),
    group_number(group),
    board(Board),

    current_state(0),
    next_state(start_point++),
    i(0)

{
    //direction = 0;
}

/*
void Tripod::set_direction(int dir)
{

    direction = dir;

}
*/
/*
void Tripod::set_gait_start(int start_point)
{

    if (start_point > 5) {
        start_point = 5;
    }
    if (start_point < 0) {
        start_point = 0;
    }

    i = 0;

    current_state = start_point;
    next_state = start_point++;

}
*/



void Tripod::gait_step(void)
{
    int d1 = (direction + 0)%6;
    int d5 = (direction + 4)%6;
    int d3 = (direction + 2)%6;
    int d4 = (direction + 3)%6;
    int d2 = (direction + 1)%6;
    int d6 = (direction + 5)%6;

    switch(group_number) {
        case 1:



            leg_1.set_leg_position(all_leg_angles[d1][next_state]);
            leg_2.set_leg_position(all_leg_angles[d5][next_state]);
            leg_3.set_leg_position(all_leg_angles[d3][next_state]);

            next_state++;
            if (next_state > 5) {
                next_state = 1;
            }
            break;
        case 2:



            leg_1.set_leg_position(all_leg_angles[d4][next_state]);
            leg_2.set_leg_position(all_leg_angles[d2][next_state]);
            leg_3.set_leg_position(all_leg_angles[d6][next_state]);

            next_state++;
            if (next_state > 5) {
                next_state = 1;
            }
            break;
        default:

            break;
    }

    //i2c.stop();
    board.update();

}

void Tripod::sweep_step_group(void)
{

    switch (group_number) {

        case 1: {

            int d1 = (direction + 0)%6;
            int d5 = (direction + 4)%6;
            int d3 = (direction + 2)%6;

            float an_a_1 = (all_leg_angles[d1][current_state].a + ((all_leg_angles[d1][next_state].a - all_leg_angles[d1][current_state].a) / NUM_STEPS) * i);
            float an_b_1 = (all_leg_angles[d1][current_state].b + ((all_leg_angles[d1][next_state].b - all_leg_angles[d1][current_state].b) / NUM_STEPS) * i);
            float an_c_1 = (all_leg_angles[d1][current_state].c + ((all_leg_angles[d1][next_state].c - all_leg_angles[d1][current_state].c) / NUM_STEPS) * i);

            float an_a_2 = (all_leg_angles[d5][current_state].a + ((all_leg_angles[d5][next_state].a - all_leg_angles[d5][current_state].a) / NUM_STEPS) * i);
            float an_b_2 = (all_leg_angles[d5][current_state].b + ((all_leg_angles[d5][next_state].b - all_leg_angles[d5][current_state].b) / NUM_STEPS) * i);
            float an_c_2 = (all_leg_angles[d5][current_state].c + ((all_leg_angles[d5][next_state].c - all_leg_angles[d5][current_state].c) / NUM_STEPS) * i);

            float an_a_3 = (all_leg_angles[d3][current_state].a + ((all_leg_angles[d3][next_state].a - all_leg_angles[d3][current_state].a) / NUM_STEPS) * i);
            float an_b_3 = (all_leg_angles[d3][current_state].b + ((all_leg_angles[d3][next_state].b - all_leg_angles[d3][current_state].b) / NUM_STEPS) * i);
            float an_c_3 = (all_leg_angles[d3][current_state].c + ((all_leg_angles[d3][next_state].c - all_leg_angles[d3][current_state].c) / NUM_STEPS) * i);

            leg_1.set_joint_angles(an_a_1, an_b_1, an_c_1);
            leg_2.set_joint_angles(an_a_2, an_b_2, an_c_2);
            leg_3.set_joint_angles(an_a_3, an_b_3, an_c_3);

            board.update();
            i++;

            if (i > NUM_STEPS) {
                group_ticker.detach();
                i = 0;
            }

        }
        break;
        case 2: {

            int d4 = (direction + 3)%6;
            int d2 = (direction + 1)%6;
            int d6 = (direction + 5)%6;

            float an_a_1 = (all_leg_angles[d4][current_state].a + ((all_leg_angles[d4][next_state].a - all_leg_angles[d4][current_state].a) / NUM_STEPS) * i);
            float an_b_1 = (all_leg_angles[d4][current_state].b + ((all_leg_angles[d4][next_state].b - all_leg_angles[d4][current_state].b) / NUM_STEPS) * i);
            float an_c_1 = (all_leg_angles[d4][current_state].c + ((all_leg_angles[d4][next_state].c - all_leg_angles[d4][current_state].c) / NUM_STEPS) * i);

            float an_a_2 = (all_leg_angles[d2][current_state].a + ((all_leg_angles[d2][next_state].a - all_leg_angles[d2][current_state].a) / NUM_STEPS) * i);
            float an_b_2 = (all_leg_angles[d2][current_state].b + ((all_leg_angles[d2][next_state].b - all_leg_angles[d2][current_state].b) / NUM_STEPS) * i);
            float an_c_2 = (all_leg_angles[d2][current_state].c + ((all_leg_angles[d2][next_state].c - all_leg_angles[d2][current_state].c) / NUM_STEPS) * i);

            float an_a_3 = (all_leg_angles[d6][current_state].a + ((all_leg_angles[d6][next_state].a - all_leg_angles[d6][current_state].a) / NUM_STEPS) * i);
            float an_b_3 = (all_leg_angles[d6][current_state].b + ((all_leg_angles[d6][next_state].b - all_leg_angles[d6][current_state].b) / NUM_STEPS) * i);
            float an_c_3 = (all_leg_angles[d6][current_state].c + ((all_leg_angles[d6][next_state].c - all_leg_angles[d6][current_state].c) / NUM_STEPS) * i);

            leg_1.set_joint_angles(an_a_1, an_b_1, an_c_1);
            leg_2.set_joint_angles(an_a_2, an_b_2, an_c_2);
            leg_3.set_joint_angles(an_a_3, an_b_3, an_c_3);

            board.update();

            i++;

            if (i > NUM_STEPS) {
                group_ticker.detach();
                i = 0;
            }

        }
        break;
        default:

            break;

    }


}



void Tripod::gait_smooth(void)
{


    group_ticker.attach(this, &Tripod::sweep_step_group, STEP_DELAY);


    current_state = next_state;
    next_state++;

    if (next_state > 5) {
        next_state = 1;
    }


}