#include "Hexapod.h"

#define I2C_ADDR_1 0x82
#define I2C_ADDR_2 0x84

Hexapod::Hexapod(I2C i2c) :
    
    board_1(I2C_ADDR_1, i2c, 50),
    board_2(I2C_ADDR_2, i2c, 50),    
    
    //*GROUP 1*
    leg_1(board_1, leg_cent[1], leg_step[1], leg_out[0], true),
    leg_5(board_2, leg_cent[5], leg_step[5], leg_out[1], false),    
    leg_3(board_1, leg_cent[3], leg_step[3], leg_out[2], true),
    
    group_1(board_1, leg_1, leg_5, leg_3, 1, 0),
    //**
    
    //*GROUP 2*
    leg_4(board_2, leg_cent[4], leg_step[4], leg_out[0], false),
    leg_2(board_1, leg_cent[2], leg_step[2], leg_out[1], true),
    leg_6(board_2, leg_cent[6], leg_step[6], leg_out[2], false),
    
    group_2(board_2, leg_4, leg_2, leg_6, 2, 3),
    //**
    
    gait(group_1, group_2)

{
    
}

void Hexapod::init(void)
{
    
    board_1.init();
    board_2.init();
    
    /*
    group_1.set_gait_start(0);
    group_2.set_gait_start(5); 
    */
    
    stand();
    
}

void Hexapod::stand(void)
{
    leg_1.set_joint_angles(0, 0, -90);
    leg_2.set_joint_angles(0, 0, -90);
    leg_3.set_joint_angles(0, 0, -90);
    board_1.update();

    leg_4.set_joint_angles(0, 0, -90);
    leg_5.set_joint_angles(0, 0, -90);
    leg_6.set_joint_angles(0, 0, -90);
    board_2.update();
}

void Hexapod::walk(int Dir) 
{
    gait.stop();
    
    direction = Dir;
    
    gait.start(1);
       
}

void Hexapod::halt(void)
{
    
    gait.stop();
       
}