#ifndef HEXAPOD_H
#define HEXAPOD_H

#include "mbed.h"
#include "PCA9685.h"
#include "HEXAPOD_LEG.h"
#include "Tripod.h"
#include "Gait.h"
#include "global_definitions.h"

class Hexapod {
    
    public:
    Hexapod(I2C i2c);
    void init(void);
    void stand(void);
    void walk(int dir);
    void halt(void);
    
    private:
    PCA9685 board_1;
    PCA9685 board_2;
    
    Hexapod_Leg leg_1;
    Hexapod_Leg leg_5;
    Hexapod_Leg leg_3;
    
    Tripod group_1;
    
    Hexapod_Leg leg_4;
    Hexapod_Leg leg_2;
    Hexapod_Leg leg_6;  
    
    Tripod group_2;
    
    Gait gait;
    
    
    
};

#endif