#ifndef HEXAPOD_LEG_LIBRARY_H
#define HEXAPOD_LEG_LIBRARY_H

#include "PCA9685.h"
#include "mbed.h"
#include "structs.h"

class Hexapod_Leg {
    
    public:
    Hexapod_Leg(PCA9685 Driver, calibrated_leg_centre leg_cent, calibrated_leg_1_degree leg_step, leg_outputs leg_out, bool ON_RHS);       
    void set_joint_angles(float angle_a, float angle_b, float angle_c);
    void set_leg_position(leg_x_angles angles);
    
    private:
    float angle_to_pwm(float angle, char joint);
    
    private:
    float a_ref;
    float b_ref;   
    float c_ref;
        
    float a_1deg;
    float b_1deg;
    float c_1deg;
    
    int a_pin;
    int b_pin;
    int c_pin;
    
    bool RHS;
    
    PCA9685 driver;

};




#endif