#ifndef HEXAPOD_LEG_STRUCTS_H
#define HEXAPOD_LEG_STRUCTS_H

struct leg_angles

{    

    float a;    //Body Joint
    float b;    //Mid Joint
    float c;    //End Joint
    
};

//Calibrated centre positions for all six legs

typedef const struct leg_angles calibrated_leg_centre;

calibrated_leg_centre leg_cent[7] = 
{
//    A     B     C
    {0,    0,    0   },         //Dummy Leg for  better structure
    {1520, 1570, 2474},         //LEG 1
    {1500, 1494, 2440},         //LEG 2
    {1535, 1449, 2524},         //LEG 3
    {1472, 1537, 485 },         //LEG 4
    {1504, 1520, 587 },         //LEG 5
    {1455, 1493, 553 },         //LEG 6
};


typedef const struct leg_angles calibrated_leg_1_degree;

calibrated_leg_1_degree leg_step[7] = 
{
//      A       B       C
    {0,      0,      0     },   //Dummy Leg for  better structure
    {10.444, 10.500, 10.778},   //LEG 1
    {10.722, 10.811, 10.478},   //LEG 2
    {10.633, 10.644, 10.822},   //LEG 3
    {10.744, 10.700, 10.478},   //LEG 4
    {10.744, 10.511, 10.811},   //LEG 5
    {10.733, 11.011, 10.478},   //LEG 6
};


struct pwm_outputs 

{    
    int a;
    int b;
    int c;
    
};


typedef const struct pwm_outputs leg_outputs;

leg_outputs leg_out[3] = 
{
//   A   B   C
    {0,  1,  2},  //FRONT LEG
    {3,  4,  5},  //MID LEG
    {6, 7, 8},  //REAR LEG
};

typedef const struct leg_angles leg_x_angles;      
        
#endif